/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.text.CharacterIterator;
import org.apache.xerces.impl.xpath.regex.REUtil;

public class Match
implements Cloneable {
    int[] beginpos = null;
    int[] endpos = null;
    int nofgroups = 0;
    CharacterIterator ciSource = null;
    String strSource = null;
    char[] charSource = null;

    public synchronized Object clone() {
        Match match = new Match();
        if (this.nofgroups > 0) {
            match.setNumberOfGroups(this.nofgroups);
            if (this.ciSource != null) {
                match.setSource(this.ciSource);
            }
            if (this.strSource != null) {
                match.setSource(this.strSource);
            }
            for (int i2 = 0; i2 < this.nofgroups; ++i2) {
                match.setBeginning(i2, this.getBeginning(i2));
                match.setEnd(i2, this.getEnd(i2));
            }
        }
        return match;
    }

    protected void setNumberOfGroups(int n2) {
        int n3 = this.nofgroups;
        this.nofgroups = n2;
        if (n3 <= 0 || n3 < n2 || n2 * 2 < n3) {
            this.beginpos = new int[n2];
            this.endpos = new int[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.beginpos[i2] = -1;
            this.endpos[i2] = -1;
        }
    }

    protected void setSource(CharacterIterator characterIterator) {
        this.ciSource = characterIterator;
        this.strSource = null;
        this.charSource = null;
    }

    protected void setSource(String string) {
        this.ciSource = null;
        this.strSource = string;
        this.charSource = null;
    }

    protected void setSource(char[] cArray) {
        this.ciSource = null;
        this.strSource = null;
        this.charSource = cArray;
    }

    protected void setBeginning(int n2, int n3) {
        this.beginpos[n2] = n3;
    }

    protected void setEnd(int n2, int n3) {
        this.endpos[n2] = n3;
    }

    public int getNumberOfGroups() {
        if (this.nofgroups <= 0) {
            throw new IllegalStateException("A result is not set.");
        }
        return this.nofgroups;
    }

    public int getBeginning(int n2) {
        if (this.beginpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        return this.beginpos[n2];
    }

    public int getEnd(int n2) {
        if (this.endpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        return this.endpos[n2];
    }

    public String getCapturedText(int n2) {
        if (this.beginpos == null) {
            throw new IllegalStateException("match() has never been called.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        int n3 = this.beginpos[n2];
        int n4 = this.endpos[n2];
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        String string = this.ciSource != null ? REUtil.substring(this.ciSource, n3, n4) : (this.strSource != null ? this.strSource.substring(n3, n4) : new String(this.charSource, n3, n4 - n3));
        return string;
    }
}

