/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.AbstractList;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.xs.datatypes.ObjectList;

public class ListDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        return string;
    }

    @Override
    public int getDataLength(Object object) {
        return ((ListData)object).getLength();
    }

    static final class ListData
    extends AbstractList
    implements ObjectList {
        final Object[] data;
        private String canonical;

        public ListData(Object[] objectArray) {
            this.data = objectArray;
        }

        @Override
        public synchronized String toString() {
            if (this.canonical == null) {
                int n2 = this.data.length;
                StringBuffer stringBuffer = new StringBuffer();
                if (n2 > 0) {
                    stringBuffer.append(this.data[0].toString());
                }
                for (int i2 = 1; i2 < n2; ++i2) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.data[i2].toString());
                }
                this.canonical = stringBuffer.toString();
            }
            return this.canonical;
        }

        @Override
        public int getLength() {
            return this.data.length;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ListData)) {
                return false;
            }
            int n2 = this.data.length;
            Object[] objectArray = ((ListData)object).data;
            if (n2 != objectArray.length) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.data[i2].equals(objectArray[i2])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                n2 ^= this.data[i2].hashCode();
            }
            return n2;
        }

        @Override
        public boolean contains(Object object) {
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (object != this.data[i2]) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object item(int n2) {
            if (n2 < 0 || n2 >= this.data.length) {
                return null;
            }
            return this.data[n2];
        }

        public Object get(int n2) {
            if (n2 >= 0 && n2 < this.data.length) {
                return this.data[n2];
            }
            throw new IndexOutOfBoundsException("Index: " + n2);
        }

        @Override
        public int size() {
            return this.getLength();
        }
    }
}

