/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.xs.datatypes.XSDouble;

public class DoubleDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2552;
    }

    @Override
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "double"});
        }
    }

    @Override
    public int compare(Object object, Object object2) {
        return ((XDouble)object).compareTo((XDouble)object2);
    }

    @Override
    public boolean isIdentical(Object object, Object object2) {
        if (object2 instanceof XDouble) {
            return ((XDouble)object).isIdentical((XDouble)object2);
        }
        return false;
    }

    static boolean isPossibleFP(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+' || c2 == 'E' || c2 == 'e') continue;
            return false;
        }
        return true;
    }

    private static final class XDouble
    implements XSDouble {
        private final double value;
        private String canonical;

        public XDouble(String string) throws NumberFormatException {
            if (DoubleDV.isPossibleFP(string)) {
                this.value = Double.parseDouble(string);
            } else if (string.equals("INF")) {
                this.value = Double.POSITIVE_INFINITY;
            } else if (string.equals("-INF")) {
                this.value = Double.NEGATIVE_INFINITY;
            } else if (string.equals("NaN")) {
                this.value = Double.NaN;
            } else {
                throw new NumberFormatException(string);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XDouble)) {
                return false;
            }
            XDouble xDouble = (XDouble)object;
            if (this.value == xDouble.value) {
                return true;
            }
            return this.value != this.value && xDouble.value != xDouble.value;
        }

        public int hashCode() {
            if (this.value == 0.0) {
                return 0;
            }
            long l2 = Double.doubleToLongBits(this.value);
            return (int)(l2 ^ l2 >>> 32);
        }

        public boolean isIdentical(XDouble xDouble) {
            if (xDouble == this) {
                return true;
            }
            if (this.value == xDouble.value) {
                return this.value != 0.0 || Double.doubleToLongBits(this.value) == Double.doubleToLongBits(xDouble.value);
            }
            return this.value != this.value && xDouble.value != xDouble.value;
        }

        private int compareTo(XDouble xDouble) {
            double d2 = xDouble.value;
            if (this.value < d2) {
                return -1;
            }
            if (this.value > d2) {
                return 1;
            }
            if (this.value == d2) {
                return 0;
            }
            if (this.value != this.value) {
                if (d2 != d2) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Double.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Double.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Double.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int n2;
                        int n3 = this.canonical.length();
                        char[] cArray = new char[n3 + 3];
                        this.canonical.getChars(0, n3, cArray, 0);
                        int n4 = n2 = cArray[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0 || this.value <= -1.0) {
                            int n5;
                            int n6;
                            for (n6 = n5 = this.canonical.indexOf(46); n6 > n2; --n6) {
                                cArray[n6] = cArray[n6 - 1];
                            }
                            cArray[n2] = 46;
                            while (cArray[n3 - 1] == '0') {
                                --n3;
                            }
                            if (cArray[n3 - 1] == '.') {
                                // empty if block
                            }
                            int n7 = ++n3;
                            cArray[n7] = 69;
                            n6 = n5 - n2;
                            int n8 = ++n3;
                            ++n3;
                            cArray[n8] = (char)(n6 + 48);
                        } else {
                            int n9 = n2 + 1;
                            while (cArray[n9] == '0') {
                                ++n9;
                            }
                            cArray[n2 - 1] = cArray[n9];
                            cArray[n2] = 46;
                            int n10 = n9 + 1;
                            int n11 = n2 + 1;
                            while (n10 < n3) {
                                cArray[n11] = cArray[n10];
                                ++n10;
                                ++n11;
                            }
                            if ((n3 -= n9 - n2) == n2 + 1) {
                                cArray[n3++] = 48;
                            }
                            cArray[n3++] = 69;
                            cArray[n3++] = 45;
                            n10 = n9 - n2;
                            cArray[n3++] = (char)(n10 + 48);
                        }
                        this.canonical = new String(cArray, 0, n3);
                    }
                }
            }
            return this.canonical;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }
}

