/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.xs.datatypes.XSDecimal;

public class DecimalDV
extends TypeValidator {
    @Override
    public final short getAllowedFacets() {
        return 4088;
    }

    @Override
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
        }
    }

    @Override
    public final int compare(Object object, Object object2) {
        return ((XDecimal)object).compareTo((XDecimal)object2);
    }

    @Override
    public final int getTotalDigits(Object object) {
        return ((XDecimal)object).totalDigits;
    }

    @Override
    public final int getFractionDigits(Object object) {
        return ((XDecimal)object).fracDigits;
    }

    static class XDecimal
    implements XSDecimal {
        int sign = 1;
        int totalDigits = 0;
        int intDigits = 0;
        int fracDigits = 0;
        String ivalue = "";
        String fvalue = "";
        boolean integer = false;
        private String canonical;

        XDecimal(String string) throws NumberFormatException {
            this.initD(string);
        }

        XDecimal(String string, boolean bl) throws NumberFormatException {
            if (bl) {
                this.initI(string);
            } else {
                this.initD(string);
            }
        }

        void initD(String string) throws NumberFormatException {
            int n2;
            int n3 = string.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (string.charAt(0) == '+') {
                n4 = 1;
            } else if (string.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                if (string.charAt(n5) != '.') {
                    throw new NumberFormatException();
                }
                n6 = n5 + 1;
                n7 = n3;
            }
            if (n4 == n5 && n6 == n7) {
                throw new NumberFormatException();
            }
            while (n7 > n6 && string.charAt(n7 - 1) == '0') {
                --n7;
            }
            for (int i2 = n6; i2 < n7; ++i2) {
                if (TypeValidator.isDigit(string.charAt(i2))) continue;
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            this.fracDigits = n7 - n6;
            this.totalDigits = this.intDigits + this.fracDigits;
            if (this.intDigits > 0) {
                this.ivalue = string.substring(n2, n5);
                if (this.fracDigits > 0) {
                    this.fvalue = string.substring(n6, n7);
                }
            } else if (this.fracDigits > 0) {
                this.fvalue = string.substring(n6, n7);
            } else {
                this.sign = 0;
            }
        }

        void initI(String string) throws NumberFormatException {
            int n2;
            int n3 = string.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            if (string.charAt(0) == '+') {
                n4 = 1;
            } else if (string.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                throw new NumberFormatException();
            }
            if (n4 == n5) {
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            this.fracDigits = 0;
            this.totalDigits = this.intDigits;
            if (this.intDigits > 0) {
                this.ivalue = string.substring(n2, n5);
            } else {
                this.sign = 0;
            }
            this.integer = true;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XDecimal)) {
                return false;
            }
            XDecimal xDecimal = (XDecimal)object;
            if (this.sign != xDecimal.sign) {
                return false;
            }
            if (this.sign == 0) {
                return true;
            }
            return this.intDigits == xDecimal.intDigits && this.fracDigits == xDecimal.fracDigits && this.ivalue.equals(xDecimal.ivalue) && this.fvalue.equals(xDecimal.fvalue);
        }

        public int compareTo(XDecimal xDecimal) {
            if (this.sign != xDecimal.sign) {
                return this.sign > xDecimal.sign ? 1 : -1;
            }
            if (this.sign == 0) {
                return 0;
            }
            return this.sign * this.intComp(xDecimal);
        }

        private int intComp(XDecimal xDecimal) {
            if (this.intDigits != xDecimal.intDigits) {
                return this.intDigits > xDecimal.intDigits ? 1 : -1;
            }
            int n2 = this.ivalue.compareTo(xDecimal.ivalue);
            if (n2 != 0) {
                return n2 > 0 ? 1 : -1;
            }
            n2 = this.fvalue.compareTo(xDecimal.fvalue);
            return n2 == 0 ? 0 : (n2 > 0 ? 1 : -1);
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.makeCanonical();
            }
            return this.canonical;
        }

        private void makeCanonical() {
            if (this.sign == 0) {
                this.canonical = this.integer ? "0" : "0.0";
                return;
            }
            if (this.integer && this.sign > 0) {
                this.canonical = this.ivalue;
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(this.totalDigits + 3);
            if (this.sign == -1) {
                stringBuffer.append('-');
            }
            if (this.intDigits != 0) {
                stringBuffer.append(this.ivalue);
            } else {
                stringBuffer.append('0');
            }
            if (!this.integer) {
                stringBuffer.append('.');
                if (this.fracDigits != 0) {
                    stringBuffer.append(this.fvalue);
                } else {
                    stringBuffer.append('0');
                }
            }
            this.canonical = stringBuffer.toString();
        }

        @Override
        public BigDecimal getBigDecimal() {
            if (this.sign == 0) {
                return new BigDecimal(BigInteger.ZERO);
            }
            return new BigDecimal(this.toString());
        }

        @Override
        public BigInteger getBigInteger() throws NumberFormatException {
            if (this.fracDigits != 0) {
                throw new NumberFormatException();
            }
            if (this.sign == 0) {
                return BigInteger.ZERO;
            }
            if (this.sign == 1) {
                return new BigInteger(this.ivalue);
            }
            return new BigInteger("-" + this.ivalue);
        }

        @Override
        public long getLong() throws NumberFormatException {
            if (this.fracDigits != 0) {
                throw new NumberFormatException();
            }
            if (this.sign == 0) {
                return 0L;
            }
            if (this.sign == 1) {
                return Long.parseLong(this.ivalue);
            }
            return Long.parseLong("-" + this.ivalue);
        }

        @Override
        public int getInt() throws NumberFormatException {
            if (this.fracDigits != 0) {
                throw new NumberFormatException();
            }
            if (this.sign == 0) {
                return 0;
            }
            if (this.sign == 1) {
                return Integer.parseInt(this.ivalue);
            }
            return Integer.parseInt("-" + this.ivalue);
        }

        @Override
        public short getShort() throws NumberFormatException {
            if (this.fracDigits != 0) {
                throw new NumberFormatException();
            }
            if (this.sign == 0) {
                return 0;
            }
            if (this.sign == 1) {
                return Short.parseShort(this.ivalue);
            }
            return Short.parseShort("-" + this.ivalue);
        }

        @Override
        public byte getByte() throws NumberFormatException {
            if (this.fracDigits != 0) {
                throw new NumberFormatException();
            }
            if (this.sign == 0) {
                return 0;
            }
            if (this.sign == 1) {
                return Byte.parseByte(this.ivalue);
            }
            return Byte.parseByte("-" + this.ivalue);
        }
    }
}

