/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable;
    private static final char[] lookUpHexAlphabet;

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = n2 * 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = byArray[i2];
            if (n4 < 0) {
                n4 += 256;
            }
            cArray[i2 * 2] = lookUpHexAlphabet[n4 >> 4];
            cArray[i2 * 2 + 1] = lookUpHexAlphabet[n4 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n3 = n2 / 2;
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5;
            char c2 = cArray[i2 * 2];
            int n6 = n5 = c2 < '\u0080' ? hexNumberTable[c2] : -1;
            if (n5 == -1) {
                return null;
            }
            c2 = cArray[i2 * 2 + 1];
            int n7 = n4 = c2 < '\u0080' ? hexNumberTable[c2] : -1;
            if (n4 == -1) {
                return null;
            }
            byArray[i2] = (byte)(n5 << 4 | n4);
        }
        return byArray;
    }

    static {
        int n2;
        hexNumberTable = new byte[128];
        lookUpHexAlphabet = new char[16];
        for (n2 = 0; n2 < 128; ++n2) {
            HexBin.hexNumberTable[n2] = -1;
        }
        for (n2 = 57; n2 >= 48; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 48);
        }
        for (n2 = 70; n2 >= 65; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 65 + 10);
        }
        for (n2 = 102; n2 >= 97; --n2) {
            HexBin.hexNumberTable[n2] = (byte)(n2 - 97 + 10);
        }
        for (n2 = 0; n2 < 10; ++n2) {
            HexBin.lookUpHexAlphabet[n2] = (char)(48 + n2);
        }
        for (n2 = 10; n2 <= 15; ++n2) {
            HexBin.lookUpHexAlphabet[n2] = (char)(65 + n2 - 10);
        }
    }
}

