/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.util.Stack;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;
import oracle.xml.xti.XTIUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.LexicalHandler;

public class XTIDecoder
implements XTIConstants {
    XMLError err = null;
    XTIStream xtiStream = null;
    byte[] currentPage = null;
    int currentPageNumber = 0;
    SAXAttrList attrlist = new SAXAttrList(100);
    private Stack<DecodeElem> elements = new Stack();
    LexicalHandler lexHdlr = null;

    XTIDecoder(XTIStream xTIStream) {
        this.xtiStream = xTIStream;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
        this.xtiStream.setXMLError(xMLError);
    }

    XMLError getXMLError() {
        if (this.err == null) {
            this.err = new XMLError();
        }
        return this.err;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexHdlr = lexicalHandler;
    }

    public void decode(ContentHandler contentHandler, ErrorHandler errorHandler) throws XTIException {
        try {
            int n2 = this.readHeader();
            int n3 = 0;
            DecodeElem decodeElem = null;
            byte by = 0;
            do {
                by = this.decodeNodes(n2, contentHandler, errorHandler);
                n3 = n2;
                n2 = this.getChildAddress(n2);
                if (by == 1 && n2 == 0 && !this.elements.empty()) {
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
                while (n2 == 0 && n3 != 0) {
                    n2 = this.getNextAddress(n3);
                    if (n2 != 0) continue;
                    n3 = this.getParentAddress(n3);
                    if (this.elements.empty()) continue;
                    decodeElem = this.elements.pop();
                    contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
                }
            } while (n2 != 0);
            while (!this.elements.empty()) {
                decodeElem = this.elements.pop();
                contentHandler.endElement(decodeElem.getURI(), decodeElem.getLocalname(), decodeElem.getQname());
            }
            contentHandler.endDocument();
        }
        catch (Exception exception) {
            throw new XTIException(exception);
        }
    }

    boolean isLastChild(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        byte by = this.currentPage[n3];
        return (by & 0x10) > 0;
    }

    int readHeader() {
        byte[] byArray = this.xtiStream.readXTINPage(0, false);
        byte by = (byte)(byArray[0] & 0xF);
        byte by2 = (byte)(by & 9);
        if ((by & 9) > 0) {
            this.xtiStream.setInterleaving(true);
        }
        int n2 = XTIUtil.byteArrayToInt(byArray, 8);
        int n3 = XTIUtil.byteArrayToInt(byArray, 4);
        this.xtiStream.setTotalXTINPages(n3);
        this.xtiStream.readXTICPage(0, false);
        return n2;
    }

    int getChildAddress(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = (n2 & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n3 + 12);
    }

    int getNextAddress(int n2) {
        this.getXTINPageFromAddress(n2);
        if (this.isLastChild(n2)) {
            return 0;
        }
        int n3 = (n2 & 0xFF) * 32;
        int n4 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 24);
        return n4;
    }

    int getPreviousAddress(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = (n2 & 0xFF) * 32;
        int n4 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 16);
        if (this.isLastChild(n4)) {
            return 0;
        }
        return n4;
    }

    int getParentAddress(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = (n2 & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n3 + 20);
    }

    int getAttributeAddress(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = (n2 & 0xFF) * 32;
        return XTIUtil.byteArrayToInt(this.currentPage, n3 + 28);
    }

    String getPrefix(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        long l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
        QxName qxName = this.getQxName(l2);
        return qxName.getPrefix();
    }

    String getLocalName(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        long l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
        QxName qxName = this.getQxName(l2);
        return qxName.getLocalPart();
    }

    String getQName(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        byte by = (byte)(this.currentPage[n3] & 0xF);
        String string = null;
        switch (by) {
            case 1: 
            case 2: {
                long l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
                QxName qxName = this.getQxName(l2);
                string = qxName.getQName();
                break;
            }
            case 7: {
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n4);
                n3 = n4 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n3);
            }
        }
        return string;
    }

    String getXMLEncoding() {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        if ((by & 2) == 0) {
            return "UTF-8";
        }
        int n2 = XTIUtil.byteArrayToInt(byArray, 13);
        byte[] byArray2 = this.getXTICPageFromAddress(n2);
        int n3 = n2 & 0xFFF;
        String string = XTIUtil.getStringFromArray(byArray2, n3);
        return string;
    }

    String getXmlVersion() {
        return "1.0";
    }

    boolean getStandalone() {
        byte[] byArray = this.xtiStream.getXTINPageNumber(0, false);
        byte by = byArray[17];
        return (by & 8) == 8;
    }

    String getNamespaceURI(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        long l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
        QxName qxName = this.getQxName(l2);
        return qxName.getNamespaceURI();
    }

    String getNodeValue(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        byte by = (byte)(this.currentPage[n3] & 0xF);
        String string = null;
        switch (by) {
            case 3: 
            case 4: 
            case 8: {
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n4);
                int n5 = n4 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n5);
                break;
            }
            case 7: {
                int n6 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 4);
                byte[] byArray = this.getXTICPageFromAddress(n6);
                int n7 = n6 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n7);
                break;
            }
            case 2: {
                int n8 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 4 + 12);
                byte[] byArray = this.getXTICPageFromAddress(n8);
                int n9 = n8 & 0xFFF;
                string = XTIUtil.getStringFromArray(byArray, n9);
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    byte getNodeType(int n2) {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        byte by = (byte)(this.currentPage[n3] & 0xF);
        return by;
    }

    public boolean isNamespaceNode(int n2) {
        byte by = this.getNodeType(n2);
        if (by == 2) {
            this.getXTINPageFromAddress(n2);
            int n3 = n2 & 0xFF;
            n3 = 32 * n3;
            byte by2 = this.currentPage[n3 + 29];
            if (by2 == 2 || by2 == 4) {
                return true;
            }
        }
        return false;
    }

    private byte decodeNodes(int n2, ContentHandler contentHandler, ErrorHandler errorHandler) throws Exception {
        this.getXTINPageFromAddress(n2);
        int n3 = n2 & 0xFF;
        n3 = 32 * n3;
        byte by = (byte)(this.currentPage[n3] & 0xF);
        switch (by) {
            case 9: {
                contentHandler.startDocument();
                break;
            }
            case 1: {
                long l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
                QxName qxName = this.getQxName(l2);
                String string = qxName.getPrefix();
                String string2 = qxName.getLocalPart();
                String string3 = qxName.getNamespaceURI();
                int n4 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 28);
                this.decodeAttributes(n4);
                this.elements.push(new DecodeElem(string3, string, string2));
                contentHandler.startElement(string3, string2, qxName.getQName(), this.attrlist);
                this.attrlist.reset();
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                String string = this.getNodeValue(n2);
                if (by == 3) {
                    contentHandler.characters(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by == 8) {
                    this.lexHdlr.comment(string.toCharArray(), 0, string.length());
                    break;
                }
                if (by != 4) break;
                this.lexHdlr.startCDATA();
                contentHandler.characters(string.toCharArray(), 0, string.length());
                this.lexHdlr.endCDATA();
                break;
            }
            case 7: {
                String string = this.getNodeValue(n2);
                int n5 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 8);
                byte[] byArray = this.getXTICPageFromAddress(n5);
                int n6 = n5 & 0xFFF;
                String string4 = XTIUtil.getStringFromArray(byArray, n6);
                contentHandler.processingInstruction(string4, string);
                break;
            }
            default: {
                if (this.err == null) {
                    this.err = this.getXMLError();
                }
                this.err.error0(36005, 1);
                throw new XTIException(this.err.getMessage0(36005));
            }
        }
        return by;
    }

    private void decodeAttributes(int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        long l2 = 0L;
        while (n2 != 0) {
            this.getXTINPageFromAddress(n2);
            n3 = n2 & 0xFF;
            n3 = 32 * n3;
            l2 = XTIUtil.byteArrayToLong(this.currentPage, n3 + 4);
            QxName qxName = this.getQxName(l2);
            String string = this.getNodeValue(n2);
            this.attrlist.addAttr(qxName.getPrefix(), qxName.getLocalPart(), qxName.getQName(), string, true, 0, qxName.getNamespaceURI());
            n2 = XTIUtil.byteArrayToInt(this.currentPage, n3 + 24);
        }
    }

    public QxName getQxName(long l2) throws XTIException {
        if (l2 == 0L) {
            if (this.err == null) {
                this.err = this.getXMLError();
            }
            this.err.error0(36005, 1);
            throw new XTIException(this.err.getMessage0(36005));
        }
        QxName qxName = this.xtiStream.qnameCache.get(l2);
        if (qxName == null) {
            int n2 = (int)(l2 >> 32);
            int n3 = (int)l2;
            byte[] byArray = this.getXTICPageFromAddress(n3);
            int n4 = n3 & 0xFFF;
            int n5 = byArray[--n4];
            String string = "";
            String string2 = null;
            int n6 = 0;
            if (n5 != 0) {
                string = new String(byArray, n4 + 1, --n5);
                n6 = n4 + n5 + 2;
            } else {
                n6 = n4 + 1;
            }
            string2 = XTIUtil.getQNameFromArray(byArray, n6);
            byArray = this.getXTICPageFromAddress(n2);
            n6 = n4 = n2 & 0xFFF;
            String string3 = XTIUtil.getQNameFromArray(byArray, n4);
            qxName = QxNameHash.create(string3, string2, string);
            this.xtiStream.qnameCache.put(l2, qxName);
        }
        return qxName;
    }

    private void getXTINPageFromAddress(int n2) {
        int n3 = (n2 &= Integer.MAX_VALUE) >> 8;
        if (n3 != this.currentPageNumber || this.currentPageNumber == 0 && this.currentPage == null) {
            this.currentPageNumber = n3;
            this.currentPage = this.xtiStream.readXTINPage(n2 >> 8, false);
        }
    }

    private byte[] getXTICPageFromAddress(int n2) {
        return this.xtiStream.readXTICPage(n2 >> 12, false);
    }

    class DecodeElem
    implements XTIConstants {
        String uri = null;
        String prefix = null;
        String localname = null;

        DecodeElem(String string, String string2, String string3) {
            this.uri = string;
            this.prefix = string2;
            this.localname = string3;
        }

        String getURI() {
            return this.uri;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLocalname() {
            return this.localname;
        }

        String getQname() {
            if (this.prefix == null || this.prefix.equals("")) {
                return this.localname;
            }
            return this.prefix + ":" + this.localname;
        }
    }
}

