/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.util.XMLCompatible;
import oracle.xml.xpath.XPathConvertAsExpr;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEventVars;

public class XSLVariable
extends XSLNode
implements XSLConstants {
    private XSLExprBase exp;
    private NSName xslVarName;
    XPathConvertAsExpr asseq;
    private int iParam = -1;
    private boolean isSelectAttrSet = false;
    private boolean isTunnel = false;
    private boolean isRequired = false;

    XSLVariable(XSLStylesheet xSLStylesheet, String string) throws XSLException {
        super(xSLStylesheet);
        this.localName = string;
        this.elementType = 7;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "variable", this.getName().getExpandedName(), (byte)-1);
        }
        XSLTDebuggerTraceEventVars xSLTDebuggerTraceEventVars = null;
        HashMap<String, Object> hashMap = null;
        if (xSLTContext.getOSBDebugMode()) {
            hashMap = new HashMap<String, Object>(1);
            xSLTContext.getOsbDebugAttrStk().push(hashMap);
            hashMap.put("name", this.xslVarName);
            xSLTDebuggerTraceEventVars = new XSLTDebuggerTraceEventVars(this, false);
            xSLTContext.pushOSBDebugVar(xSLTDebuggerTraceEventVars);
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:" + this.localName);
        }
        XPathSequence xPathSequence = this.getValue(xSLTContext);
        xSLTContext.pushVariable(xPathSequence);
        if (xSLTContext.getOSBDebugMode()) {
            hashMap.put("value", xPathSequence);
            xSLTDebuggerTraceEventVars.setValue(xPathSequence);
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:" + this.localName);
            xSLTContext.getOsbDebugAttrStk().pop();
        }
        if (xSLTContext.isInDebugMode()) {
            int n2 = xSLTContext.xsl.getFrames().size();
            LinkedList linkedList = (LinkedList)xSLTContext.xsl.frameValues.get(n2 - 1);
            linkedList.add(xPathSequence);
            this.addJDWPDataAfter(this, (byte)-1, null);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == "name") {
                this.xslVarName = this.resolveQname(string4);
            } else if (string3 == "select") {
                this.exp = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
                this.isSelectAttrSet = true;
            } else if (string3 == "tunnel" && string4.equals("yes")) {
                this.isTunnel = true;
            } else if (string3 == "as") {
                OXMLSequenceType oXMLSequenceType = XPathSeqType.createSequenceType(string4, this, this.xss);
                this.asseq = new XPathConvertAsExpr(oXMLSequenceType);
            } else if (string3 == "required" && string4.equals("yes")) {
                this.isRequired = true;
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    boolean getIsSelectAttrSet() {
        return this.isSelectAttrSet;
    }

    @Override
    public void startContent() throws XSLException {
        if (this.xslVarName == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        } else if (this.parent.checkDuplicate(this)) {
            this.xss.err.error1(1050, 1, this.xslVarName.getQualifiedName());
        }
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        if (this.exp != null && this.children != null) {
            this.xss.err.error1(22066, 1, this.localName);
        }
        if (!this.isTopLevel() && this.localName != "with-param") {
            this.xss.pushVariable(this);
        }
    }

    public NSName getName() {
        return this.xslVarName;
    }

    XPathSequence getValue(XSLTContext xSLTContext) throws XSLException, XQException {
        if (this.isRequired) {
            throw new XQException("XTDE0050 parameter value is madatory");
        }
        XPathSequence xPathSequence = null;
        URL uRL = null;
        String string = xSLTContext.getDefaultCollation();
        if (this.baseURL != null) {
            uRL = xSLTContext.getBaseURL();
            xSLTContext.setBaseURL(this.baseURL);
        }
        this.setDefaultCollation(xSLTContext);
        if (this.exp != null) {
            this.exp.evaluate(xSLTContext);
            xPathSequence = (XPathSequence)((XPathSequence)xSLTContext.popExprValue()).clone();
            if (this.asseq != null) {
                this.asseq.convert(xPathSequence);
            }
        } else if (this.children != null) {
            xPathSequence = new XPathSequence(xSLTContext);
            XSLDocumentBuilder xSLDocumentBuilder = xSLTContext.allocXSLDocumentBuilder();
            XSLEventHandler xSLEventHandler = xSLTContext.allocXSLEventHandler();
            if (this.asseq != null) {
                xSLDocumentBuilder.setSequenceConstructor(xSLTContext, this.asseq);
            }
            xSLDocumentBuilder.setVariableContext(true);
            xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
            XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
            this.processChildren(xSLTContext);
            xSLEventHandler.flushEvents();
            XMLDocumentFragment xMLDocumentFragment = xSLDocumentBuilder.getResultFragment();
            xMLDocumentFragment.makeDocumentOrder(0);
            if (xSLDocumentBuilder.isSequenceConstructor()) {
                xPathSequence = (XPathSequence)xSLDocumentBuilder.getResultSequence();
            } else if (this.version >= 20) {
                if (this.baseURL != null) {
                    xMLDocumentFragment.setBaseURI(this.baseURL.toString());
                }
                xSLTContext.addSourceContext(xMLDocumentFragment, null);
                XPathItem xPathItem = xSLTContext.allocItem();
                xPathItem.setNode(xMLDocumentFragment);
                xPathSequence.appendItem(xPathItem);
            } else {
                XPathSequence.setDocumentFragmentValue(xPathSequence, xMLDocumentFragment);
            }
            xSLTContext.setEventHandler(xSLEventHandler2);
            xSLDocumentBuilder.setVariableContext(false);
            xSLTContext.freeXSLDocumentBuilder(xSLDocumentBuilder);
            xSLTContext.freeXSLEventHandler(xSLEventHandler);
        } else if (!XMLCompatible.useBuggyBehavior(21471097)) {
            xPathSequence = new XPathSequence(xSLTContext);
            if (this.asseq == null) {
                XPathItem xPathItem = xSLTContext.allocItem();
                xPathItem.setString(OXMLSequenceType.TSTRING, "");
                xPathSequence.appendItem(xPathItem);
            } else {
                this.asseq.convert(xPathSequence);
            }
        } else {
            xPathSequence = new XPathSequence(xSLTContext);
        }
        if (this.baseURL != null) {
            xSLTContext.setBaseURL(uRL);
        }
        xSLTContext.setDefaultCollation(string);
        return xPathSequence;
    }

    public XSLExprBase getExp() {
        return this.exp;
    }

    void setParamPos(int n2) {
        this.iParam = n2;
    }

    int getParamPos() {
        return this.iParam;
    }

    boolean isTunnel() {
        return this.isTunnel;
    }

    boolean hasDefault() {
        return this.exp != null || this.children != null;
    }
}

