/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.jdwp.XSLJDWPEventValue;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.util.XMLCompatible;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLAttribute;
import oracle.xml.xslt.XSLAttributeSet;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLElement;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFallback;
import oracle.xml.xslt.XSLForEach;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLKey;
import oracle.xml.xslt.XSLMiscElements;
import oracle.xml.xslt.XSLNumber;
import oracle.xml.xslt.XSLResultElement;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEvent;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLText;
import oracle.xml.xslt.XSLValueOf;
import oracle.xml.xslt.XSLVariable;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class XSLNode
implements XSLConstants,
NSResolver,
Locator {
    private String defaultcollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private boolean preserveSpace = false;
    private String XBase;
    protected URL baseURL;
    protected int nParams = 0;
    protected FastVector paramList;
    int nVars = 0;
    private HashMap<NSName, XSLVariable> varHash;
    XSLStylesheet xss;
    public FastVector children;
    protected HashMap prefixHash;
    protected HashSet<String> excludeNSSet;
    protected HashMap attrHash;
    protected int elementType = 3;
    String prefix;
    String localName;
    String namespace = "http://www.w3.org/1999/XSL/Transform";
    XSLNode parent;
    private int line;
    private int col;
    private String sysid;
    private boolean flushIncreamentalOutputFlag = false;
    private int codeIndexBegin;
    private int codeIndexEnd;
    protected XSLJDWPEventValue jdwpEventValue;
    private int endingline;
    protected String concatedAttrs = "";
    private int errId;
    private String[] errParams;
    private int errType;
    private XSLNode origNode;
    private boolean reportError;
    XSLAttributeSet[] attrsets;
    int numattrsets = 0;
    int xssImportPrecedence;
    int xssImportLevel;
    int version;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;

    public XSLNode() throws XSLException {
    }

    public XSLNode(XSLStylesheet xSLStylesheet) throws XSLException {
        this();
        this.xss = xSLStylesheet;
        this.jdwpEventValue = new XSLJDWPEventValue(xSLStylesheet);
    }

    public static boolean isReservedNamespace(String string) {
        if (string == null || string == "") {
            return false;
        }
        if ((string = string.intern()) == "http://www.w3.org/1999/XSL/Transform") {
            return true;
        }
        if (string == "http://www.w3.org/2005/xpath-functions") {
            return true;
        }
        if (string == "http://www.w3.org/XML/1998/namespace") {
            return true;
        }
        if (string == "http://www.w3.org/2001/XMLSchema") {
            return true;
        }
        return string == "http://www.w3.org/2001/XMLSchema-instance";
    }

    boolean includedInOSBDebugCallStack() {
        return false;
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getURI() {
        return this.namespace;
    }

    public String getQualifiedName() {
        if (this.prefix != "") {
            return this.prefix + ":" + this.localName;
        }
        return this.localName;
    }

    void setPrefix(String string) {
        this.prefix = string;
    }

    void setLocalName(String string) {
        this.localName = string;
    }

    void setURI(String string) {
        this.namespace = string;
    }

    public HashMap getPrefixHash() {
        return this.prefixHash;
    }

    public void setPrefixHash(HashMap hashMap) {
        this.prefixHash = hashMap;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        if (string == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string == "xmlns") {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixHash != null) {
            return (String)this.prefixHash.get(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "" || this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "" || this.namespace != "http://www.w3.org/1999/XSL/Transform" && string == "http://www.w3.org/1999/XSL/Transform" || this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "http://www.oracle.com/XSL/Transform/java") {
            if (this.attrHash == null) {
                this.attrHash = new HashMap(20);
            }
            this.attrHash.put(string3, string4);
        }
        if (string == "http://www.w3.org/XML/1998/namespace" && string3 == "space") {
            if (string4.equals("preserve")) {
                this.preserveSpace = true;
            } else if (string4.equals("default")) {
                this.preserveSpace = false;
            }
        }
        if (string == "http://www.w3.org/XML/1998/namespace" && string3 == "base") {
            this.XBase = string4;
        }
        if (this.version >= 20) {
            this.processStandardAttrs(string, string3, string4);
        }
    }

    private void processStandardAttrs(String string, String string2, String string3) {
        if (string2 == "default-collation" && this.isInXSLNamespace(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (!string4.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint") && !string4.equals(XSLTContext.caseblindString)) continue;
                this.defaultcollation = string4;
                return;
            }
            this.xss.err.error0(23015, 1);
        }
    }

    private boolean isInXSLNamespace(String string) {
        if (this.namespace == "" && string == "http://www.w3.org/1999/XSL/Transform") {
            return true;
        }
        return this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "";
    }

    protected void setDefaultCollation(XSLTContext xSLTContext) {
        if (this.version == 10) {
            return;
        }
        xSLTContext.setDefaultCollation(this.defaultcollation);
    }

    String getXBase() {
        return this.XBase;
    }

    static boolean isXMLBase11gCompatible(int n2) {
        return n2 == 10 && XMLCompatible.useBuggyBehavior(21842382);
    }

    protected void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    protected URL getBaseURL() {
        return this.baseURL;
    }

    protected void setContextBaseURL(XSLTContext xSLTContext) {
        if (this.baseURL != null) {
            xSLTContext.setBaseURL(this.baseURL);
        }
    }

    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "" || this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "" || this.namespace != "http://www.w3.org/1999/XSL/Transform" && string == "http://www.w3.org/1999/XSL/Transform" || this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "http://www.oracle.com/XSL/Transform/java") {
            if (this.attrHash == null) {
                return null;
            }
            return (String)this.attrHash.get(string2);
        }
        return null;
    }

    public void addNamespace(String string, String string2) throws XSLException {
        if (this.prefixHash == null) {
            this.prefixHash = new HashMap(20);
        } else if (this.parent != null && this.prefixHash == this.parent.prefixHash) {
            this.prefixHash = (HashMap)this.parent.prefixHash.clone();
        }
        this.prefixHash.put(string, string2);
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        if (this.reportError) {
            xMLError.setLocator(this);
            xMLError.error(this.errId, this.errType, this.errParams);
            this.clearError();
        }
    }

    static String constructSimpleContent(OXMLSequence oXMLSequence, XSLTContext xSLTContext, AttrValueTmpl attrValueTmpl) throws XSLException, XQException {
        String string = " ";
        if (attrValueTmpl != null) {
            string = attrValueTmpl.getValue(xSLTContext);
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        while (oXMLSequence.next()) {
            String string2;
            OXMLItem oXMLItem = oXMLSequence.getItem();
            if (oXMLItem.isNode()) {
                XMLNode xMLNode = oXMLItem.getNode();
                string2 = xMLNode.getText();
                if (xMLNode.getNodeType() == 3) {
                    if (string2.length() == 0 || xSLTContext.isStrippedWS(xMLNode)) continue;
                    if (bl || bl2 || string.length() == 0) {
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append(string);
                        stringBuilder.append(string2);
                    }
                    bl2 = true;
                    bl = false;
                    continue;
                }
                if (xMLNode.getNodeType() == 1 && !xSLTContext.isSrcWhiteSpacePreserving((XMLElement)xMLNode)) {
                    string2 = "";
                    for (XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild(); xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
                        if (xMLNode2.getNodeType() == 3) {
                            if (((XMLText)xMLNode2).isWhiteSpaceNode()) continue;
                            string2 = string2.concat(xMLNode2.getText());
                            continue;
                        }
                        string2 = string2.concat(xMLNode2.getText());
                    }
                }
            } else {
                string2 = oXMLItem.getLexicalValue();
            }
            bl2 = false;
            if (bl || string.length() == 0) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string);
                stringBuilder.append(string2);
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    public void startContent() throws XSLException, XQException {
        String string;
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && this.localName == "stylesheet" && (string = this.getAttribute("", "extension-element-prefixes")) != null) {
            this.xss.addExtensionNamespace(this, string);
        }
    }

    void endContent() throws XSLException, XQException {
        if (this.nVars != 0) {
            this.xss.popVariable(this.nVars);
        }
    }

    public void finalizeXSLNode() throws XSLException, XQException {
        if (this.children != null) {
            int n2;
            int n3 = this.children.size();
            XSLNode[] xSLNodeArray = new XSLNode[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                xSLNodeArray[n2] = (XSLNode)this.children.elementAt(n2);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                xSLNodeArray[n2].finalizeXSLNode();
            }
        }
    }

    public void processChildren(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        if (this.children != null) {
            int n2 = this.children.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XSLNode xSLNode = (XSLNode)this.children.elementAt(i2);
                if (xSLTContext.getIsExtElemErr() && this instanceof XSLResultElement && !(xSLNode instanceof XSLFallback)) continue;
                xMLError.setLocator(xSLNode);
                xSLNode.processAction(xSLTContext);
            }
        }
        if (this.nVars != 0) {
            xSLTContext.popVariable(this.nVars);
            if (xSLTContext.getOSBDebugNotInBuiltinMode(this)) {
                xSLTContext.popOSBDebugVar(this.nVars);
            }
        }
        xMLError.setLocator(this);
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        if (this.children == null) {
            this.children = new FastVector();
        }
        this.children.addElement(xSLNode);
        xSLNode.preserveSpace = this.preserveSpace;
        xSLNode.parent = this;
        if (this.prefixHash != null) {
            xSLNode.prefixHash = this.prefixHash;
        }
        if (this.excludeNSSet != null) {
            xSLNode.excludeNSSet = this.excludeNSSet;
        }
        xSLNode.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
    }

    void removeChild() {
        this.children.popElement();
    }

    public void appendText(char[] cArray, int n2, int n3) throws XSLException {
        if (!this.preserveSpace && XMLUtil.isWhiteSpace(cArray, n2, n3)) {
            return;
        }
        XSLText xSLText = new XSLText(this.xss);
        xSLText.appendText(cArray, n2, n3);
        this.appendChild(xSLText);
    }

    void processExcludeResultPrefixes() throws XSLException {
        String string = null;
        string = this.namespace == "http://www.w3.org/1999/XSL/Transform" ? this.getAttribute("", "exclude-result-prefixes") : this.getAttribute("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (this.excludeNSSet == null) {
            this.excludeNSSet = new HashSet();
        } else if (this.parent != null && this.excludeNSSet == this.parent.excludeNSSet) {
            this.excludeNSSet = (HashSet)this.excludeNSSet.clone();
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("#all")) {
                if (bl2) {
                    this.xss.err.error2(24526, 1, "exclude-result-prefixes", this.localName);
                    continue;
                }
                if (this.prefixHash == null) continue;
                Iterator iterator = this.prefixHash.values().iterator();
                while (iterator.hasNext()) {
                    this.excludeNSSet.add((String)iterator.next());
                }
                bl = true;
                continue;
            }
            if (bl || this.prefixHash == null) {
                this.xss.err.error2(24526, 1, "exclude-result-prefixes", this.localName);
            }
            if ((string3 = (String)this.prefixHash.get(string2)) == null) {
                this.xss.err.error2(24526, 1, "exclude-result-prefixes", this.localName);
            } else {
                this.excludeNSSet.add(string3);
            }
            bl2 = true;
        }
    }

    Vector processUseCharacterMaps(String string) throws XSLException {
        Vector<NSName> vector = new Vector<NSName>(5, 5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            NSName nSName = this.resolveQname(string2);
            vector.add(nSName);
        }
        return vector;
    }

    protected void processAttrSets(XSLTContext xSLTContext) throws XSLException, XQException {
        if (this.attrsets == null) {
            String string = this.namespace == "http://www.w3.org/1999/XSL/Transform" ? this.getAttribute("", "use-attribute-sets") : this.getAttribute("http://www.w3.org/1999/XSL/Transform", "use-attribute-sets");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                this.numattrsets = stringTokenizer.countTokens();
                this.attrsets = new XSLAttributeSet[this.numattrsets];
                for (int i2 = 0; i2 < this.numattrsets; ++i2) {
                    NSName nSName = this.resolveQname(stringTokenizer.nextToken());
                    this.attrsets[i2] = this.xss.getAttributeSet(nSName);
                }
            } else {
                this.numattrsets = 0;
                this.attrsets = new XSLAttributeSet[1];
            }
        }
        for (int i3 = 0; i3 < this.numattrsets; ++i3) {
            if (this.attrsets[i3] == null) continue;
            if (xSLTContext.isInAttrSet(this.attrsets[i3])) {
                this.xss.err.error2(1123, 0, this.attrsets[i3].getName().getQualifiedName(), "xsl:attribute-set");
                throw new XSLException(this.xss.err, 0);
            }
            xSLTContext.pushAttrSet(this.attrsets[i3]);
            this.attrsets[i3].processAction(xSLTContext);
            xSLTContext.popAttrSet();
        }
    }

    protected XSLTemplate getCurrentTemplate() {
        XSLNode xSLNode = this;
        while (xSLNode.localName != "template" || xSLNode.namespace != "http://www.w3.org/1999/XSL/Transform") {
            xSLNode = xSLNode.parent;
        }
        return (XSLTemplate)xSLNode;
    }

    public XSLExprBase getParentCtxExpr() {
        if (this.parent != null) {
            return this.parent.getContextExpr();
        }
        return null;
    }

    XSLExprBase getContextExpr() {
        if (this.parent != null) {
            return this.parent.getContextExpr();
        }
        return null;
    }

    public boolean getDebugMode() {
        try {
            String string = XMLUtil.getProperty("oracle.xml.parser.debugmode", "false");
            if (string.equals("true")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setDebugInfo(int n2, int n3, String string) {
        this.line = n2;
        this.col = n3;
        this.sysid = string;
    }

    String getLocInfo() {
        String string = "";
        if (this.sysid != null) {
            int n2 = this.sysid.lastIndexOf(47);
            string = this.sysid.substring(n2 + 1);
        }
        return "<" + string + ">:" + this.line;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.col;
    }

    void setEndingLineNumber(int n2) {
        this.endingline = n2;
    }

    int getEndingLineNumber() {
        return this.endingline;
    }

    void setCodeIndexBegin(int n2) {
        this.codeIndexBegin = n2;
    }

    int getCodeIndexBegin() {
        return this.codeIndexBegin;
    }

    void setCodeIndexEnd(int n2) {
        this.codeIndexEnd = n2;
    }

    int getCodeIndexEnd() {
        return this.codeIndexEnd;
    }

    @Override
    public String getSystemId() {
        return this.sysid;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    public void setCompatibilityFlags(int n2, boolean bl, boolean bl2) {
        this.version = n2;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    public int getXSLTVersion() {
        return this.version;
    }

    public boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    public boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    boolean isTopLevel() {
        return this.parent != null && this.parent.namespace == "http://www.w3.org/1999/XSL/Transform" && (this.parent.localName == "stylesheet" || this.parent.localName == "transform");
    }

    public NSName resolveQname(String string) throws XSLException {
        NSNameImpl nSNameImpl = XPathSequence.resolveQname(string, this, this.xss.err);
        String string2 = nSNameImpl.getNamespace();
        if (string2 == "http://www.w3.org/1999/XSL/Transform" || string2 == "http://www.w3.org/2005/xpath-functions") {
            this.xss.err.error1(22132, 1, string);
        }
        return nSNameImpl;
    }

    HashMap<NSName, XSLVariable> getVarHash() {
        return this.varHash;
    }

    boolean checkDuplicate(XSLVariable xSLVariable) {
        NSName nSName = xSLVariable.getName();
        if (this.varHash == null) {
            this.varHash = new HashMap(20);
        }
        if (nSName != null && !this.varHash.containsKey(nSName)) {
            if (!xSLVariable.isTopLevel() && xSLVariable.localName != "with-param") {
                ++this.nVars;
            }
            this.varHash.put(nSName, xSLVariable);
            return false;
        }
        return true;
    }

    void setErrorId(int n2, int n3, int n4) {
        this.errId = n2;
        this.errType = n3;
        this.errParams = new String[n4];
        this.reportError = true;
    }

    void addErrorParam(int n2, String string) {
        this.errParams[n2] = string;
    }

    void clearError() {
        this.reportError = false;
    }

    XSLNode replaceWithErrorNode() throws XSLException {
        FastVector fastVector = this.parent.children;
        int n2 = fastVector.indexOf(this);
        if (n2 != -1) {
            XSLNode xSLNode = new XSLNode(this.xss);
            xSLNode.origNode = this;
            fastVector.setElementAt(xSLNode, n2);
        }
        return null;
    }

    void printXSLNode(PrintWriter printWriter, int n2) {
        this.printIndent(printWriter, n2);
        String string = this.resolveNamespace(this.namespace) + this.localName;
        printWriter.print("<" + string);
        if (this.prefixHash != null) {
            for (String string2 : this.prefixHash.keySet()) {
                String string3 = (String)this.prefixHash.get(string2);
                string2 = string2.equals("#default") ? "xmlns" : "xmlns:" + string2;
                printWriter.print(" " + string2 + "=\"" + string3 + "\"");
            }
        }
        this.printAttributes(printWriter);
        printWriter.println(">");
        this.printChildren(printWriter, n2 + 1);
        this.printIndent(printWriter, n2);
        printWriter.println("</" + string + ">");
    }

    void printChildren(PrintWriter printWriter, int n2) {
        if (this.children != null) {
            int n3 = this.children.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                ((XSLNode)this.children.elementAt(i2)).printXSLNode(printWriter, n2);
            }
        }
    }

    void printIndent(PrintWriter printWriter, int n2) {
        while (n2 > 0) {
            printWriter.print("   ");
            --n2;
        }
    }

    void printAttributes(PrintWriter printWriter) {
        if (this.attrHash != null) {
            for (String string : this.attrHash.keySet()) {
                printWriter.print(" " + string + "=\"" + this.attrHash.get(string) + "\"");
            }
        }
    }

    String resolveNamespace(String string) {
        if (string == null) {
            return "";
        }
        String string22 = null;
        if (this.prefixHash != null) {
            for (String string22 : this.prefixHash.keySet()) {
                if (!string.equals((String)this.prefixHash.get(string22))) continue;
                if (string22.equals("#default")) {
                    return "";
                }
                return string22 + ":";
            }
            string22 = null;
        }
        if (this.parent != null) {
            string22 = this.parent.resolveNamespace(string);
        }
        if (string22 == null) {
            return "";
        }
        return string22;
    }

    void copyNamespaces(XMLElement xMLElement, XSLEventHandler xSLEventHandler) throws XSLException {
        Object object;
        Cloneable cloneable;
        String string = xMLElement.resolveNamespacePrefix("#default");
        if (string != null) {
            cloneable = (XMLElement)xMLElement.getParentNode();
            object = cloneable != null ? ((XMLElement)cloneable).resolveNamespacePrefix("#default") : null;
            if (!string.equals("") || !string.equals(object)) {
                xSLEventHandler.namespaceAttr("", string);
            }
        }
        if ((cloneable = xMLElement.getAllNamespaceAttrs()) != null) {
            object = ((Hashtable)cloneable).keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                String string3 = (String)((Hashtable)cloneable).get(string2);
                xSLEventHandler.namespaceAttr(string2, string3);
            }
        }
    }

    static XSLNode createUpdateVar(XSLStylesheet xSLStylesheet, NSName nSName, XSLExprBase xSLExprBase) throws XSLException {
        UpdateVar updateVar = new UpdateVar(xSLStylesheet);
        updateVar.varName = nSName;
        updateVar.expr = xSLExprBase;
        return updateVar;
    }

    static EndElement createEndElement(XSLStylesheet xSLStylesheet) throws XSLException {
        return new EndElement(xSLStylesheet);
    }

    protected FastVector getParamList() {
        return this.paramList;
    }

    private int getPreSiblingNum(XSLNode xSLNode) {
        XSLNode xSLNode2;
        if (xSLNode.parent == null) {
            return 0;
        }
        FastVector fastVector = xSLNode.parent.children;
        int n2 = 0;
        if (xSLNode.parent.nParams > 0 && xSLNode instanceof XSLVariable) {
            FastVector fastVector2 = xSLNode.parent.getParamList();
            for (int i2 = 0; i2 < xSLNode.parent.nParams; ++i2) {
                if (!fastVector2.elementAt(i2).equals(xSLNode)) continue;
                return i2;
            }
        }
        if (xSLNode.parent.nParams > 0) {
            n2 += xSLNode.parent.nParams;
        }
        if (fastVector == null || fastVector.size() == 1) {
            return n2;
        }
        for (int i3 = 0; i3 < fastVector.size() && !(xSLNode2 = (XSLNode)fastVector.elementAt(i3)).equals(xSLNode); ++i3) {
            if (xSLNode2 instanceof EndElement || xSLNode.parent != xSLNode2.parent || xSLNode2.localName.equals("stylesheet") || xSLNode2.localName.equals("transform") && xSLNode2.namespace != null && xSLNode2.namespace.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            ++n2;
        }
        return n2;
    }

    protected int[] getPath4OSBDebugger() {
        int[] nArray;
        int n2 = 10;
        int[] nArray2 = new int[n2];
        XSLNode xSLNode = this;
        int n3 = 0;
        while (xSLNode != null && !(xSLNode instanceof XSLStylesheet)) {
            if (xSLNode instanceof EndElement) {
                xSLNode = xSLNode.parent;
                continue;
            }
            nArray2[n3] = this.getPreSiblingNum(xSLNode);
            xSLNode = xSLNode.parent;
            if (++n3 != n2) continue;
            nArray = new int[n2 * 2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
            n2 *= 2;
        }
        if (n3 == 0) {
            nArray = new int[1];
            return nArray;
        }
        nArray = new int[n3];
        int n4 = n3 - 1;
        int n5 = 0;
        while (n4 >= 0) {
            nArray[n5] = nArray2[n4];
            --n4;
            ++n5;
        }
        return nArray;
    }

    void setFlushIncreamentalOutputFlag(boolean bl) {
        this.flushIncreamentalOutputFlag = bl;
    }

    boolean getFlushIncreamentalOutputFlag() {
        return this.flushIncreamentalOutputFlag;
    }

    private XSLTDebuggerTraceEvent generateXSLTDebuggerTraceEventData(XSLTContext xSLTContext, XSLNode xSLNode, String string) {
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = new XSLTDebuggerTraceEvent(xSLNode, xSLTContext, string);
        return xSLTDebuggerTraceEvent;
    }

    private boolean isOSBAttrsAdded(XSLNode xSLNode) {
        return xSLNode instanceof EndElement || xSLNode instanceof XSLAttribute || xSLNode instanceof XSLElement || xSLNode instanceof XSLForEach || xSLNode instanceof XSLFunction || xSLNode instanceof XSLResultElement || xSLNode instanceof XSLStylesheet || xSLNode instanceof XSLTemplate || xSLNode instanceof XSLValueOf || xSLNode instanceof XSLVariable || xSLNode instanceof XSLKey;
    }

    protected void fireOSBDebuggerTraceEventBeforeExe(XSLTContext xSLTContext, XSLNode xSLNode, String string) throws XSLException {
        if (!xSLTContext.getOSBDebugMode()) {
            return;
        }
        if (xSLNode.getBaseURL() == null) {
            return;
        }
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = this.generateXSLTDebuggerTraceEventData(xSLTContext, xSLNode, string);
        XMLContentHandler xMLContentHandler = xSLTContext.getOSBDebugContentHandler();
        if (xSLTContext.getOsbDebugAttrStk().size() > 0 && this.isOSBAttrsAdded(this)) {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, -1, xSLTContext.getOsbDebugAttrStk().peek(), xMLContentHandler);
        } else {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, -1, new HashMap<String, Object>(1), xMLContentHandler);
        }
    }

    protected void fireOSBDebuggerTraceEventAfterExe(XSLTContext xSLTContext, XSLNode xSLNode, String string) throws XSLException {
        if (!xSLTContext.getOSBDebugMode()) {
            return;
        }
        if (xSLNode.getBaseURL() == null && !(xSLNode instanceof EndElement)) {
            return;
        }
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = this.generateXSLTDebuggerTraceEventData(xSLTContext, xSLNode, string);
        XMLContentHandler xMLContentHandler = xSLTContext.getOSBDebugContentHandler();
        if (xSLTContext.getIsFiredByOSBDebuggerEndElement()) {
            xSLTDebuggerTraceEvent.setLineNumber(xSLTContext.getOSBDebugLineNumber());
            xSLTDebuggerTraceEvent.setColumnNumber(xSLTContext.getOSBDebugColNumber());
            xSLTDebuggerTraceEvent.setBaseURL(xSLTContext.getOSBDebugBaseURL());
        }
        if (xSLTContext.getOsbDebugAttrStk().size() > 0 && this.isOSBAttrsAdded(this)) {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, 1, xSLTContext.getOsbDebugAttrStk().peek(), xMLContentHandler);
        } else {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, 1, new HashMap<String, Object>(1), xMLContentHandler);
        }
    }

    protected void addJDWPDataBefore(XSLTContext xSLTContext, XSLStylesheet xSLStylesheet, XSLNode xSLNode, String string, String string2, byte by) {
        this.xss = xSLStylesheet;
        this.jdwpEventValue = new XSLJDWPEventValue(xSLStylesheet);
        this.addJDWPDataBefore(xSLTContext, xSLNode, string, string2, by);
    }

    protected void addJDWPDataBefore(XSLTContext xSLTContext, XSLNode xSLNode, String string, String string2, byte by) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setXSLTContext(xSLTContext);
        this.jdwpEventValue.setInstructionName(string);
        this.jdwpEventValue.setLineNumber(xSLNode.getLineNumber());
        this.jdwpEventValue.setCodeIndexBegin(xSLNode.getCodeIndexBegin());
        String string3 = xSLNode.getSystemId();
        this.jdwpEventValue.setBaseURL(string3);
        this.jdwpEventValue.setName(string2);
        this.jdwpEventValue.setEventKind(by);
        if (xSLNode instanceof XSLResultElement || xSLNode instanceof XSLElement) {
            xSLTContext.pushCurrentElementIName(string);
            xSLTContext.pushCurrentElementNode(xSLNode);
        }
        if (this.concatedAttrs != null && this.concatedAttrs.length() > 0) {
            this.jdwpEventValue.setConcatedAttrs(this.concatedAttrs);
        }
        this.jdwpEventValue.add();
    }

    protected void addJDWPDataAfter(XSLNode xSLNode, String string, String string2, byte by, ContentHandler contentHandler) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setInstructionName(string);
        this.jdwpEventValue.setLineNumber(xSLNode.getEndingLineNumber());
        this.jdwpEventValue.setCodeIndexEnd(xSLNode.getCodeIndexEnd());
        String string3 = xSLNode.getSystemId();
        this.jdwpEventValue.setBaseURL(string3);
        this.jdwpEventValue.setName(string2);
        this.jdwpEventValue.setEventKind(by);
        this.jdwpEventValue.add();
        if (contentHandler == null) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void addJDWPDataAfter(XSLNode xSLNode, byte by, ContentHandler contentHandler) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setLineNumber(xSLNode.getEndingLineNumber());
        this.jdwpEventValue.setCodeIndexEnd(xSLNode.getCodeIndexEnd());
        this.jdwpEventValue.setEventKind(by);
        this.jdwpEventValue.add();
        if (contentHandler == null) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flushPartialOutputByReportingStartElement(XSLTContext xSLTContext) throws XSLException {
        if (!(this instanceof XSLResultElement) && !(this instanceof XSLElement)) {
            return;
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        if (xSLEventHandler.getQNameStack() != null && !xSLEventHandler.getQNameStack().empty()) {
            xSLEventHandler.reportStartElement();
            xSLEventHandler.resetCurrentState();
        }
    }

    protected void flushPartialOutput(XSLEventHandler xSLEventHandler, ContentHandler contentHandler) {
        try {
            xSLEventHandler.reportStartElement();
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
        xSLEventHandler.resetCurrentState();
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean isXSLMessageChildren() {
        XSLNode xSLNode = this.parent;
        while (xSLNode != null) {
            if (xSLNode instanceof XSLMiscElements && xSLNode.localName == "message") {
                return true;
            }
            xSLNode = xSLNode.parent;
        }
        return false;
    }

    protected boolean hasAttributeInsChild() {
        if (this.children == null) {
            return false;
        }
        int n2 = this.children.size();
        if (n2 == 0) {
            return false;
        }
        if (this.children.elementAt(0) instanceof XSLValueOf || this.children.elementAt(0) instanceof XSLText || this.children.elementAt(0) instanceof XSLNumber || this.children.elementAt(0) instanceof XSLElement || this.children.elementAt(0) instanceof XSLResultElement) {
            return false;
        }
        int n3 = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(this.children.elementAt(i2) instanceof XSLValueOf) && !(this.children.elementAt(i2) instanceof XSLText) && !(this.children.elementAt(i2) instanceof XSLNumber) && !(this.children.elementAt(i2) instanceof XSLElement) && !(this.children.elementAt(i2) instanceof XSLResultElement) && !(this.children.elementAt(i2) instanceof XSLVariable) && !(this.children.elementAt(i2) instanceof XSLMiscElements) && !(this.children.elementAt(i2) instanceof XSLFallback) && !(this.children.elementAt(i2) instanceof XSLForEach)) continue;
            --n3;
        }
        return n3 != 0;
    }

    static class EndElement
    extends XSLNode {
        private String qname;

        EndElement(XSLStylesheet xSLStylesheet) throws XSLException {
            super(xSLStylesheet);
            this.elementType = 7;
        }

        void setQName(String string, String string2) {
            this.qname = string;
            if (string2 != null && string2.length() > 0) {
                this.qname = string2 + ":" + this.qname;
            }
        }

        @Override
        boolean includedInOSBDebugCallStack() {
            return true;
        }

        @Override
        public void processAction(XSLTContext xSLTContext) throws XSLException {
            XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
            if (this.nVars != 0) {
                xSLTContext.popVariable(this.nVars);
                if (xSLTContext.getOSBDebugNotInBuiltinMode(this)) {
                    xSLTContext.popOSBDebugVar(this.nVars);
                }
            }
            xSLEventHandler.endElement();
            if (xSLTContext.getOSBDebugMode()) {
                xSLTContext.setIsFiredByOSBDebuggerEndElement(true);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, this.qname);
                xSLTContext.resetIsFiredByOSBDebuggerEndElement();
                xSLTContext.resetOSBDebugBaseURL();
                xSLTContext.resetOSBDebugLineNumber();
                xSLTContext.resetOSBDebugColNumber();
                if (this.qname != null & this.qname.length() > 0) {
                    xSLTContext.getOsbDebugAttrStk().pop();
                }
            }
            if (xSLTContext.isInDebugMode()) {
                this.addJDWPDataAfter(xSLTContext.popCurrentElementNode(), xSLTContext.popCurrentElementIName(), "", (byte)-1, xSLTContext.getJDWPContentHandler());
            }
        }
    }

    static class UpdateVar
    extends XSLNode {
        XSLExprBase expr;
        NSName varName;

        UpdateVar(XSLStylesheet xSLStylesheet) throws XSLException {
            super(xSLStylesheet);
            this.elementType = 7;
        }

        @Override
        public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
            OXMLSequence oXMLSequence = xSLTContext.getVariable(this.varName, -2);
            this.expr.evaluate(xSLTContext);
            oXMLSequence.reset();
            XPathSequence.concatSequence(oXMLSequence, xSLTContext.popExprValue());
        }
    }

    class AttrValueTmpl {
        String purestringresult;
        XSLExprBase purexprresult;
        FastVector mixedresult;
        String source;
        boolean isAVT = false;
        int version;

        boolean isAttrValueTmpl() {
            return this.isAVT;
        }

        AttrValueTmpl(String string, XSLNode xSLNode2) throws XSLException, XQException {
            Object object;
            int n2;
            this.version = xSLNode2.version;
            if (string == null) {
                return;
            }
            if (string.length() == 0) {
                this.purestringresult = string;
                return;
            }
            this.source = string;
            char[] cArray = string.toCharArray();
            String string2 = "";
            XSLExprBase xSLExprBase = null;
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            int n6 = 0;
            boolean bl2 = false;
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (cArray[n2] == '\'' && bl2) {
                    bl = !bl;
                    continue;
                }
                if (!bl && cArray[n2] == '{') {
                    if (n2 + 1 < string.length() && cArray[n2 + 1] == '{') {
                        ++n5;
                        ++n2;
                        continue;
                    }
                    if (n2 + 1 < string.length()) {
                        bl2 = true;
                        n3 = n2;
                        if (n3 <= n4) continue;
                        string2 = n4 == 0 ? string.substring(n4, n3) : string.substring(n4 + 1, n3);
                        if (this.mixedresult == null) {
                            this.mixedresult = new FastVector();
                        }
                        string2 = this.escapeCurlyBraces(string2, n5, n6);
                        this.mixedresult.addElement(string2.toCharArray());
                        n6 = 0;
                        n5 = 0;
                        continue;
                    }
                    throw new XPathException(1027);
                }
                if (bl || cArray[n2] != '}') continue;
                if (n2 + 1 < string.length() && cArray[n2 + 1] == '}') {
                    ++n6;
                    ++n2;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    n4 = n2;
                    string2 = string.substring(n3 + 1, n4 - n6 * 2);
                    object = new XSLParseString(string2.toCharArray(), 0, xSLNode2, xSLNode2.xss);
                    ((XSLParseString)object).setCompatibilityFlags(xSLNode2.getXSLTVersion(), xSLNode2.isBackwardCompatibilityMode(), xSLNode2.isForwardCompatibilityMode());
                    xSLExprBase = XSLExpr.parse((XSLParseString)object);
                    if (((XSLParseString)object).getPrevPosition() < ((XSLParseString)object).getCurrentPosition()) {
                        xSLNode2.xss.err.error2(1070, 1, string2.substring(((XSLParseString)object).getPrevPosition(), ((XSLParseString)object).getCurrentPosition()), string2);
                    }
                    if (this.mixedresult == null) {
                        this.mixedresult = new FastVector();
                    }
                    this.mixedresult.addElement(xSLExprBase);
                    if (n6 <= 0) continue;
                    string2 = string.substring(n4 - n6, n4);
                    this.mixedresult.addElement(string2.toCharArray());
                    continue;
                }
                throw new XPathException(1032);
            }
            if (bl2) {
                throw new XPathException(1027);
            }
            if (string.length() > n4 + 1 && this.mixedresult != null) {
                string2 = string.substring(n4 + 1, string.length());
                this.mixedresult.addElement(string2.toCharArray());
            }
            if (this.mixedresult == null) {
                this.purestringresult = this.source;
                this.purestringresult = this.escapeCurlyBraces(this.purestringresult, n5, n6);
                return;
            }
            n2 = this.mixedresult.size();
            if (n2 == 1) {
                object = this.mixedresult.elementAt(0);
                if (object instanceof String) {
                    this.purestringresult = (String)object;
                } else {
                    this.purexprresult = (XSLExprBase)object;
                    this.isAVT = true;
                }
                this.mixedresult = null;
            } else {
                this.isAVT = true;
            }
        }

        private String escapeCurlyBraces(String string, int n2, int n3) {
            if (n2 > 0) {
                string = string.replaceAll("\\{{2}", "{");
            }
            if (n3 > 0) {
                string = string.replaceAll("\\}{2}", "}");
            }
            return string;
        }

        String getValue(XSLTContext xSLTContext) throws XPathException, XSLException, XQException {
            if (this.purestringresult != null) {
                return this.purestringresult;
            }
            if (this.purexprresult != null) {
                this.purexprresult.evaluate(xSLTContext);
                if (this.version >= 20) {
                    return XSLNode.constructSimpleContent(xSLTContext.popExprValue(), xSLTContext, null);
                }
                return XPathSequence.getStringValue(xSLTContext.popExprValue());
            }
            int n2 = this.mixedresult.size();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                Object object;
                Object object2 = this.mixedresult.elementAt(i2);
                if (object2 instanceof XSLExprBase) {
                    XSLExprBase xSLExprBase = (XSLExprBase)object2;
                    xSLExprBase.evaluate(xSLTContext);
                    OXMLSequence oXMLSequence = xSLTContext.popExprValue();
                    object = null;
                    object = this.version >= 20 ? (Object)XSLNode.constructSimpleContent(oXMLSequence, xSLTContext, null) : (Object)XPathSequence.getStringValue(oXMLSequence);
                    n4 = ((String)object).length();
                    while (n4 + n3 > xSLTContext.getResultArraySize()) {
                        char[] cArray = xSLTContext.getResultArray();
                        int n5 = xSLTContext.getResultArraySize() * 2;
                        xSLTContext.initResultArray(n5);
                        System.arraycopy(cArray, 0, xSLTContext.getResultArray(), 0, n3);
                    }
                    ((String)object).getChars(0, n4, xSLTContext.getResultArray(), n3);
                    n3 += n4;
                    continue;
                }
                char[] cArray = (char[])object2;
                int n6 = cArray.length;
                while (n6 + n3 > xSLTContext.getResultArraySize()) {
                    object = xSLTContext.getResultArray();
                    n4 = xSLTContext.getResultArraySize() * 2;
                    xSLTContext.initResultArray(n4);
                    System.arraycopy(object, 0, xSLTContext.getResultArray(), 0, n3);
                }
                System.arraycopy(cArray, 0, xSLTContext.getResultArray(), n3, n6);
                n3 += n6;
            }
            String string = new String(xSLTContext.getResultArray(), 0, n3);
            return string;
        }

        String getAVTInputString() {
            return this.source;
        }
    }
}

