/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class SubstringBefore
extends OXMLFunction {
    private int numParams;

    SubstringBefore(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "substring-before";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0 || n2 == 1) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n2 == 2) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        String string = oXMLFunctionContext.getDefaultCollation();
        OXMLCollator oXMLCollator = oXMLFunctionContext.getCollator(string);
        if (oXMLCollator == null) {
            oXMLCollator = FNUtil.getSubstringCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        return this.before(oXMLFunctionContext, oXMLSequence, oXMLSequence2, oXMLCollator);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
                break;
            }
            case 3: {
                OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequenceArray[2]);
                OXMLCollator oXMLCollator = oXMLFunctionContext.getCollator(oXMLItem.getString());
                if (oXMLCollator == null) {
                    oXMLCollator = FNUtil.getSubstringCollator(oXMLItem.getString(), oXMLFunctionContext.getDBCharSet());
                }
                oXMLSequence = this.before(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1], oXMLCollator);
            }
        }
        return oXMLSequence;
    }

    private OXMLSequence before(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OXMLCollator oXMLCollator) throws XQException {
        int n2;
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
        OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        String string = oXMLItem == null ? "" : oXMLItem.getString();
        String string2 = oXMLItem2 == null ? "" : oXMLItem2.getString();
        String string3 = null;
        string3 = string.length() == 0 ? "" : (oXMLCollator == null ? ((n2 = string2.indexOf(string)) == -1 ? "" : string2.substring(0, n2)) : ((n2 = oXMLCollator.match(string2, string, true)) >= 0 ? (0 == n2 ? "" : string2.substring(0, n2)) : ""));
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
        oXMLItem3.setString(OXMLSequenceType.TSTRING, string3);
        oXMLSequence3.appendItem(oXMLItem3);
        return oXMLSequence3;
    }
}

