/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Substring
extends OXMLFunction {
    private int numParams;

    Substring(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "substring";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n2 == 1 || n2 == 2) {
            return OXMLSequenceType.TDOUBLE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        String string;
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        String string2 = oXMLItem.getString();
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequence2);
        oXMLItem3.convert(OXMLSequenceType.TDOUBLE);
        double d2 = oXMLItem3.getDouble();
        if (Double.isNaN(d2) || Double.isInfinite(d2) && d2 > 0.0) {
            string = "";
        } else {
            int n2;
            int n3;
            int n4 = string2.length();
            if (Double.isInfinite(d2) && d2 < 0.0) {
                n3 = 1;
                n2 = 0;
            } else {
                n3 = (int)Math.floor(d2 + 0.5);
                if (n3 > n4) {
                    n3 = n4 + 1;
                }
                int n5 = n2 = n3 < 1 ? 0 : n3 - 1;
            }
            if (n4 == string2.codePointCount(0, n4)) {
                string = string2.substring(n2);
            } else {
                int n6;
                int[] nArray = new int[n4 - n2];
                int n7 = 0;
                int n8 = 0;
                for (int i2 = 0; i2 < n4; i2 += Character.charCount(n6)) {
                    n6 = string2.codePointAt(i2);
                    if (n8 < n2) continue;
                    nArray[n7++] = n6;
                }
                string = new String(nArray, 0, n7);
            }
        }
        OXMLSequence oXMLSequence4 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem4 = oXMLFunctionContext.createItem();
        oXMLItem4.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence4.appendItem(oXMLItem4);
        return oXMLSequence4;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        String string;
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        if (oXMLSequenceArray.length != 3) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence.appendItem(oXMLItem2);
            return oXMLSequence;
        }
        String string2 = oXMLItem.getString();
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequenceArray[1]);
        oXMLItem3.convert(OXMLSequenceType.TDOUBLE);
        double d2 = oXMLItem3.getDouble();
        OXMLItem oXMLItem4 = FNUtil.getSingleItem(oXMLSequenceArray[2]);
        oXMLItem4.convert(OXMLSequenceType.TDOUBLE);
        double d3 = oXMLItem4.getDouble();
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isInfinite(d2) || d3 <= 0.0) {
            string = "";
        } else {
            int n2;
            int n3 = (int)Math.floor(d2 + 0.5);
            int n4 = (int)Math.floor(d3 + 0.5);
            int n5 = string2.length();
            int n6 = n3 < 1 ? 0 : (n3 > n5 ? n5 : n3 - 1);
            int n7 = Double.isInfinite(d3) && d3 > 0.0 ? n5 : ((n2 = n3 + n4 - 1) > n5 ? n5 : (n2 < 0 ? 0 : n2));
            if (n5 == string2.codePointCount(0, n5)) {
                string = n6 <= n7 ? string2.substring(n6, n7) : "";
            } else {
                int[] nArray = new int[n4];
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (n10 < n5) {
                    int n11 = string2.codePointAt(n10);
                    if (n9 >= n6 && n9 < n7) {
                        nArray[n8++] = n11;
                    }
                    n10 += Character.charCount(n11);
                    ++n9;
                }
                string = new String(nArray, 0, n8);
            }
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem5 = oXMLFunctionContext.createItem();
        oXMLItem5.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(oXMLItem5);
        return oXMLSequence;
    }
}

