/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class RoundHalfToEven
extends OXMLFunction {
    private int numParams;

    RoundHalfToEven(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "round-half-to-even";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        }
        if (n2 == 1) {
            return OXMLSequenceType.TINTEGER;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        int n2 = oXMLItem.withinRange() ? oXMLItem.getInt() : oXMLItem.getDecimal().intValue();
        return this.round(oXMLFunctionContext, oXMLSequence, n2);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        return this.round(oXMLFunctionContext, oXMLSequence, 0);
    }

    private OXMLSequence round(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, int n2) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n3 = oXMLItem.getPrimitiveType();
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType(1, n3);
            if (n3 == 3 || n3 == 4) {
                double d2 = oXMLItem.getDouble();
                if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                    oXMLItem2.setDouble(oXMLSequenceType, d2);
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    oXMLItem2.setDouble(oXMLSequenceType, this.round2Even(d2, n2));
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            } else if (n3 == 5 || n3 == 22) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = oXMLItem.withinRange() ? new BigDecimal(this.round2Even(oXMLItem.getInt(), n2)) : this.round2Even(oXMLItem.getDecimal(), n2);
                if (n2 > 0) {
                    bigDecimal = bigDecimal.setScale(n2, 6);
                }
                oXMLItem2.setDecimal(oXMLSequenceType, bigDecimal);
                oXMLSequence2.appendItem(oXMLItem2);
            }
        }
        return oXMLSequence2;
    }

    private double round2Even(double d2, int n2) {
        double d3;
        double d4 = Math.pow(10.0, 0 - n2);
        double d5 = d2 / d4;
        d5 = d5 - (d3 = Math.floor(d5)) == 0.5 ? (d3 % 2.0 != 0.0 ? d3 + 1.0 : d3) : Math.floor(d5 + 0.5);
        return d5 * d4;
    }

    private BigDecimal round2Even(BigDecimal bigDecimal, int n2) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = new BigDecimal(Math.pow(10.0, 0 - n2));
        BigDecimal bigDecimal5 = bigDecimal.divide(bigDecimal4, 10, 1);
        bigDecimal5 = bigDecimal5.subtract(bigDecimal3 = bigDecimal5.setScale(0, 3)).compareTo(new BigDecimal(0.5)) == 0 ? ((bigDecimal2 = bigDecimal3.divide(new BigDecimal(2), 10, 1)).setScale(0, 3).compareTo(bigDecimal2) != 0 ? bigDecimal3.add(new BigDecimal(1)) : bigDecimal3) : (bigDecimal5.compareTo(new BigDecimal(0)) < 0 ? bigDecimal5.setScale(0, 5) : bigDecimal5.setScale(0, 4));
        return bigDecimal5.multiply(bigDecimal4);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        oXMLSequence = oXMLSequenceArray.length == 1 ? this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        return oXMLSequence;
    }
}

