/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNString
extends OXMLFunction {
    private int numParams;

    FNString(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "string";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.ITEM_ZERO_OR_ONE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLItem oXMLItem = oXMLFunctionContext.getContextItem();
        if (oXMLItem == null) {
            throw new XQException("FONC0001");
        }
        String string = oXMLItem.getLexicalValue();
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(oXMLItem2);
        return oXMLSequence;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        String string = oXMLItem == null ? "" : oXMLItem.getLexicalValue();
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence2.appendItem(oXMLItem2);
        return oXMLSequence2;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLSequenceArray.length == 0 ? this.invoke(oXMLFunctionContext) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
        return oXMLSequence;
    }
}

