/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Abs
extends OXMLFunction {
    Abs() {
    }

    @Override
    public String getFunctionName() {
        return "abs";
    }

    @Override
    public int getNumberArgs() {
        return 1;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n2 = oXMLItem.getPrimitiveType();
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType(1, n2);
            if (n2 == 3 || n2 == 4) {
                double d2 = oXMLItem.getDouble();
                oXMLItem2.setDouble(oXMLSequenceType, Math.abs(d2));
                oXMLSequence2.appendItem(oXMLItem2);
            } else if (n2 == 5 || n2 == 22) {
                if (oXMLItem.withinRange() && oXMLItem.getInt() != Integer.MIN_VALUE) {
                    oXMLItem2.setInt(oXMLSequenceType, Math.abs(oXMLItem.getInt()));
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    BigDecimal bigDecimal = oXMLItem.getDecimal();
                    oXMLItem2.setDecimal(oXMLSequenceType, bigDecimal.abs());
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            }
        }
        return oXMLSequence2;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 1) {
            throw new XQException("FORT0001");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
    }
}

