/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathExtFunction;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XPathVarReference;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

public class XPathPredicate
implements XSLExprConstants {
    FastVector predicates;
    int predicateSize;
    private int position = -1;
    private int simpleCtx = -1;
    int flag = -1;
    static final int OTHER_TEST = 0;
    static final int CHILD_VALUE = 1;
    static final int ATTR_VALUE = 2;
    static final int POSITION_TEST = 3;

    XPathPredicate(XSLParseString xSLParseString) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(114, 0);
        }
        boolean bl = xSLParseString.isPattern();
        xSLParseString.setPattern(false);
        this.predicates = new FastVector(5);
        while (xSLParseString.peekToken() == 27) {
            xSLParseString.nextToken();
            this.predicates.addElement(XSLExpr.parse(xSLParseString));
            if (xSLParseString.nextToken() == 28) continue;
            throw new XPathException(1019, "]", xSLParseString.getCurrentToken());
        }
        this.predicateSize = this.predicates.size();
        xSLParseString.setPattern(bl);
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(114, 1);
            ArrayList arrayList = xPathCompileEvents.makeXSLExprBaseList(this.predicates);
            xPathCompileEvents.reportEventsWithObjectParam(402, 2, null, arrayList, this);
        }
    }

    void cacheSubExpr() throws XQException {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.predicates.setElementAt(xSLExprBase.createCachedExpr(), i2);
        }
    }

    boolean canCacheExpr() {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    public boolean isRelIndependent() {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (xSLExprBase.isRelIndependent()) continue;
            return false;
        }
        return true;
    }

    public boolean supportIndex() {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (xSLExprBase.supportIndex()) continue;
            return false;
        }
        return true;
    }

    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            stringBuffer.append('[');
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    boolean isSimpleContext() {
        if (this.simpleCtx == -1) {
            this.simpleCtx = 0;
            for (int i2 = 0; i2 < this.predicateSize; ++i2) {
                XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
                if (xSLExprBase.mayBeExprType(1048632) || xSLExprBase.checkPosLastFN() > 0) {
                    this.simpleCtx = 1;
                    break;
                }
                if (!(xSLExprBase instanceof XPathVarReference) && !(xSLExprBase instanceof XPathExtFunction)) continue;
                this.simpleCtx = -1;
                break;
            }
        }
        return this.simpleCtx == 0;
    }

    int checkPosLastFN() {
        if (this.flag >= 0) {
            return this.flag;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (xSLExprBase.mayBeExprType(1048632)) {
                n2 |= 1;
            }
            n2 |= xSLExprBase.checkPosLastFN();
        }
        this.flag = n2;
        return this.flag;
    }

    boolean isStreamable() {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            if (xSLExprBase.getPositionTest() > 0 || xSLExprBase.isAttrExpr()) continue;
            return false;
        }
        return true;
    }

    int getPositionTest() {
        if (this.position != -1) {
            return this.position;
        }
        XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(0);
        this.position = xSLExprBase.getPositionTest();
        return this.position;
    }

    boolean filter(int n2, TypedAttributes typedAttributes) {
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            int n3 = xSLExprBase.getPositionTest();
            if (n3 != -1) {
                if (n2 == n3) continue;
                return false;
            }
            XPathStep xPathStep = (XPathStep)xSLExprBase.leftExpr;
            XPathConstantExpr xPathConstantExpr = (XPathConstantExpr)xSLExprBase.rightExpr;
            for (int i3 = 0; i3 < typedAttributes.getLength(); ++i3) {
                String string = typedAttributes.getLocalName(i3);
                String string2 = typedAttributes.getURI(i3);
                String string3 = typedAttributes.getValue(i3);
                if (!xPathStep.matchQName(string2, string)) continue;
                if (string3.equals(XPathItem.getStringValue(xPathConstantExpr.getValue()))) break;
                return false;
            }
            return false;
        }
        return true;
    }

    void filter(OXMLSequence oXMLSequence, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence2 = xPathRuntimeContext.pushExprValue();
        int n2 = xPathRuntimeContext.setContextSize(XPathSequence.getLength(oXMLSequence));
        int n3 = xPathRuntimeContext.getContextPosition();
        XMLNode xMLNode = xPathRuntimeContext.getContextNode();
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            oXMLSequence2.reset();
            int n4 = 1;
            while (oXMLSequence.next()) {
                XPathItem xPathItem = (XPathItem)oXMLSequence.getItem();
                if (xPathItem.isNode() || !xPathItem.isXPath20Compatible()) {
                    xPathRuntimeContext.setContextNode(xPathItem.getNode());
                } else {
                    xPathRuntimeContext.setContextItem(xPathItem);
                }
                xPathRuntimeContext.setContextPosition(n4);
                xSLExprBase.evaluate(xPathRuntimeContext);
                OXMLSequence oXMLSequence3 = xPathRuntimeContext.popExprValue();
                boolean bl = false;
                bl = oXMLSequence3.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE) ? XPathSequence.getNumberValue(oXMLSequence3) == (double)n4 : XPathSequence.getBooleanValue(oXMLSequence3);
                if (bl) {
                    XPathItem xPathItem2 = xPathRuntimeContext.allocItem();
                    xPathItem2.copyItem(xPathItem);
                    oXMLSequence2.appendItem(xPathItem2);
                }
                ++n4;
            }
            xPathRuntimeContext.setContextSize(XPathSequence.getLength(oXMLSequence2));
            oXMLSequence.reset();
            XPathSequence.concatSequence(oXMLSequence, oXMLSequence2);
        }
        xPathRuntimeContext.setContextSize(n2);
        xPathRuntimeContext.setContextPosition(n3);
        xPathRuntimeContext.setContextNode(xMLNode);
        xPathRuntimeContext.popExprValue();
    }

    int getPosition(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xPathRuntimeContext.pushExprValue();
        int n2 = 0;
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            boolean bl = true;
            xSLExprBase.evaluate(xPathRuntimeContext);
            oXMLSequence = xPathRuntimeContext.popExprValue();
            if (!oXMLSequence.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE) || XPathSequence.getNumberValue(oXMLSequence) - (double)((int)XPathSequence.getNumberValue(oXMLSequence)) != 0.0) continue;
            n2 = (int)XPathSequence.getNumberValue(oXMLSequence);
        }
        xPathRuntimeContext.popExprValue();
        return n2;
    }

    boolean filterNode(XMLNode xMLNode, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        XMLNode xMLNode2 = xPathRuntimeContext.getContextNode();
        xPathRuntimeContext.setContextNode(xMLNode);
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            xSLExprBase.evaluate(xPathRuntimeContext);
            if (XPathSequence.getBooleanValue(xPathRuntimeContext.popExprValue())) continue;
            xPathRuntimeContext.setContextNode(xMLNode2);
            return false;
        }
        xPathRuntimeContext.setContextNode(xMLNode2);
        return true;
    }

    boolean filterStreamNode(XMLNode xMLNode, int[] nArray, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        XMLNode xMLNode2 = xPathRuntimeContext.getContextNode();
        xPathRuntimeContext.setContextNode(xMLNode);
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            if (nArray != null) {
                int n2 = i2;
                nArray[n2] = nArray[n2] + 1;
                xPathRuntimeContext.setContextPosition(nArray[i2]);
            }
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            xSLExprBase.evaluate(xPathRuntimeContext);
            OXMLSequence oXMLSequence = xPathRuntimeContext.popExprValue();
            if (oXMLSequence.isOfType(OXMLSequenceType.NUMERIC_ONE)) {
                if (XPathSequence.getNumberValue(oXMLSequence) - (double)nArray[i2] == 0.0) continue;
                xPathRuntimeContext.setContextNode(xMLNode2);
                return false;
            }
            if (XPathSequence.getBooleanValue(oXMLSequence)) continue;
            xPathRuntimeContext.setContextNode(xMLNode2);
            return false;
        }
        xPathRuntimeContext.setContextNode(xMLNode2);
        return true;
    }

    boolean filterIndex(long l2, int[] nArray, XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setContextIndex(l2);
        for (int i2 = 0; i2 < this.predicateSize; ++i2) {
            if (nArray != null) {
                int n2 = i2;
                nArray[n2] = nArray[n2] + 1;
                xPathRuntimeContext.setContextPosition(nArray[i2]);
            }
            XSLExprBase xSLExprBase = (XSLExprBase)this.predicates.elementAt(i2);
            xSLExprBase.evaluate(xPathRuntimeContext);
            OXMLSequence oXMLSequence = xPathRuntimeContext.popExprValue();
            if (oXMLSequence.isOfType(OXMLSequenceType.NUMERIC_ONE)) {
                if (XPathSequence.getNumberValue(oXMLSequence) - (double)nArray[i2] == 0.0) continue;
                return false;
            }
            if (XPathSequence.getBooleanValue(oXMLSequence)) continue;
            return false;
        }
        return true;
    }
}

