/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathConvertAsExpr;
import oracle.xml.xpath.XPathFunctionContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import org.w3c.dom.NodeList;

public class XPathFunctionImpl
implements XPathFunction {
    XPathFunctionContext context;
    OXMLFunction function;
    int nargs;
    XPathConvertAsExpr[] argCvts;

    public XPathFunctionImpl(OXMLFunction oXMLFunction, int n2) {
        this.function = oXMLFunction;
        this.nargs = n2;
        this.argCvts = new XPathConvertAsExpr[this.nargs];
        for (int i2 = 0; i2 < this.nargs; ++i2) {
            OXMLSequenceType oXMLSequenceType = oXMLFunction.getArgType(i2);
            this.argCvts[i2] = new XPathConvertAsExpr(oXMLSequenceType);
        }
        this.context = new XPathFunctionContext();
    }

    @Override
    public Object evaluate(List list) throws XPathFunctionException {
        XPathSequence xPathSequence = null;
        try {
            Object object;
            OXMLSequence[] oXMLSequenceArray = new XPathSequence[this.nargs];
            for (int i2 = 0; i2 < this.nargs; ++i2) {
                object = (XPathSequence)this.context.createSequence();
                oXMLSequenceArray[i2] = object;
                Object e2 = list.get(i2);
                OXMLItem oXMLItem = this.context.createItem();
                if (e2 instanceof XMLNode) {
                    oXMLItem.setNode((XMLNode)e2);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e2 instanceof Boolean) {
                    oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, (Boolean)e2);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e2 instanceof Double) {
                    oXMLItem.setDouble(OXMLSequenceType.TDOUBLE, (Double)e2);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e2 instanceof String) {
                    oXMLItem.setString(OXMLSequenceType.TSTRING, (String)e2);
                    ((XPathSequence)object).appendItem(oXMLItem);
                } else if (e2 instanceof NodeList) {
                    NodeList nodeList = (NodeList)e2;
                    for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                        oXMLItem.setNode((XMLNode)nodeList.item(i3));
                        ((XPathSequence)object).appendItem(oXMLItem);
                        oXMLItem = this.context.createItem();
                    }
                }
                this.argCvts[i2].convert((XPathSequence)object);
            }
            xPathSequence = (XPathSequence)this.function.invoke((OXMLFunctionContext)this.context, oXMLSequenceArray);
            OXMLSequenceType oXMLSequenceType = this.function.getReturnType();
            if (oXMLSequenceType.isNode()) {
                object = xPathSequence.getNodeList();
                if (object.getLength() == 1) {
                    return object.item(0);
                }
                return object;
            }
            int n2 = oXMLSequenceType.getPrimitiveId();
            switch (n2) {
                case 2: {
                    return new Boolean(xPathSequence.getBooleanValue());
                }
                case 3: 
                case 4: 
                case 5: 
                case 22: {
                    return new Double(xPathSequence.getNumberValue());
                }
            }
            return xPathSequence.getStringValue();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new XPathFunctionException(exception.getMessage());
        }
    }
}

