/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xslt.XSLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLPathTable
extends DefaultXMLDocumentHandler
implements ContentHandler {
    private static final int UNINITIALIZED_XPATH_AXIS_TYPE = -1;
    private static final int TOTAL_PATHS = 100;
    private static final int TOTAL_LEVELS = 10;
    private static final int REPLACED = 1;
    private static final int RELATIVE = 2;
    private int curpaths = 0;
    private ArrayList<QName> trackpath;
    private ArrayList<QName>[] table;
    private ArrayList<QName>[] segmentlist;
    private LinkedList<ArrayList<QName>[]> segmentlists;
    private QName lseqn;
    private boolean debug = false;

    public boolean getDebug() {
        return this.debug;
    }

    void init() {
        if (this.table == null) {
            this.table = new ArrayList[100];
        }
        if (this.trackpath == null) {
            this.trackpath = new ArrayList(10);
        }
    }

    public void reset(boolean bl) {
        if (!bl) {
            for (int i2 = 0; i2 < this.curpaths; ++i2) {
                this.table[i2].clear();
            }
        }
        this.curpaths = 0;
        this.lseqn = null;
        if (bl) {
            this.trackpath = null;
            this.table = null;
        } else {
            this.trackpath.clear();
        }
    }

    private ArrayList<QName>[] expand() {
        int n2 = this.curpaths;
        ArrayList[] arrayListArray = new ArrayList[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayListArray[i2] = this.table[i2];
        }
        return arrayListArray;
    }

    private boolean isDuplicateXPath(ArrayList<QName> arrayList) {
        if (this.curpaths == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.curpaths; ++i2) {
            int n2;
            ArrayList<QName> arrayList2 = this.table[i2];
            if (arrayList2.size() != arrayList.size()) continue;
            for (n2 = 0; n2 < arrayList.size() && this.equal(arrayList2.get(n2), arrayList.get(n2)); ++n2) {
            }
            if (n2 != arrayList.size()) continue;
            return true;
        }
        return false;
    }

    private boolean equal(QName qName, QName qName2) {
        return qName.getNamespaceURI().equals(qName2.getNamespaceURI()) && qName.getLocalPart().equals(qName2.getLocalPart());
    }

    private static void print(QNamePlusSep[] qNamePlusSepArray) {
        if (qNamePlusSepArray == null) {
            System.out.println("THIS QNamePlusSep[] IS NULL!!!");
            return;
        }
        for (int i2 = 0; i2 < qNamePlusSepArray.length; ++i2) {
            QNamePlusSep qNamePlusSep = qNamePlusSepArray[i2];
            if (qNamePlusSep.sep == 6 || qNamePlusSep.axistype == 5) {
                System.out.print("//");
            } else if (qNamePlusSep.sep == 5 || qNamePlusSep.axistype == 3) {
                System.out.print("/");
            }
            String string = qNamePlusSep.qname.getNamespaceURI();
            if (string != null && string.length() > 0) {
                System.out.print("{" + string + "}");
            }
            System.out.print(qNamePlusSep.qname.getLocalPart());
        }
        System.out.println();
    }

    private static void print(ArrayList<QName> arrayList) {
        if (arrayList == null) {
            System.out.println("THIS ROW IS NULL!!!");
            return;
        }
        System.out.print("/");
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get(i2).getPrefix();
            if (string != null && string.length() > 0) {
                System.out.print(string + ":");
            }
            System.out.print(arrayList.get(i2).getLocalPart());
            if (i2 == arrayList.size() - 1) {
                System.out.println();
                continue;
            }
            System.out.print("/");
        }
    }

    private static void print(ArrayList<QName>[] arrayListArray, int n2) {
        System.out.println("%%%%%%%%% " + n2 + " xpaths %%%%%%%%%%%%%%%%%");
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<QName> arrayList = arrayListArray[i2];
            XMLPathTable.print(arrayList);
        }
        System.out.println("%%%%%%%%% XPath Table Generated %%%%%%%%%%%%%%%%%");
    }

    public static void print(FastVector fastVector, int n2) {
        if (fastVector == null) {
            return;
        }
        int n3 = fastVector.size();
        if (n3 == 0) {
            return;
        }
        switch (n2) {
            case 1: {
                System.out.print("(replaced by)-->");
                break;
            }
            case 2: {
                System.out.print("(relative xpath is)--> .");
                break;
            }
            default: {
                System.out.print("(PathExpr)--> .");
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            XPathStep xPathStep = (XPathStep)fastVector.elementAt(i2);
            String string = xPathStep.getNormalizedExpr();
            System.out.print(string);
        }
        System.out.println();
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.debug) {
            XMLPathTable.print(this.table, this.curpaths);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        QName qName;
        this.lseqn = qName = new QName(string, string2, this.getPrefix(string3));
        this.trackpath.add(qName);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        QName qName = new QName(string, string2, this.getPrefix(string3));
        if (this.equal(qName, this.lseqn)) {
            ArrayList<QName> arrayList = new ArrayList<QName>(this.trackpath.size());
            for (int i2 = 0; i2 < this.trackpath.size(); ++i2) {
                arrayList.add(this.trackpath.get(i2));
            }
            if (!this.isDuplicateXPath(arrayList)) {
                if (this.curpaths + 1 > this.table.length) {
                    this.table = this.expand();
                }
                this.table[this.curpaths++] = arrayList;
            }
        }
        this.trackpath.remove(this.trackpath.size() - 1);
        if (this.trackpath.size() >= 1) {
            this.lseqn = this.trackpath.get(this.trackpath.size() - 1);
        }
    }

    private PathExpr isPossibleNPE(PathExpr pathExpr) {
        FastVector fastVector = pathExpr.getStepVector();
        if (fastVector == null || fastVector.size() == 0) {
            return pathExpr;
        }
        int n2 = fastVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = fastVector.elementAt(i2);
            if (!(object instanceof XPathStep)) {
                return pathExpr;
            }
            XPathStep xPathStep = (XPathStep)object;
            if (xPathStep.getLocalName() != null && xPathStep.getNamespace() != null) continue;
            return pathExpr;
        }
        return null;
    }

    private String getPrefix(String string) {
        if (string == null || string.length() < 3) {
            return "";
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    private Object replaceStepVector(FastVector fastVector) {
        ArrayList<QName> arrayList;
        XPathStep xPathStep;
        int n2;
        XPathStep xPathStep2 = null;
        int n3 = fastVector.size();
        if (n3 == 0) {
            return fastVector;
        }
        QNamePlusSep[] qNamePlusSepArray = new QNamePlusSep[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Object object = fastVector.elementAt(n2);
            if (!(object instanceof XPathStep)) {
                return fastVector;
            }
            xPathStep = (XPathStep)object;
            if (xPathStep.getNodeTestType() != 451) {
                return fastVector;
            }
            arrayList = xPathStep.axisClass;
            if (arrayList != null && !((XPathAxis)((Object)arrayList)).isForward()) {
                return fastVector;
            }
            qNamePlusSepArray[n2] = new QNamePlusSep();
            qNamePlusSepArray[n2].sep = xPathStep.getPrevSeparator();
            qNamePlusSepArray[n2].qname = new QName(xPathStep.getNamespace(), xPathStep.getLocalName());
            qNamePlusSepArray[n2].axistype = arrayList != null ? ((XPathAxis)((Object)arrayList)).axisType : -1;
        }
        arrayList = null;
        int n4 = this.curpaths;
        ArrayList<QName> arrayList2 = null;
        int n5 = 0;
        this.segmentlists = null;
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList = this.table[n2];
            arrayList2 = this.matching(arrayList, qNamePlusSepArray);
            if (arrayList2 == null || this.isDuplicatedSegmentList(this.segmentlist, this.segmentlists)) continue;
            if (this.debug) {
                XMLPathTable.print(qNamePlusSepArray);
                System.out.print("row " + (n2 + 1) + " (converted to)--> ");
                XMLPathTable.print(arrayList2);
            }
            if (++n5 == 1) {
                this.segmentlists = new LinkedList();
                this.segmentlists.add(this.segmentlist);
                continue;
            }
            this.segmentlists.add(this.segmentlist);
        }
        if (this.segmentlists != null) {
            int n6 = this.segmentlists.size();
            FastVector[] fastVectorArray = null;
            if (n6 > 1) {
                fastVectorArray = new FastVector[n6];
            }
            FastVector fastVector2 = null;
            for (int i2 = 0; i2 < n6; ++i2) {
                this.segmentlist = this.segmentlists.get(i2);
                fastVector2 = new FastVector();
                int[] nArray = this.stepCounts(this.segmentlist);
                PredicatePlusPos[] predicatePlusPosArray = new PredicatePlusPos[nArray.length];
                int n7 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    xPathStep = (XPathStep)fastVector.elementAt(n2);
                    int n8 = xPathStep.getPrevSeparator();
                    if (xPathStep.axisClass != null && xPathStep.axisClass.axisType == 5) {
                        n8 = 6;
                    }
                    if (n8 == 6) {
                        int n9 = this.segmentlist[n7].size();
                        for (int i3 = 0; i3 < n9; ++i3) {
                            if (i3 + 1 == nArray[n7]) {
                                xPathStep2 = xPathStep.clone(true);
                                XPathPredicate xPathPredicate = this.getPredicateFromSet(i3 + 1, predicatePlusPosArray);
                                if (xPathPredicate != null) {
                                    xPathStep2.predicates = xPathPredicate;
                                } else {
                                    predicatePlusPosArray[n7] = new PredicatePlusPos(i3 + 1, xPathStep.predicates);
                                }
                            } else {
                                xPathStep2 = xPathStep.clone(false);
                            }
                            xPathStep2.setPrevSeparator(5);
                            xPathStep2.setLocalName(this.segmentlist[n7].get(i3).getLocalPart());
                            xPathStep2.setNamespace(this.segmentlist[n7].get(i3).getNamespaceURI());
                            fastVector2.addElement(xPathStep2);
                        }
                        ++n7;
                        continue;
                    }
                    fastVector2.addElement(xPathStep);
                }
                if (this.debug) {
                    XMLPathTable.print(fastVector2, 1);
                }
                if (n6 == 1) {
                    return fastVector2;
                }
                fastVectorArray[i2] = fastVector2;
            }
            return fastVectorArray;
        }
        return fastVector;
    }

    private XPathPredicate getPredicateFromSet(int n2, PredicatePlusPos[] predicatePlusPosArray) {
        if (predicatePlusPosArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < predicatePlusPosArray.length && predicatePlusPosArray[i2] != null; ++i2) {
            if (predicatePlusPosArray[i2].pos != n2) continue;
            return predicatePlusPosArray[i2].pred;
        }
        return null;
    }

    private int[] stepCounts(ArrayList<QName>[] arrayListArray) {
        if (arrayListArray == null || arrayListArray.length == 0) {
            return null;
        }
        int[] nArray = new int[arrayListArray.length];
        for (int i2 = 0; i2 < arrayListArray.length; ++i2) {
            nArray[i2] = arrayListArray[i2].size();
        }
        return nArray;
    }

    private boolean isDuplicatedSegmentList(ArrayList<QName>[] arrayListArray, LinkedList<ArrayList<QName>[]> linkedList) {
        if (linkedList == null) {
            return false;
        }
        int n2 = linkedList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<QName>[] arrayListArray2 = linkedList.get(i2);
            if (this.isSame(arrayListArray2, arrayListArray)) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(ArrayList<QName>[] arrayListArray, ArrayList<QName>[] arrayListArray2) {
        if (arrayListArray.length != arrayListArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < arrayListArray.length; ++i2) {
            ArrayList<QName> arrayList = arrayListArray[i2];
            ArrayList<QName> arrayList2 = arrayListArray2[i2];
            if (arrayList.size() != arrayList2.size()) {
                return false;
            }
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                QName qName = arrayList.get(i3);
                QName qName2 = arrayList2.get(i3);
                if (qName.getLocalPart().equals(qName2.getLocalPart()) && qName.getNamespaceURI().equals(qName2.getNamespaceURI())) continue;
                return false;
            }
        }
        return true;
    }

    private ArrayList<QName> matching(ArrayList<QName> arrayList, QNamePlusSep[] qNamePlusSepArray) {
        QName qName;
        Object object;
        int n2;
        int n3 = qNamePlusSepArray.length;
        boolean bl = false;
        ArrayList<QName> arrayList2 = new ArrayList<QName>(arrayList.size());
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.segmentlist = null;
        if (n3 == 0) {
            return null;
        }
        for (n2 = 0; n2 < qNamePlusSepArray.length; ++n2) {
            if (qNamePlusSepArray[n2].sep != 6 && qNamePlusSepArray[n2].axistype != 5) continue;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        this.segmentlist = new ArrayList[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.segmentlist[n2] = new ArrayList();
        }
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            object = qNamePlusSepArray[n2];
            qName = ((QNamePlusSep)object).qname;
            n7 = ((QNamePlusSep)object).sep;
            if (((QNamePlusSep)object).axistype == 5) {
                n7 = 6;
            }
            block9: for (int i2 = n8; i2 < arrayList.size(); ++i2) {
                QName qName2 = arrayList.get(i2);
                switch (n7) {
                    case 3: {
                        continue block9;
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        if (this.equal(qName2, qName)) {
                            arrayList2.add(qName2);
                            i2 = arrayList.size();
                            n8 = n2 + 1;
                            ++n6;
                            continue block9;
                        }
                        return null;
                    }
                    case 6: {
                        if (!this.equal(qName2, qName)) {
                            arrayList2.add(qName2);
                            this.segmentlist[n5].add(qName2);
                            ++n8;
                            continue block9;
                        }
                        arrayList2.add(qName2);
                        i2 = arrayList.size();
                        this.segmentlist[n5].add(qName2);
                        ++n5;
                        ++n8;
                        continue block9;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        if (n4 == n5) {
            if (arrayList2.size() < arrayList.size() && n7 == 6) {
                object = arrayList2.get(arrayList2.size() - 1);
                if (this.equal((QName)object, qName = arrayList.get(arrayList.size() - 1))) {
                    this.segmentlist[n5 - 1] = this.getRowsRemainingItems(arrayList, this.segmentlist, n5, n6);
                    return arrayList;
                }
                return null;
            }
            return arrayList2;
        }
        return null;
    }

    private ArrayList<QName> getRowsRemainingItems(ArrayList<QName> arrayList, ArrayList<QName>[] arrayListArray, int n2, int n3) {
        int n4;
        if (n2 == 0 || arrayListArray == null || arrayList == null) {
            return arrayList;
        }
        int n5 = 0;
        for (n4 = 0; n4 < n2 - 1; ++n4) {
            n5 += arrayListArray[n4].size();
        }
        n4 = arrayList.size() - n5 - n3;
        ArrayList<QName> arrayList2 = new ArrayList<QName>(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            arrayList2.add(arrayList.get(i2 + n5 + n3));
        }
        return arrayList2;
    }

    XSLExprBase getReplacePath(PathExpr pathExpr) throws XSLException {
        Object object;
        FastVector fastVector = pathExpr.getStepVector();
        if (fastVector != (object = this.replaceStepVector(fastVector))) {
            if (object instanceof FastVector) {
                pathExpr.setStepVector((FastVector)object);
                return pathExpr;
            }
            FastVector[] fastVectorArray = (FastVector[])object;
            int n2 = fastVectorArray.length;
            PathExpr[] pathExprArray = new PathExpr[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                pathExprArray[i2] = pathExpr.clone(false);
                pathExprArray[i2].setStepVector(fastVectorArray[i2]);
            }
            XSLNodeSetExpr xSLNodeSetExpr = XSLNodeSetExpr.union(pathExprArray);
            return xSLNodeSetExpr;
        }
        return pathExpr;
    }

    public void printXMLPathTable() {
        XMLPathTable.print(this.table, this.curpaths);
    }

    public XSLExprBase getReplacePath(XSLExprBase xSLExprBase) throws XSLException {
        if (xSLExprBase instanceof PathExpr) {
            PathExpr pathExpr = (PathExpr)xSLExprBase;
            return this.getReplacePath(pathExpr);
        }
        return xSLExprBase;
    }

    class PredicatePlusPos {
        XPathPredicate pred;
        int pos;

        PredicatePlusPos(int n2, XPathPredicate xPathPredicate) {
            this.pos = n2;
            this.pred = xPathPredicate;
        }
    }

    class QNamePlusSep {
        QName qname;
        int sep;
        int axistype;

        QNamePlusSep() {
        }
    }
}

