/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.text.Normalizer;
import oracle.i18n.text.OraNormalizer;
import oracle.xml.xqxp.XQException;

public class UnicodeUtil {
    static OraNormalizer uninormalizer = OraNormalizer.getInstance();
    private static String allHexDigits = "0123456789abcdefABCDEF";

    public static String normalizeUnicodeNFC(String string) {
        return uninormalizer.compose(string);
    }

    public static char[] normalizeUnicodeNFC(char[] cArray, int n2, int n3) {
        String string = new String(cArray, n2, n3);
        if ((string = uninormalizer.compose(string)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static String normalizeUnicode(String string, int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return uninormalizer.normalize(string, n2);
            }
            case 65536: {
                return string;
            }
            case 65537: {
                return uninormalizer.compose(string);
            }
        }
        return string;
    }

    public static String normalizeUnicodeByJdkOrGdk(String string, int n2) {
        switch (n2) {
            case 1: {
                return Normalizer.normalize(string, Normalizer.Form.NFC);
            }
            case 0: {
                return Normalizer.normalize(string, Normalizer.Form.NFD);
            }
            case 3: {
                return Normalizer.normalize(string, Normalizer.Form.NFKC);
            }
            case 2: {
                return Normalizer.normalize(string, Normalizer.Form.NFKD);
            }
            case 65537: {
                return uninormalizer.compose(string);
            }
        }
        throw new XQException("FOCH0003");
    }

    public static char[] normalizeUnicode(char[] cArray, int n2, int n3, int n4) {
        String string = new String(cArray, n2, n3);
        if ((string = UnicodeUtil.normalizeUnicode(string, n4)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static char[] normalizeUnicodeByJdkOrGdk(char[] cArray, int n2, int n3, int n4) {
        String string = new String(cArray, n2, n3);
        if ((string = UnicodeUtil.normalizeUnicodeByJdkOrGdk(string, n4)) != null) {
            return string.toCharArray();
        }
        return null;
    }

    public static String normalize2RFC2396(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                stringBuffer.append(c2);
                continue;
            }
            if (c2 <= ' ' || c2 >= '\u007f') {
                UnicodeUtil.escape(c2, i2 + 1 < string.length() ? string.charAt(i2 + 1) : (char)' ', stringBuffer);
                continue;
            }
            if (c2 == '%') {
                if (i2 + 2 < string.length() && allHexDigits.indexOf(string.charAt(i2 + 1)) >= 0 && allHexDigits.indexOf(string.charAt(i2 + 2)) >= 0) {
                    stringBuffer.append(c2);
                    continue;
                }
                UnicodeUtil.escape(c2, ' ', stringBuffer);
                continue;
            }
            if ("-_.!~*'();/?:@&=+$,#".indexOf(c2) >= 0) {
                stringBuffer.append(c2);
                continue;
            }
            UnicodeUtil.escape(c2, ' ', stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static void escape(char c2, char c3, StringBuffer stringBuffer) {
        String string = "0123456789ABCDEF";
        byte[] byArray = new byte[4];
        int n2 = UnicodeUtil.getUTF8Encoding(c2, c3, byArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] >= 0 ? byArray[i2] : 256 + byArray[i2];
            stringBuffer.append('%');
            stringBuffer.append(string.charAt(n3 / 16));
            stringBuffer.append(string.charAt(n3 % 16));
        }
    }

    private static int getUTF8Encoding(char c2, char c3, byte[] byArray) {
        char c4 = c2;
        if (c4 <= '\u007f') {
            byArray[0] = (byte)c4;
            return 1;
        }
        if (c4 <= '\u07ff') {
            byArray[0] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[1] = (byte)(0x80 | c2 & 0x3F);
            return 2;
        }
        if (c4 >= '\ud800' && c4 <= '\udbff') {
            char c5 = c3;
            if (c5 < '\udc00' || c5 > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + c4 + "," + c5 + ")");
            }
            byte by = (byte)(c5 & 0x3F);
            byte by2 = (byte)((c4 & 3) << 4 | c5 >> 6 & 0xF);
            byte by3 = (byte)(c4 >> 2 & 0xF);
            byte by4 = (byte)((c4 >> 6 & 0xF) + 1);
            byArray[0] = (byte)(0xF0 | by4 >> 2 & 7);
            byArray[1] = (byte)(0x80 | (by4 & 3) << 4 | by3);
            byArray[2] = (byte)(0x80 | by2);
            byArray[3] = (byte)(0x80 | by);
            return 4;
        }
        if (c4 >= '\udc00' && c4 <= '\udfff') {
            return 0;
        }
        byArray[0] = (byte)(0xE0 | c2 >> 12 & 0xF);
        byArray[1] = (byte)(0x80 | c2 >> 6 & 0x3F);
        byArray[2] = (byte)(0x80 | c2 & 0x3F);
        return 3;
    }
}

