/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLByteReader;

class XMLUCS2Reader
extends XMLByteReader {
    boolean utf16Mode = false;
    boolean surrogate = false;

    XMLUCS2Reader(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    @Override
    void reset() {
        this.utf16Mode = false;
        this.surrogate = false;
        super.reset();
    }

    @Override
    void fillBuffer() throws IOException {
        boolean bl = false;
        while (true) {
            try {
                while (true) {
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    int n2 = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n2);
                    if (bl || n2 == 65535 || n2 == 65534) {
                        String string = this.err.getMessage1(171, Integer.toHexString(n2));
                        throw new IOException(string);
                    }
                    this.charBuffer[this.endPos] = (char)n2;
                    this.byteIndex += 2;
                    ++this.endPos;
                    ++this.charsRead;
                    if (this.charBuffer[this.endPos - 1] != '\r' && this.charBuffer[this.endPos - 1] != '\n') continue;
                    char c2 = this.charBuffer[this.endPos - 1];
                    this.setLineNumber(this.endPos - 1);
                    this.charBuffer[this.endPos - 1] = 10;
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    n2 = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.second] & 0xFF;
                    bl = this.checkSurrogate(n2);
                    if (bl || n2 == 65535 || n2 == 65534) {
                        String string = this.err.getMessage1(171, Integer.toHexString(n2));
                        throw new IOException(string);
                    }
                    if (c2 != '\r' || this.charBuffer[this.endPos] == '\n') continue;
                    this.charBuffer[this.endPos] = (char)n2;
                    this.byteIndex += 2;
                    ++this.endPos;
                    ++this.charsRead;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkSurrogate(int n2) {
        if (n2 >= 55296 && n2 < 57344) {
            if (!this.utf16Mode) return true;
            if (n2 < 56320) {
                if (this.surrogate) {
                    return true;
                }
                this.surrogate = true;
                return false;
            } else {
                if (!this.surrogate) {
                    return true;
                }
                this.surrogate = false;
            }
            return false;
        } else {
            if (!this.surrogate) return false;
            return true;
        }
    }

    void setUTF16Mode(boolean bl) {
        this.utf16Mode = bl;
    }

    @Override
    void setByteOrder(int n2) {
        this.byteOrder = n2;
        if (n2 == 1) {
            this.first = 1;
            this.second = 0;
        }
    }
}

