/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

class XMLTreeWalker
implements TreeWalker,
Serializable {
    XMLNode root;
    XMLNode currentNode;
    XMLNode marker;
    int whatToShow;
    NodeFilter filter;
    boolean expandEntityReferences;

    XMLTreeWalker(XMLNode xMLNode, int n2, NodeFilter nodeFilter, boolean bl) {
        this.root = xMLNode;
        this.currentNode = xMLNode;
        this.filter = nodeFilter;
        this.whatToShow = n2;
        this.expandEntityReferences = bl;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node node) throws DOMException {
        if (node == null) {
            throw new XMLDOMException(9, 21014, XMLDocument.defErr, "null", "current node");
        }
        this.currentNode = (XMLNode)node;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    @Override
    public Node parentNode() {
        this.marker = this.currentNode;
        return this.parent_Node(this.marker);
    }

    Node parent_Node(XMLNode xMLNode) {
        if (xMLNode.getNodeType() == 2 || xMLNode == null || xMLNode == this.root) {
            return null;
        }
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        if (xMLNode2 == null) {
            return null;
        }
        if (this.skipThisNode(xMLNode2)) {
            return this.parent_Node(xMLNode2);
        }
        if (this.filter == null || this.filter.acceptNode(xMLNode2) == 1) {
            this.currentNode = xMLNode2;
            return xMLNode2;
        }
        return this.parent_Node(xMLNode2);
    }

    @Override
    public Node firstChild() {
        XMLNode xMLNode = this.currentNode;
        this.marker = (XMLNode)this.currentNode.getFirstChild();
        while (this.marker != null) {
            if (this.marker.getNodeType() == 5 && !this.expandEntityReferences) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter == null || this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            if (this.filter.acceptNode(this.marker) == 3) {
                if (this.marker.hasChildNodes()) {
                    this.currentNode = this.marker;
                    return this.firstChild();
                }
                xMLNode = this.marker;
                this.marker = (XMLNode)this.marker.getNextSibling();
                if (this.marker != null) continue;
                return this.goback(xMLNode);
            }
            this.marker = (XMLNode)this.marker.getNextSibling();
        }
        return null;
    }

    private Node goback(XMLNode xMLNode) {
        if (xMLNode.getNextSibling() == null && (xMLNode = (XMLNode)xMLNode.getParentNode()) != null && this.filter != null && this.filter.acceptNode(xMLNode) == 3) {
            this.currentNode = xMLNode;
            if (xMLNode == this.root) {
                return null;
            }
            return this.nextSibling();
        }
        return null;
    }

    @Override
    public Node lastChild() {
        XMLNode xMLNode = this.currentNode;
        this.marker = (XMLNode)this.currentNode.getLastChild();
        while (this.marker != null) {
            if (this.marker.getNodeType() == 5 && !this.expandEntityReferences) {
                this.marker = (XMLNode)this.marker.getPreviousSibling();
                continue;
            }
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter == null || this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            if (this.filter.acceptNode(this.marker) == 3) {
                if (this.marker.hasChildNodes()) {
                    this.currentNode = this.marker;
                    return this.lastChild();
                }
                xMLNode = this.marker;
                this.marker = (XMLNode)this.marker.getPreviousSibling();
                if (this.marker != null) continue;
                return this.goforward(xMLNode);
            }
            this.marker = (XMLNode)this.marker.getPreviousSibling();
        }
        return null;
    }

    private Node goforward(XMLNode xMLNode) {
        if (xMLNode.getPreviousSibling() == null && (xMLNode = (XMLNode)xMLNode.getParentNode()) != null && this.filter != null && this.filter.acceptNode(xMLNode) == 3) {
            this.currentNode = xMLNode;
            if (xMLNode == this.root) {
                return null;
            }
            return this.previousSibling();
        }
        return null;
    }

    @Override
    public Node nextNode() {
        this.marker = (XMLNode)this.currentNode.getSuccessor(this.root, this.expandEntityReferences);
        return this.next_Node(this.marker);
    }

    Node next_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
            return this.next_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter == null || this.filter.acceptNode(xMLNode2) == 1) {
                this.currentNode = xMLNode2;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        }
        return this.next_Node(xMLNode2);
    }

    @Override
    public Node previousNode() {
        this.marker = (XMLNode)this.currentNode.getPredecessor(this.root, this.expandEntityReferences);
        return this.previous_Node(this.marker);
    }

    Node previous_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
            return this.previous_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter == null || this.filter.acceptNode(xMLNode2) == 1) {
                this.currentNode = xMLNode2;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        }
        return this.previous_Node(xMLNode2);
    }

    @Override
    public Node previousSibling() {
        XMLNode xMLNode = this.currentNode;
        this.marker = (XMLNode)this.currentNode.getPreviousSibling();
        while (this.marker != null) {
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter == null || this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            if (this.filter.acceptNode(this.marker) == 3) {
                if (this.marker.hasChildNodes()) {
                    this.currentNode = this.marker;
                    return this.lastChild();
                }
                xMLNode = this.marker;
                this.marker = (XMLNode)this.marker.getPreviousSibling();
                continue;
            }
            this.marker = (XMLNode)this.marker.getPreviousSibling();
        }
        return this.goforward(xMLNode);
    }

    @Override
    public Node nextSibling() {
        XMLNode xMLNode = this.currentNode;
        this.marker = (XMLNode)this.currentNode.getNextSibling();
        while (this.marker != null) {
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter == null || this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            if (this.filter.acceptNode(this.marker) == 3) {
                if (this.marker.hasChildNodes()) {
                    this.currentNode = this.marker;
                    return this.firstChild();
                }
                xMLNode = this.marker;
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            this.marker = (XMLNode)this.marker.getNextSibling();
        }
        return this.goback(xMLNode);
    }

    boolean skipThisNode(Node node) {
        int n2 = XMLNode.nodeFilterMask[node.getNodeType()];
        return (n2 & this.whatToShow) == 0;
    }
}

