/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLRangeEvent;
import oracle.xml.parser.v2.XMLRangeException;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

class XMLRange
implements Range,
EventListener {
    XMLNode startContainer;
    XMLNode endContainer;
    XMLDocument ownerDoc;
    int startOffset;
    int endOffset;
    int difOffset;
    boolean isTextNodeInserted;
    boolean collapsed;
    XMLNode commonAncestorContainer;
    boolean valid;
    XMLRange next;
    XMLRange previous;
    boolean mutation;

    XMLRange() {
    }

    void init(Node node, Node node2, int n2, int n3, Document document) {
        this.startContainer = (XMLNode)node;
        this.endContainer = (XMLNode)node2;
        this.startOffset = n2;
        this.endOffset = n3;
        this.difOffset = n3 - n2;
        this.isTextNodeInserted = false;
        this.ownerDoc = (XMLDocument)document;
        this.valid = true;
        this.setCommonAncestorContainer(true);
        this.next = null;
        this.previous = null;
        this.collapsed = true;
        this.mutation = true;
    }

    @Override
    public void setStart(Node node, int n2) throws DOMException, RangeException {
        this.validateBoundary(node, n2);
        this.startContainer = (XMLNode)node;
        this.startOffset = n2;
        this.setCommonAncestorContainer(true);
    }

    @Override
    public void setEnd(Node node, int n2) {
        this.validateBoundary(node, n2);
        this.endContainer = (XMLNode)node;
        this.endOffset = n2;
        this.setCommonAncestorContainer(false);
    }

    void validateBoundary(Node node, int n2) {
        short s2 = node.getNodeType();
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.checkType((XMLNode)node);
        this.validateBoundaryPoint(node, n2);
    }

    void validateBoundaryPoint(Node node, int n2) {
        short s2 = node.getNodeType();
        int n3 = 0;
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            n3 = ((CharData)node).getLength();
        } else {
            NodeList nodeList = node.getChildNodes();
            n3 = nodeList.getLength();
        }
        if (n2 < 0 || n2 > n3) {
            throw new XMLDOMException(1, 21001, XMLDocument.defErr, String.valueOf(n2), String.valueOf(n3));
        }
    }

    void checkAncestorType(XMLNode xMLNode) {
        XMLNode xMLNode2;
        short s2 = xMLNode.getNodeType();
        if (s2 == 9 || s2 == 11 || s2 == 2 || s2 == 6 || s2 == 12) {
            throw new XMLRangeException(2);
        }
        XMLNode xMLNode3 = xMLNode2 = (XMLNode)xMLNode.getParentNode();
        while (xMLNode2 != null) {
            xMLNode3 = xMLNode2;
            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
        }
        s2 = xMLNode3.getNodeType();
        if (s2 != 9 && s2 != 11 && s2 != 2 && s2 != 6 && s2 != 12) {
            throw new XMLRangeException(2);
        }
    }

    int getPosition(Node node) {
        XMLNode xMLNode = (XMLNode)node.getParentNode();
        NodeList nodeList = xMLNode.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        for (Node node2 = nodeList.item(0); node2 != null; node2 = node2.getNextSibling()) {
            if (node == node2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void set(Node node, int n2, boolean bl) throws DOMException, RangeException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.checkAncestorType((XMLNode)node);
        int n3 = this.getPosition(node);
        int n4 = n3 + n2;
        Node node2 = node.getParentNode();
        this.validateBoundaryPoint(node2, n4);
        if (bl) {
            this.startContainer = (XMLNode)node2;
            this.startOffset = n4;
            this.setCommonAncestorContainer(true);
        } else {
            this.endContainer = (XMLNode)node2;
            this.endOffset = n4;
            this.setCommonAncestorContainer(false);
        }
    }

    @Override
    public void setStartBefore(Node node) throws DOMException, RangeException {
        this.set(node, 0, true);
    }

    @Override
    public void setStartAfter(Node node) throws DOMException, RangeException {
        this.set(node, 1, true);
    }

    @Override
    public void setEndBefore(Node node) throws DOMException, RangeException {
        this.set(node, 0, false);
    }

    @Override
    public void setEndAfter(Node node) throws DOMException, RangeException {
        this.set(node, 1, false);
    }

    @Override
    public void detach() {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.valid = false;
        this.startContainer = null;
        this.endContainer = null;
        this.commonAncestorContainer = null;
        this.ownerDoc = null;
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        this.next = null;
        this.previous = null;
    }

    @Override
    public void collapse(boolean bl) {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (bl) {
            this.endContainer = this.startContainer;
            this.endOffset = this.startOffset;
        } else {
            this.startContainer = this.endContainer;
            this.startOffset = this.endOffset;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = true;
    }

    @Override
    public Range cloneRange() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        XMLRange xMLRange = (XMLRange)this.ownerDoc.createRange();
        xMLRange.setStart(this.startContainer, this.startOffset);
        xMLRange.setEnd(this.endContainer, this.endOffset);
        return xMLRange;
    }

    @Override
    public void deleteContents() throws DOMException {
        this.deleteContents(null);
    }

    void delete_when_StartEqualToEnd(DocumentFragment documentFragment) {
        short s2 = this.startContainer.getNodeType();
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            String string = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(string.substring(0, this.startOffset) + string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLText xMLText = (XMLText)this.startContainer.cloneNode(true);
                xMLText.setNodeValue(string.substring(this.startOffset, this.endOffset));
                documentFragment.appendChild(xMLText);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.startContainer.getChildNodes();
            int n2 = this.startOffset;
            Node node = nodeList.item(n2);
            Node node2 = node.getNextSibling();
            while (n2 < this.endOffset) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                if ((node = node2) == null) break;
                node2 = node2.getNextSibling();
            }
        }
        this.collapse(true);
    }

    void delete_when_StartAncestorOfEnd(DocumentFragment documentFragment) {
        Object object;
        Object object2;
        short s2 = this.startContainer.getNodeType();
        Node node = null;
        Node node2 = null;
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            object2 = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object2).substring(0, this.startOffset));
            if (documentFragment != null) {
                object = (XMLNode)this.startContainer.cloneNode(true);
                ((XMLNode)object).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
                documentFragment.appendChild((Node)object);
            }
            this.mutation = true;
        } else {
            object2 = this.startContainer.getChildNodes();
            node = object2.item(this.startOffset);
            node2 = node.getNextSibling();
            while (this.selectivity((XMLNode)node) < 1) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = node2;
                node2 = node2.getNextSibling();
            }
        }
        object2 = null;
        object = null;
        Node node3 = null;
        if (node != this.endContainer) {
            for (node2 = this.endContainer.getParentNode(); node2 != node; node2 = node2.getParentNode()) {
                object = object2 = node2.getPreviousSibling();
                if (object2 != null) {
                    node3 = object2.getPreviousSibling();
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    if (documentFragment != null) {
                        documentFragment.appendChild((Node)object2);
                    }
                }
                object2 = node3;
                if (node3 != null) {
                    node3 = node3.getPreviousSibling();
                }
                while (object2 != null) {
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    documentFragment.insertBefore((Node)object2, (Node)object);
                    object2 = node3;
                    if (node3 == null) continue;
                    node3 = node3.getPreviousSibling();
                }
            }
        }
        if ((s2 = this.endContainer.getNodeType()) == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            String string = this.endContainer.getNodeValue();
            this.endContainer.setNodeValue(string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
                xMLNode.setNodeValue(string.substring(0, this.endOffset));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n2 = this.endOffset - 1;
            node = nodeList.item(n2);
            node2 = node.getPreviousSibling();
            while (node != null) {
                node = node.getParentNode().removeChild(node);
                documentFragment.appendChild(node);
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getPreviousSibling();
            }
        }
        this.collapse(true);
    }

    void delete_when_EndAncestorOfStart(DocumentFragment documentFragment) {
        Object object;
        short s2 = this.startContainer.getNodeType();
        Node node = null;
        Object object2 = null;
        Object object3 = null;
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            object = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object).substring(0, this.startOffset));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.startContainer.cloneNode(true);
                xMLNode.setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            object = this.startContainer.getChildNodes();
            node = object.item(this.startOffset);
            if (node != null) {
                object2 = node.getNextSibling();
            }
            while (node != null) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = object2;
                if (object2 == null) continue;
                object2 = object2.getNextSibling();
            }
        }
        node = this.startContainer;
        object3 = null;
        object = null;
        for (object2 = this.startContainer.getParentNode(); object2 != this.commonAncestorContainer; object2 = object2.getParentNode()) {
            object3 = node.getNextSibling();
            if (object3 != null) {
                object = object3.getNextSibling();
            }
            while (object3 != null) {
                object3.getParentNode().removeChild((Node)object3);
                if (documentFragment != null) {
                    documentFragment.appendChild((Node)object3);
                }
                object3 = object;
                if (object == null) continue;
                object = object.getNextSibling();
            }
            node = node.getParentNode();
        }
        int n2 = this.getPosition(node) + 1;
        if ((object2 = object2.getNextSibling()) != null) {
            object = object2.getNextSibling();
        }
        while (n2 < this.endOffset) {
            object2.getParentNode().removeChild((Node)object2);
            if (documentFragment != null) {
                documentFragment.appendChild((Node)object2);
            }
            object2 = object;
            if (object == null) continue;
            object = object.getNextSibling();
        }
        this.collapse(true);
    }

    void delete(DocumentFragment documentFragment) {
        Object object;
        Object object2;
        short s2 = this.startContainer.getNodeType();
        Node node = null;
        Node node2 = null;
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            object2 = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object2).substring(0, this.startOffset));
            if (documentFragment != null) {
                object = (XMLNode)this.startContainer.cloneNode(true);
                ((XMLNode)object).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
                documentFragment.appendChild((Node)object);
            }
            this.mutation = true;
        } else {
            object2 = this.startContainer.getChildNodes();
            node = object2.item(this.startOffset);
            node2 = node.getNextSibling();
            while (node != null) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getNextSibling();
            }
        }
        node = this.startContainer;
        object2 = null;
        object = null;
        for (node2 = this.startContainer.getParentNode(); node2 != this.commonAncestorContainer; node2 = node2.getParentNode()) {
            object2 = node.getNextSibling();
            if (object2 != null) {
                object = object2.getNextSibling();
            }
            while (object2 != null) {
                object2.getParentNode().removeChild((Node)object2);
                if (documentFragment != null) {
                    documentFragment.appendChild((Node)object2);
                }
                object2 = object;
                if (object == null) continue;
                object = object.getNextSibling();
            }
            node = node.getParentNode();
        }
        Node node3 = null;
        if (node != this.endContainer) {
            for (node2 = this.endContainer.getParentNode(); node2 != node; node2 = node2.getParentNode()) {
                object = object2 = node2.getPreviousSibling();
                if (object2 != null) {
                    node3 = object2.getPreviousSibling();
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    if (documentFragment != null) {
                        documentFragment.appendChild((Node)object2);
                    }
                }
                object2 = node3;
                if (node3 != null) {
                    node3 = node3.getPreviousSibling();
                }
                while (object2 != null) {
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    documentFragment.insertBefore((Node)object2, (Node)object);
                    object2 = node3;
                    if (node3 == null) continue;
                    node3 = node3.getPreviousSibling();
                }
            }
        }
        if ((s2 = this.endContainer.getNodeType()) == 3 || s2 == 8 || s2 == 7) {
            this.mutation = false;
            String string = this.endContainer.getNodeValue();
            this.endContainer.setNodeValue(string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
                xMLNode.setNodeValue(string.substring(0, this.endOffset));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n2 = this.endOffset - 1;
            node = nodeList.item(n2);
            node2 = node.getPreviousSibling();
            while (node != null) {
                node = node.getParentNode().removeChild(node);
                documentFragment.appendChild(node);
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getPreviousSibling();
            }
        }
        this.collapse(true);
    }

    void deleteContents(DocumentFragment documentFragment) throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (this.collapsed) {
            return;
        }
        if (this.startContainer == this.endContainer) {
            this.delete_when_StartEqualToEnd(documentFragment);
            return;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.delete_when_StartAncestorOfEnd(documentFragment);
            return;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.delete_when_EndAncestorOfStart(documentFragment);
            return;
        }
        this.delete(documentFragment);
    }

    int selectivity(XMLNode xMLNode) {
        XMLNode xMLNode2;
        int n2 = 0;
        for (xMLNode2 = this.startContainer; xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getParentNode()) {
            if (xMLNode != xMLNode2) continue;
            ++n2;
            break;
        }
        for (xMLNode2 = this.endContainer; xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getParentNode()) {
            if (xMLNode != xMLNode2) continue;
            ++n2;
            break;
        }
        return n2;
    }

    @Override
    public DocumentFragment extractContents() {
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.ownerDoc.createDocumentFragment();
        this.deleteContents(xMLDocumentFragment);
        return xMLDocumentFragment;
    }

    int depth(Node node) {
        int n2 = 0;
        Node node2 = node;
        while (node2 != null) {
            if ((node2 = node2.getParentNode()) != null) {
                this.checkType((XMLNode)node2);
            }
            ++n2;
        }
        return n2;
    }

    void setCommonAncestorContainer_when_StartEqualToEnd(boolean bl) {
        if (this.startOffset >= this.endOffset) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer_when_StartAncestorOfEnd(boolean bl) {
        Node node = this.endContainer;
        for (Node node2 = this.endContainer.getParentNode(); node2 != this.startContainer; node2 = node2.getParentNode()) {
            node = node2;
        }
        int n2 = this.getPosition(node);
        if (n2 < this.startOffset) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer_when_EndAncestorOfStart(boolean bl) {
        Node node = this.startContainer;
        for (Node node2 = this.startContainer.getParentNode(); node2 != this.endContainer; node2 = node2.getParentNode()) {
            node = node2;
        }
        int n2 = this.getPosition(node);
        if (n2 > this.endOffset - 1) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.endContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer(boolean bl) throws RangeException, DOMException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.startContainer == this.endContainer) {
            this.setCommonAncestorContainer_when_StartEqualToEnd(bl);
            return;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.setCommonAncestorContainer_when_StartAncestorOfEnd(bl);
            return;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.setCommonAncestorContainer_when_EndAncestorOfStart(bl);
            return;
        }
        XMLNode xMLNode = this.startContainer;
        XMLNode xMLNode2 = this.endContainer;
        XMLNode xMLNode3 = null;
        XMLNode xMLNode4 = null;
        int n6 = this.depth(this.startContainer);
        if (n6 > (n5 = this.depth(this.endContainer))) {
            n4 = n6 - n5;
            n3 = n5;
            xMLNode = this.startContainer;
            xMLNode2 = this.endContainer;
            for (n2 = 0; n2 < n4; ++n2) {
                xMLNode3 = xMLNode;
                xMLNode = (XMLNode)xMLNode.getParentNode();
            }
        } else if (n6 < n5) {
            n4 = n5 - n6;
            n3 = n6;
            xMLNode2 = this.endContainer;
            xMLNode = this.startContainer;
            for (n2 = 0; n2 < n4; ++n2) {
                xMLNode4 = xMLNode2;
                xMLNode2 = (XMLNode)xMLNode2.getParentNode();
            }
        } else {
            xMLNode = this.startContainer;
            xMLNode2 = this.endContainer;
            n3 = n6;
        }
        n2 = 0;
        while (n2 <= n3) {
            if (xMLNode == xMLNode2) {
                if (this.getPosition(xMLNode3) > this.getPosition(xMLNode4)) {
                    this.collapse(bl);
                    return;
                }
                this.commonAncestorContainer = xMLNode;
                this.collapsed = false;
                return;
            }
            ++n2;
            xMLNode3 = xMLNode;
            xMLNode4 = xMLNode2;
            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
            xMLNode = (XMLNode)xMLNode.getParentNode();
        }
        this.collapse(bl);
    }

    @Override
    public Node getCommonAncestorContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.commonAncestorContainer;
    }

    @Override
    public boolean getCollapsed() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.collapsed;
    }

    @Override
    public Node getEndContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.endContainer;
    }

    @Override
    public Node getStartContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.startContainer;
    }

    @Override
    public int getStartOffset() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.startOffset;
    }

    @Override
    public int getEndOffset() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.endOffset;
    }

    @Override
    public short compareBoundaryPoints(short s2, Range range) {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = null;
        int n2 = 0;
        int n3 = 0;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (this.getRootContainer() != ((XMLRange)range).getRootContainer()) {
            throw new XMLDOMException(4, 21006, XMLDocument.defErr);
        }
        if (s2 == 0) {
            xMLNode2 = this.startContainer;
            xMLNode = ((XMLRange)range).startContainer;
            n2 = this.startOffset;
            n3 = ((XMLRange)range).startOffset;
        } else if (s2 == 1) {
            xMLNode2 = this.startContainer;
            xMLNode = ((XMLRange)range).endContainer;
            n2 = this.startOffset;
            n3 = ((XMLRange)range).endOffset;
        } else if (s2 == 2) {
            xMLNode2 = this.endContainer;
            xMLNode = ((XMLRange)range).endContainer;
            n2 = this.endOffset;
            n3 = ((XMLRange)range).endOffset;
        } else if (s2 == 3) {
            xMLNode2 = this.endContainer;
            xMLNode = ((XMLRange)range).startContainer;
            n2 = this.endOffset;
            n3 = ((XMLRange)range).startOffset;
        }
        if (xMLNode2 == xMLNode) {
            if (n2 < n3) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            return 0;
        }
        XMLNode xMLNode3 = xMLNode2;
        XMLNode xMLNode4 = null;
        while (xMLNode3 != null) {
            xMLNode4 = xMLNode3;
            if ((xMLNode3 = (XMLNode)xMLNode3.getParentNode()) != xMLNode) continue;
            int n4 = this.getPosition(xMLNode4);
            if (n4 < n3) {
                return -1;
            }
            return 1;
        }
        xMLNode3 = xMLNode;
        while (xMLNode3 != null) {
            xMLNode4 = xMLNode3;
            if ((xMLNode3 = (XMLNode)xMLNode3.getParentNode()) != xMLNode2) continue;
            int n5 = this.getPosition(xMLNode4);
            if (n2 <= n5) {
                return -1;
            }
            return 1;
        }
        xMLNode3 = xMLNode2;
        while (xMLNode3 != null) {
            if ((xMLNode3 = (XMLNode)xMLNode3.getSuccessor(this.getRootContainer(), true)) != xMLNode) continue;
            return -1;
        }
        return 1;
    }

    @Override
    public void insertNode(Node node) throws DOMException, RangeException {
        XMLNode xMLNode = null;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        short s2 = node.getNodeType();
        if (s2 == 2 || s2 == 12 || s2 == 11 || s2 == 9) {
            throw new XMLRangeException(2);
        }
        s2 = this.startContainer.getNodeType();
        if (s2 == 3) {
            this.mutation = false;
            this.difOffset = this.endOffset - this.startOffset;
            XMLText xMLText = (XMLText)((XMLText)this.startContainer).splitText(this.startOffset);
            xMLNode = (XMLNode)xMLText.getParentNode();
            xMLNode.insertBefore(node, xMLText);
            this.startContainer = (XMLNode)xMLText.getPreviousSibling();
            this.startOffset = 0;
            this.mutation = true;
            this.isTextNodeInserted = true;
            this.collapsed = false;
        } else {
            NodeList nodeList = this.startContainer.getChildNodes();
            this.startContainer.insertBefore(node, nodeList.item(this.startOffset));
        }
    }

    @Override
    public void selectNodeContents(Node node) throws DOMException, RangeException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (node.getNodeType() == 9) {
            throw new XMLRangeException(2);
        }
        for (XMLNode xMLNode = (XMLNode)node.getParentNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            this.checkType(xMLNode);
        }
        this.commonAncestorContainer = (XMLNode)node;
        this.startContainer = (XMLNode)node;
        this.endContainer = (XMLNode)node;
        this.startOffset = 0;
        short s2 = node.getNodeType();
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            this.endOffset = ((CharData)node).getLength();
        } else {
            NodeList nodeList = node.getChildNodes();
            this.endOffset = nodeList.getLength();
        }
        this.collapsed = this.startOffset == this.endOffset;
    }

    @Override
    public void selectNode(Node node) throws RangeException, DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        for (XMLNode xMLNode = (XMLNode)node; xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            this.checkType(xMLNode);
        }
        this.endContainer = this.startContainer = (XMLNode)node.getParentNode();
        this.commonAncestorContainer = this.startContainer;
        this.startOffset = this.getPosition(node);
        this.endOffset = this.startOffset + 1;
    }

    @Override
    public String toString() throws DOMException {
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.cloneContents();
        if (xMLDocumentFragment != null) {
            return xMLDocumentFragment.getText();
        }
        return null;
    }

    void checkType(XMLNode xMLNode) throws RangeException {
        short s2 = xMLNode.getNodeType();
        if (s2 == 6 || s2 == 12 || s2 == 10) {
            throw new XMLRangeException(2);
        }
    }

    XMLNode getRootContainer() {
        XMLNode xMLNode;
        XMLNode xMLNode2 = xMLNode = this.startContainer;
        while (xMLNode != null) {
            xMLNode2 = xMLNode;
            xMLNode = (XMLNode)xMLNode.getParentNode();
        }
        return xMLNode2;
    }

    boolean isAncestor(XMLNode xMLNode, XMLNode xMLNode2) {
        for (XMLNode xMLNode3 = (XMLNode)xMLNode2.getParentNode(); xMLNode3 != null; xMLNode3 = (XMLNode)xMLNode3.getParentNode()) {
            if (xMLNode3 != xMLNode) continue;
            return true;
        }
        return false;
    }

    void clone_when_StartEqualToEnd(DocumentFragment documentFragment) {
        short s2 = this.startContainer.getNodeType();
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            String string = this.startContainer.getNodeValue();
            XMLText xMLText = (XMLText)this.startContainer.cloneNode(true);
            xMLText.setNodeValue(string.substring(this.startOffset, this.endOffset));
            documentFragment.appendChild(xMLText);
        } else {
            int n2;
            NodeList nodeList = this.startContainer.getChildNodes();
            Node node = nodeList.item(n2);
            for (n2 = this.startOffset; n2 < this.endOffset; ++n2) {
                documentFragment.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
        }
    }

    void clone_when_StartAncestorOfEnd(DocumentFragment documentFragment) {
        Node node;
        Object object;
        short s2 = this.startContainer.getNodeType();
        Node node2 = null;
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            object = this.startContainer.getNodeValue();
            node = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node).setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
            documentFragment.appendChild(node);
        } else {
            object = this.startContainer.getChildNodes();
            node2 = object.item(this.startOffset);
            while (this.selectivity((XMLNode)node2) < 1) {
                documentFragment.appendChild(node2.cloneNode(true));
                node2 = node2.getNextSibling();
            }
        }
        node = null;
        Node node3 = null;
        if (node2 != this.endContainer) {
            for (object = this.endContainer.getParentNode(); object != node2; object = object.getParentNode()) {
                node3 = node = object.getPreviousSibling();
                if (node != null) {
                    documentFragment.appendChild(node.cloneNode(true));
                }
                for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
                    node3 = documentFragment.insertBefore(node.cloneNode(true), node3);
                }
            }
        }
        if ((s2 = this.endContainer.getNodeType()) == 3 || s2 == 8 || s2 == 7) {
            String string = this.endContainer.getNodeValue();
            XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
            xMLNode.setNodeValue(string.substring(0, this.endOffset));
            documentFragment.appendChild(xMLNode);
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n2 = 0;
            for (Node node4 = nodeList.item(n2); n2 < this.endOffset && node4 != null; node4 = node4.getNextSibling(), ++n2) {
                documentFragment.appendChild(node4.cloneNode(true));
            }
        }
    }

    void clone_when_EndAncestorOfStart(DocumentFragment documentFragment) {
        Node node;
        Node node2;
        Object object;
        short s2 = this.startContainer.getNodeType();
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            object = this.startContainer.getNodeValue();
            node2 = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node2).setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
            documentFragment.appendChild(node2);
        } else {
            object = this.startContainer.getChildNodes();
            for (node = object.item(this.startOffset); node != null; node = node.getNextSibling()) {
                documentFragment.appendChild(node.cloneNode(true));
            }
        }
        node = this.startContainer;
        node2 = null;
        for (object = this.startContainer.getParentNode(); object != this.commonAncestorContainer; object = object.getParentNode()) {
            for (node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
                documentFragment.appendChild(node2.cloneNode(true));
            }
            node = node.getParentNode();
        }
        object = object.getNextSibling();
        for (int i2 = this.getPosition(node) + 1; i2 < this.endOffset; ++i2) {
            documentFragment.appendChild(object.cloneNode(true));
            object = object.getNextSibling();
        }
    }

    void clone(DocumentFragment documentFragment) {
        Object object;
        Node node;
        Node node2;
        Object object2;
        short s2 = this.startContainer.getNodeType();
        if (s2 == 3 || s2 == 8 || s2 == 7) {
            object2 = this.startContainer.getNodeValue();
            node2 = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node2).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
            documentFragment.appendChild(node2);
        } else {
            object2 = this.startContainer.getChildNodes();
            for (node = object2.item(this.startOffset); node != null; node = node.getNextSibling()) {
                documentFragment.appendChild(node.cloneNode(true));
            }
        }
        node = this.startContainer;
        node2 = null;
        for (object2 = this.startContainer.getParentNode(); object2 != this.commonAncestorContainer; object2 = object2.getParentNode()) {
            if (node != null) {
                node2 = node.getNextSibling();
            }
            while (node2 != null) {
                documentFragment.appendChild(node2.cloneNode(true));
                node2 = node2.getNextSibling();
            }
            node = node.getParentNode();
        }
        int n2 = this.getPosition(node) + 1;
        node = node.getNextSibling();
        while (this.selectivity((XMLNode)node) < 1) {
            documentFragment.appendChild(node.cloneNode(true));
            node = node.getNextSibling();
        }
        if (node != this.endContainer) {
            node2 = null;
            object = null;
            for (object2 = this.endContainer.getParentNode(); object2 != node; object2 = object2.getParentNode()) {
                node2 = object2.getPreviousSibling();
                object = node2;
                if (node2 != null) {
                    documentFragment.appendChild(node2.cloneNode(true));
                    node2 = node2.getPreviousSibling();
                }
                while (node2 != null) {
                    object = documentFragment.insertBefore(node2.cloneNode(true), (Node)object);
                    node2 = node2.getPreviousSibling();
                }
            }
        }
        if ((s2 = this.endContainer.getNodeType()) == 3 || s2 == 8 || s2 == 7) {
            object = this.endContainer.getNodeValue();
            XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
            xMLNode.setNodeValue(((String)object).substring(0, this.endOffset));
            documentFragment.appendChild(xMLNode);
        } else {
            object = this.endContainer.getChildNodes();
            Node node3 = object.item(n2);
            for (n2 = 0; n2 < this.endOffset; ++n2) {
                documentFragment.appendChild(node3.cloneNode(true));
                node3 = node3.getNextSibling();
            }
        }
    }

    void clone_when_StartInsertedEnd_Text(DocumentFragment documentFragment) {
        short s2 = this.startContainer.getNodeType();
        if (s2 == 3) {
            XMLText xMLText;
            String string;
            XMLText xMLText2;
            for (xMLText2 = (XMLText)this.startContainer; xMLText2 != this.endContainer; xMLText2 = (XMLText)xMLText2.getNextSibling()) {
                string = xMLText2.getNodeValue();
                xMLText = (XMLText)xMLText2.cloneNode(true);
                xMLText.setNodeValue(string);
                documentFragment.appendChild(xMLText);
            }
            string = xMLText2.getNodeValue();
            xMLText = (XMLText)xMLText2.cloneNode(true);
            xMLText.setNodeValue(string.substring(0, this.difOffset));
            documentFragment.appendChild(xMLText);
        }
    }

    @Override
    public DocumentFragment cloneContents() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        DocumentFragment documentFragment = this.ownerDoc.createDocumentFragment();
        if (this.collapsed) {
            return null;
        }
        if (this.startContainer == this.endContainer) {
            this.clone_when_StartEqualToEnd(documentFragment);
            return documentFragment;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.clone_when_StartAncestorOfEnd(documentFragment);
            return documentFragment;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.clone_when_EndAncestorOfStart(documentFragment);
            return documentFragment;
        }
        if (this.isTextNodeInserted) {
            this.clone_when_StartInsertedEnd_Text(documentFragment);
            return documentFragment;
        }
        this.clone(documentFragment);
        return documentFragment;
    }

    @Override
    public void surroundContents(Node node) throws DOMException, RangeException {
        short s2;
        XMLNode xMLNode;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        for (xMLNode = (XMLNode)this.startContainer.getParentNode(); xMLNode != this.commonAncestorContainer && xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            s2 = xMLNode.getNodeType();
            if (this.selectivity(xMLNode) != 1 || s2 == 3 || s2 == 8 || s2 == 7) continue;
            throw new XMLRangeException(1);
        }
        for (xMLNode = (XMLNode)this.endContainer.getParentNode(); xMLNode != this.commonAncestorContainer && xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            s2 = xMLNode.getNodeType();
            if (this.selectivity(xMLNode) != 1 || s2 == 3 || s2 == 8 || s2 == 7) continue;
            throw new XMLRangeException(1);
        }
        s2 = node.getNodeType();
        if (s2 == 2 || s2 == 10 || s2 == 12 || s2 == 9 || s2 == 11) {
            throw new XMLRangeException(2);
        }
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.extractContents();
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = nodeList.item(0);
        Node node3 = null;
        if (node2 != null) {
            node3 = node2.getNextSibling();
        }
        while (node2 != null) {
            node.removeChild(node2);
            node2 = node3;
            if (node3 == null) continue;
            node3 = node3.getNextSibling();
        }
        node.appendChild(xMLDocumentFragment);
        this.insertNode(node);
    }

    @Override
    public void handleEvent(Event event) {
        XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)event;
        String string = xMLRangeEvent.getType();
        if (string.equals("RANGE_SETTEXT_EVENT")) {
            this.setTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getNewValue());
        } else if (string.equals("RANGE_INSERTTEXT_EVENT")) {
            this.insertTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getOffset(), xMLRangeEvent.getLength());
        } else if (string.equals("RANGE_DELETETEXT_EVENT")) {
            this.deleteTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getOffset(), xMLRangeEvent.getLength());
        } else if (string.equals("RANGE_INSERT_EVENT")) {
            this.insertNotify((XMLNode)xMLRangeEvent.getRelatedNode());
        } else if (string.equals("RANGE_DELETE_EVENT")) {
            this.deleteNotify((XMLNode)xMLRangeEvent.getRelatedNode());
        } else if (string.equals("RANGE_REPLACE_EVENT")) {
            this.replaceNotify((XMLNode)xMLRangeEvent.getRelatedNode(), (XMLNode)xMLRangeEvent.getReplacingNode());
        }
        xMLRangeEvent.stopPropagation();
        event.preventDefault();
    }

    void setTextNotify(XMLNode xMLNode, String string) {
        int n2 = 0;
        if (this.mutation) {
            if (xMLNode == this.startContainer && (n2 = string.length()) - 1 < this.startOffset) {
                this.startOffset = n2 - 1;
            }
            if (xMLNode == this.endContainer && (n2 = string.length()) - 1 < this.endOffset) {
                this.endOffset = n2 - 1;
            }
        }
    }

    void insertTextNotify(XMLNode xMLNode, int n2, int n3) {
        if (xMLNode == this.startContainer && --n2 < this.startOffset) {
            this.startOffset += n3;
        }
        if (xMLNode == this.endContainer && n2 < this.endOffset) {
            this.endOffset += n3;
        }
    }

    void deleteTextNotify(XMLNode xMLNode, int n2, int n3) {
        if (xMLNode == this.startContainer && --n2 <= this.startOffset) {
            this.startOffset = n2 + n3 >= this.startOffset ? n2 : (this.startOffset -= n3);
        }
        if (xMLNode == this.endContainer && n2 <= this.startOffset) {
            this.endOffset = n2 + n3 >= this.endOffset ? n2 : (this.endOffset -= n3);
        }
    }

    void insertNotify(XMLNode xMLNode) {
        NodeList nodeList = null;
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        if (xMLNode2 == this.startContainer) {
            nodeList = xMLNode2.getChildNodes();
            int n2 = 0;
            int n3 = nodeList.getLength();
            for (Node node = nodeList.item(n2); n2 < n3 && node != xMLNode; ++n2, node = node.getNextSibling()) {
            }
            if (n2 <= this.startOffset) {
                ++this.startOffset;
            }
            if (n2 < this.endOffset && this.startContainer == this.endContainer) {
                ++this.endOffset;
            }
            return;
        }
        if (xMLNode2 == this.endContainer) {
            nodeList = xMLNode2.getChildNodes();
            int n4 = 0;
            int n5 = nodeList.getLength();
            for (Node node = nodeList.item(n4); n4 < n5 && node != xMLNode; ++n4, node = node.getNextSibling()) {
            }
            if (n4 <= this.endOffset) {
                ++this.endOffset;
            }
        }
    }

    void deleteNotify(XMLNode xMLNode) {
        Node node;
        NodeList nodeList = null;
        int n2 = 0;
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        int n3 = this.selectivity(xMLNode);
        if (n3 == 0 && xMLNode2 != this.startContainer && xMLNode2 != this.endContainer) {
            return;
        }
        if (n3 == 2 || this.commonAncestorContainer == xMLNode) {
            nodeList = xMLNode2.getChildNodes();
            n2 = 0;
            int n4 = nodeList.getLength();
            for (Node node2 = nodeList.item(n2); n2 < n4 && node2 != xMLNode; node2 = node2.getNextSibling(), ++n2) {
            }
            this.startContainer = xMLNode2;
            this.endContainer = xMLNode2;
            this.commonAncestorContainer = xMLNode2;
            this.startOffset = n2;
            this.endOffset = n2;
            this.collapsed = true;
            return;
        }
        for (node = this.startContainer; node != this.commonAncestorContainer; node = (XMLNode)node.getParentNode()) {
            if (node != xMLNode) continue;
            this.collapse(false);
            return;
        }
        for (node = this.endContainer; node != this.commonAncestorContainer; node = (XMLNode)node.getParentNode()) {
            if (node != xMLNode) continue;
            this.collapse(true);
            return;
        }
        if (xMLNode2 == this.startContainer) {
            nodeList = xMLNode2.getChildNodes();
            n2 = 0;
            int n5 = nodeList.getLength();
            for (node = nodeList.item(n2); n2 < n5 && node != xMLNode; ++n2, node = node.getNextSibling()) {
            }
            if (n2 < this.startOffset) {
                --this.startOffset;
            }
            if (xMLNode2 == this.endContainer && n2 <= this.endOffset) {
                --this.endOffset;
            }
            return;
        }
        if (xMLNode2 == this.endContainer) {
            nodeList = xMLNode2.getChildNodes();
            n2 = 0;
            int n6 = nodeList.getLength();
            for (node = nodeList.item(n2); n2 < n6 && node != xMLNode; ++n2, node = node.getNextSibling()) {
            }
            if (n2 <= this.endOffset) {
                --this.endOffset;
            }
            return;
        }
    }

    void replaceNotify(XMLNode xMLNode, XMLNode xMLNode2) {
        if (this.commonAncestorContainer == xMLNode || this.commonAncestorContainer.isAncestor(xMLNode)) {
            this.commonAncestorContainer = xMLNode2;
            this.startContainer = xMLNode2;
            this.endContainer = xMLNode2;
            this.startOffset = 0;
            this.endOffset = 0;
            this.collapsed = true;
            return;
        }
        if (this.startContainer.isAncestor(xMLNode)) {
            this.collapse(false);
            return;
        }
        if (this.endContainer.isAncestor(xMLNode)) {
            this.collapse(true);
            return;
        }
        if (this.startContainer == xMLNode) {
            this.startContainer = xMLNode2;
            short s2 = this.startContainer.getNodeType();
            if (s2 == 3 || s2 == 8 || s2 == 7) {
                String string = this.startContainer.getNodeValue();
                if (string.length() - 1 < this.startOffset) {
                    this.startOffset = string.length() - 1;
                }
            } else {
                NodeList nodeList = this.startContainer.getChildNodes();
                int n2 = nodeList.getLength();
                if (n2 - 1 < this.startOffset) {
                    this.startOffset = n2 - 1;
                }
            }
            this.setCommonAncestorContainer(true);
            return;
        }
        if (this.endContainer == xMLNode) {
            this.endContainer = xMLNode2;
            short s3 = this.endContainer.getNodeType();
            if (s3 == 3 || s3 == 8 || s3 == 7) {
                String string = this.endContainer.getNodeValue();
                if (string.length() - 1 < this.endOffset) {
                    this.startOffset = string.length() - 1;
                }
            } else {
                NodeList nodeList = this.endContainer.getChildNodes();
                int n3 = nodeList.getLength();
                if (n3 - 1 < this.startOffset) {
                    this.endOffset = n3 - 1;
                }
            }
            this.setCommonAncestorContainer(false);
            return;
        }
    }
}

