/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.async.SAXBuilder;
import oracle.xml.parser.v2.XMLDOMConfiguration;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLLSInput;
import oracle.xml.parser.v2.XMLLSLoadEvent;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.XMLError;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;

public class XMLLSParser
implements LSParser,
DOMBuilderListener,
EventTarget,
Serializable {
    public static final String LOAD_EVENT = "ls-load";
    public static final String PROGRESS_EVENT = "ls-progress";
    private DOMConfiguration config = null;
    private LSParserFilter builderFilter = null;
    private EventListener loadEventListener = null;
    private EventListener errorEventListener = null;
    private EventListener progressEventListener = null;
    private XMLDocument doc = null;
    private LSInput inputSource = null;
    private boolean parseErrorFlag = false;
    private SAXBuilder parser = null;
    private short mode;
    private String DTD = "http://www.w3.org/TR/REC-xml";
    private String SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final XMLError xerr = new XMLError();

    public XMLLSParser() {
        this(1, null);
    }

    public XMLLSParser(short s2, String string) {
        this.mode = s2;
        this.config = new XMLDOMConfiguration();
        this.parser = new SAXBuilder();
        this.parser.addDOMBuilderListener(this);
    }

    public DOMConfiguration getConfig() {
        return this.config;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.config;
    }

    @Override
    public LSParserFilter getFilter() {
        return this.builderFilter;
    }

    @Override
    public void setFilter(LSParserFilter lSParserFilter) {
        this.builderFilter = lSParserFilter;
    }

    @Override
    public boolean getAsync() {
        return this.mode == 2;
    }

    @Override
    public boolean getBusy() {
        return this.parser.isBusy();
    }

    @Override
    public Document parse(LSInput lSInput) throws DOMException {
        block12: {
            this.inputSource = lSInput;
            Reader reader = lSInput.getCharacterStream();
            InputStream inputStream = lSInput.getByteStream();
            String string = lSInput.getStringData();
            String string2 = lSInput.getSystemId();
            String string3 = lSInput.getPublicId();
            String string4 = lSInput.getBaseURI();
            this.parser.setAsyncMode(this.getAsync());
            if (this.builderFilter != null) {
                this.parser.setBuilderFilter(this.builderFilter);
            }
            String string5 = XMLDOMConfiguration.configFeature[1];
            boolean bl = (Boolean)this.config.getParameter(string5);
            this.parser.retainCDATASection(bl);
            this.parser.setValidationMode(0);
            string5 = XMLDOMConfiguration.configFeature[14];
            bl = (Boolean)this.config.getParameter(string5);
            if (bl) {
                this.parser.setValidationMode(4);
            }
            if (bl = ((Boolean)this.config.getParameter(string5 = XMLDOMConfiguration.configFeature[15])).booleanValue()) {
                this.parser.setValidationMode(3);
            }
            string5 = XMLDOMConfiguration.configFeature[17];
            bl = (Boolean)this.config.getParameter(string5);
            this.parser.setPreserveWhitespace(bl);
            try {
                if (string4 != null) {
                    this.parser.setBaseURL(new URL(string4));
                }
                if (reader != null) {
                    this.parser.parse(reader);
                    break block12;
                }
                if (inputStream != null) {
                    this.parser.parse(inputStream);
                    break block12;
                }
                if (string != null) {
                    this.parser.parse(new StringReader(string));
                    break block12;
                }
                if (string2 != null) {
                    this.parser.parse(string2);
                    break block12;
                }
                if (string3 != null) {
                    this.parser.parse(string3);
                    break block12;
                }
                String string6 = xerr.getMessage0(21034);
                throw new XMLDOMException(11, string6);
            }
            catch (Exception exception) {
                String string7 = xerr.getMessage0(21035);
                throw new XMLDOMException(11, string7);
            }
        }
        if (this.mode == 2) {
            return null;
        }
        return this.doc;
    }

    @Override
    public Document parseURI(String string) throws DOMException {
        XMLLSInput xMLLSInput = new XMLLSInput();
        xMLLSInput.setSystemId(string);
        return this.parse(xMLLSInput);
    }

    @Override
    public Node parseWithContext(LSInput lSInput, Node node, short s2) throws DOMException {
        block17: {
            Document document = this.parse(lSInput);
            if (document == null) {
                return null;
            }
            try {
                XMLDocument xMLDocument = (XMLDocument)node.getOwnerDocument();
                XMLNode xMLNode = (XMLNode)node.getParentNode();
                Node node2 = xMLDocument.adoptNode(document.getDocumentElement());
                if (s2 == 1) {
                    short s3 = node.getNodeType();
                    if (s3 != 1 && s3 != 11) {
                        String string = xerr.getMessage0(21036);
                        throw new XMLDOMException(3, string);
                    }
                    node.appendChild(node2);
                    break block17;
                }
                if (s2 == 4) {
                    if (xMLNode == null) {
                        String string = xerr.getMessage0(21037);
                        throw new XMLDOMException(8, string);
                    }
                    short s4 = xMLNode.getNodeType();
                    if (s4 != 1 && s4 != 11) {
                        String string = xerr.getMessage0(21038);
                        throw new XMLDOMException(3, string);
                    }
                    xMLNode.appendChild(node2);
                    break block17;
                }
                if (s2 == 3) {
                    if (xMLNode == null) {
                        String string = xerr.getMessage0(21037);
                        throw new XMLDOMException(8, string);
                    }
                    short s5 = xMLNode.getNodeType();
                    if (s5 != 1 && s5 != 11) {
                        String string = xerr.getMessage0(21038);
                        throw new XMLDOMException(3, string);
                    }
                    xMLNode.insertBefore(node2, node);
                    break block17;
                }
                if (s2 == 5) {
                    if (xMLNode == null) {
                        String string = xerr.getMessage0(21037);
                        throw new XMLDOMException(8, string);
                    }
                    short s6 = xMLNode.getNodeType();
                    if (s6 != 1 && s6 != 11) {
                        String string = xerr.getMessage0(21038);
                        throw new XMLDOMException(3, string);
                    }
                    xMLNode.replaceChild(node2, node);
                    break block17;
                }
                if (s2 == 2) {
                    short s7 = node.getNodeType();
                    if (s7 != 1 && s7 != 9 && s7 != 11) {
                        String string = xerr.getMessage0(21036);
                        throw new XMLDOMException(3, string);
                    }
                    NodeList nodeList = ((XMLElement)node).getChildrenByTagName("*");
                    for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                        node.removeChild(nodeList.item(i2));
                    }
                    node.appendChild(node2);
                    break block17;
                }
                String string = xerr.getMessage0(21039);
                throw new XMLDOMException(3, string);
            }
            catch (Exception exception) {
                if (!(exception instanceof DOMException)) break block17;
                throw (DOMException)exception;
            }
        }
        return null;
    }

    @Override
    public void abort() {
        if (this.mode == 2 && this.getBusy()) {
            this.parser.abort();
        }
    }

    @Override
    public synchronized void domBuilderStarted(DOMBuilderEvent dOMBuilderEvent) {
    }

    @Override
    public synchronized void domBuilderError(DOMBuilderEvent dOMBuilderEvent) {
        this.parseErrorFlag = true;
    }

    @Override
    public synchronized void domBuilderOver(DOMBuilderEvent dOMBuilderEvent) {
        if (this.parseErrorFlag) {
            this.doc = null;
        } else {
            this.doc = ((SAXBuilder)dOMBuilderEvent.getSource()).getDocument();
            XMLLSLoadEvent xMLLSLoadEvent = new XMLLSLoadEvent();
            xMLLSLoadEvent.setInputSource(this.inputSource);
            xMLLSLoadEvent.setNewDocument(this.doc);
            xMLLSLoadEvent.setTarget(this);
            this.dispatchEvent(xMLLSLoadEvent);
        }
    }

    @Override
    public synchronized void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (string.equals(LOAD_EVENT)) {
            this.loadEventListener = eventListener;
        } else if (string.equals(PROGRESS_EVENT)) {
            this.progressEventListener = eventListener;
        }
    }

    @Override
    public synchronized void removeEventListener(String string, EventListener eventListener, boolean bl) {
        if (string.equals(LOAD_EVENT)) {
            this.loadEventListener = null;
        } else if (string.equals(PROGRESS_EVENT)) {
            this.progressEventListener = null;
        }
    }

    @Override
    public boolean dispatchEvent(Event event) throws DOMException {
        String string = event.getType();
        if (string.equals(LOAD_EVENT) && this.loadEventListener != null) {
            this.loadEventListener.handleEvent(event);
        } else if (string.equals(PROGRESS_EVENT) && this.progressEventListener != null) {
            this.progressEventListener.handleEvent(event);
        }
        return true;
    }
}

