/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;

class XMLByteReader {
    static final int DEFAULT_SAVE = 32;
    static final int LITTLE_ENDIAN = 1;
    static final int BIG_ENDIAN = 2;
    static final int OCTET_2143 = 3;
    static final int OCTET_3412 = 4;
    char[] charBuffer;
    char[] defaultCharBuffer;
    int charPos;
    int endPos;
    int eofPos;
    byte[] byteBuffer;
    byte[] defaultByteBuffer;
    int byteIndex;
    int endIndex;
    int eofIndex;
    int[] lineNumbers;
    int lineNumSize = 1024;
    int lastLine;
    int cumLine;
    int curLine;
    int byteOrder = -1;
    int first = 0;
    int second = 1;
    int third = 2;
    int fourth = 3;
    InputStream in;
    boolean closeInput;
    XMLEntity en;
    String sysId;
    String pubId;
    XMLError err;
    int BUFSIZE;
    long bytesRead;
    long charsRead;
    private static final byte[] newLine = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
    private static final int DEFAULT_BUFSIZE = 16388;
    private static final int INFINITY = Math.max(0x3FFFFFFF, 16390);

    XMLByteReader() {
        this(16388);
    }

    XMLByteReader(int n2) {
        this.BUFSIZE = n2;
        this.defaultCharBuffer = new char[this.BUFSIZE];
        this.defaultByteBuffer = new byte[this.BUFSIZE];
        this.charBuffer = this.defaultCharBuffer;
        this.byteBuffer = this.defaultByteBuffer;
        this.lineNumbers = new int[this.lineNumSize];
        this.reset();
    }

    XMLByteReader(InputStream inputStream, String string, String string2) {
        this();
        this.in = inputStream;
        this.sysId = string;
        this.pubId = string2;
    }

    void reset() {
        this.charPos = this.BUFSIZE;
        this.endPos = this.BUFSIZE;
        this.byteIndex = this.BUFSIZE;
        this.endIndex = this.BUFSIZE;
        this.eofPos = INFINITY;
        this.eofIndex = INFINITY;
        this.lineNumbers[0] = this.BUFSIZE - 1;
        this.lastLine = 0;
        this.cumLine = 0;
        this.curLine = 1;
    }

    char[] getBuffer() {
        return this.charBuffer;
    }

    int getPosition() {
        return this.charPos;
    }

    void setPosition(int n2) {
        this.charPos = n2;
    }

    void setCloseInput(boolean bl) {
        this.closeInput = bl;
    }

    void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    void pushBytes(int[] nArray, int n2, int n3) {
        while (n3 > n2) {
            this.byteBuffer[--this.byteIndex] = (byte)nArray[--n3];
        }
    }

    int pushChars(char[] cArray, int n2, int n3) {
        while (n3 > n2) {
            this.charBuffer[--this.charPos] = cArray[--n3];
        }
        return this.charPos;
    }

    int pushChar(char c2) {
        this.charBuffer[--this.charPos] = c2;
        return this.charPos;
    }

    int getLineNumber() {
        for (int i2 = this.lastLine; i2 < this.curLine; ++i2) {
            if (this.charPos > this.lineNumbers[i2]) continue;
            this.lastLine = i2;
            return this.cumLine + i2;
        }
        this.lastLine = this.curLine;
        return this.cumLine + this.curLine;
    }

    int getColumnNumber() {
        this.getLineNumber();
        if (this.lastLine > 0) {
            return this.charPos - this.lineNumbers[this.lastLine - 1];
        }
        return this.charPos;
    }

    void setLineNumber(int n2) {
        try {
            this.lineNumbers[this.curLine++] = n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray = this.lineNumbers;
            this.lineNumbers = new int[this.lineNumSize * 2];
            System.arraycopy(nArray, 0, this.lineNumbers, 0, this.lineNumSize);
            this.lineNumSize *= 2;
            this.lineNumbers[this.curLine++] = n2;
        }
    }

    void close() throws IOException {
        if (this.in != null && this.closeInput) {
            this.in.close();
        }
        if (this.BUFSIZE != 16388) {
            this.charBuffer = this.defaultCharBuffer;
            this.byteBuffer = this.defaultByteBuffer;
        }
    }

    void fillByteBuffer() throws IOException {
        int n2 = 0;
        int n3 = this.BUFSIZE;
        if (this.byteIndex != this.endIndex) {
            System.arraycopy(this.byteBuffer, this.byteIndex, this.byteBuffer, 0, this.endIndex - this.byteIndex);
        }
        this.endIndex -= this.byteIndex;
        this.byteIndex = 0;
        n3 = this.BUFSIZE - this.endIndex;
        while (n3 != 0) {
            n2 = this.in.read(this.byteBuffer, this.endIndex, n3);
            if (n2 != -1) {
                this.endIndex += n2;
                n3 -= n2;
                this.bytesRead += (long)n2;
                continue;
            }
            if (this.endIndex < this.BUFSIZE) {
                this.byteBuffer[this.endIndex] = -1;
            }
            this.eofIndex = this.endIndex;
            break;
        }
    }

    void resetLineNumber(int n2) {
        int n3;
        int n4 = this.BUFSIZE - n2;
        if (n4 != 0) {
            System.arraycopy(this.charBuffer, n2, this.charBuffer, 0, n4);
        }
        int n5 = this.curLine - 1;
        for (n3 = this.curLine - 1; n3 >= 0; --n3) {
            if (n2 <= this.lineNumbers[n3]) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        int n6 = 0;
        while (n3 < this.curLine) {
            this.lineNumbers[n6] = this.lineNumbers[n3] - n2;
            ++n3;
            ++n6;
        }
        this.curLine -= n5;
        this.cumLine += n5;
        this.lastLine = 0;
    }

    void growBuffer() throws IOException {
        char[] cArray = new char[this.BUFSIZE * 2];
        System.arraycopy(this.charBuffer, 0, cArray, 0, this.endPos);
        byte[] byArray = new byte[this.BUFSIZE * 2];
        System.arraycopy(this.byteBuffer, 0, byArray, 0, this.endIndex);
        this.BUFSIZE *= 2;
        this.charBuffer = cArray;
        this.byteBuffer = byArray;
        if (this.eofIndex < this.BUFSIZE) {
            this.byteBuffer[this.eofIndex] = -1;
        } else {
            this.fillByteBuffer();
        }
        this.fillBuffer();
    }

    int saveBuffer(int n2) throws IOException {
        if (n2 == 0) {
            this.growBuffer();
            return n2;
        }
        int n3 = n2;
        if (n2 == this.BUFSIZE) {
            n3 = this.BUFSIZE - 32;
        }
        this.resetLineNumber(n3);
        this.charPos = n2 - n3;
        this.endPos -= n3;
        this.fillBuffer();
        return this.charPos;
    }

    void fillBuffer() throws IOException {
        while (true) {
            try {
                block8: while (true) {
                    byte by = this.byteBuffer[this.byteIndex];
                    switch (newLine[by & 0xFF]) {
                        case 0: {
                            this.charBuffer[this.endPos] = (char)by;
                            ++this.endPos;
                            ++this.byteIndex;
                            ++this.charsRead;
                            break;
                        }
                        case 1: {
                            this.charBuffer[this.endPos] = 10;
                            this.setLineNumber(this.endPos);
                            ++this.endPos;
                            ++this.byteIndex;
                            ++this.charsRead;
                            if (by != 13 || this.byteBuffer[this.byteIndex] != 10) continue block8;
                            ++this.byteIndex;
                            break;
                        }
                        case 3: {
                            if (this.byteIndex >= this.eofIndex) {
                                this.setEOF(this.endPos);
                                return;
                            }
                            this.charBuffer[this.endPos] = (char)by;
                            ++this.endPos;
                            ++this.byteIndex;
                            ++this.charsRead;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    boolean isEOF() {
        return this.eofPos != INFINITY;
    }

    void setEOF(int n2) {
        this.eofPos = n2;
        if (n2 < this.BUFSIZE) {
            this.charBuffer[n2] = 65535;
        }
    }

    void setByteOrder(int n2) {
    }

    int getByteOrder() {
        return this.byteOrder;
    }
}

