/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLInfosetReader;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetReader2;
import oracle.xml.util.QxName;

public class ScalableDOMPrintDriver
extends XMLPrintDriver {
    private int txtSize = Integer.MAX_VALUE;

    public ScalableDOMPrintDriver(Writer writer) {
        super(writer);
    }

    public ScalableDOMPrintDriver(PrintWriter printWriter) {
        super(printWriter);
    }

    public ScalableDOMPrintDriver(OutputStream outputStream) {
        super(outputStream);
    }

    public void setTextSizeLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.txtSize = n2;
    }

    @Override
    public void printElement(XMLElement xMLElement, boolean bl) throws IOException {
        XMLNode xMLNode;
        boolean bl2 = false;
        if (this.printInheritedNS && this.inheritedNS == null && (xMLNode = (XMLNode)xMLElement.getParentNode()).getNodeType() == 1) {
            this.inheritedNS = xMLElement.getAllNamespaceAttrs();
            bl2 = true;
        }
        this.internalPrintElement(xMLElement, bl);
        if (bl2) {
            this.inheritedNS = null;
        }
        this.out.flush();
    }

    @Override
    void internalPrintElement(XMLElement xMLElement, boolean bl) throws IOException {
        if (!xMLElement.isNodeFlag(2048) || xMLElement.isNodeFlag(64)) {
            super.internalPrintElement(xMLElement, bl);
        } else {
            InfosetReader2 infosetReader2 = xMLElement.xdkGetReader();
            Object object = xMLElement.xdkGetOffset();
            infosetReader2.seekFromObject(object);
            this.printElement(infosetReader2);
        }
    }

    private void printElement(InfosetReader infosetReader) throws IOException {
        boolean bl = true;
        boolean bl2 = this.out.mixed;
        int n2 = this.out.getOutputStyle();
        int n3 = this.nsVector.size();
        int n4 = this.prefixCount;
        this.prevSize = n3;
        this.nsDeclToPrint.clear();
        this.out.writeIndent();
        this.out.writeChars("<");
        SAXAttrList sAXAttrList = (SAXAttrList)infosetReader.getAttributes();
        this.scanNSDecls(sAXAttrList);
        QName qName = infosetReader.getQName();
        String string = ((QxName)qName).getQName();
        String string2 = qName.getPrefix();
        String string3 = qName.getLocalPart();
        String string4 = qName.getNamespaceURI();
        string2 = this.checkConflicts(string2, string4, true);
        if (string2 == null) {
            this.out.writeChars(string);
        } else {
            if (!string2.equals("")) {
                this.out.writeChars(string2);
                this.out.write(58);
            }
            this.out.writeChars(string3);
        }
        this.printAttributes(sAXAttrList);
        this.printNsDecls();
        infosetReader.next();
        int n5 = infosetReader.getEventType();
        if (n5 != 2) {
            this.out.writeChars(">");
            bl = false;
            this.out.mixed = true;
            this.out.writeNewLine();
            this.out.addIndent(1);
        }
        while (true) {
            switch (n5) {
                case 1: {
                    this.printElement(infosetReader);
                    break;
                }
                case 2: {
                    this.out.addIndent(-1);
                    this.out.writeIndent();
                    this.out.mixed = bl2;
                    this.out.addIndent(-1);
                    this.out.writeIndent();
                    this.out.mixed = bl2;
                    if (bl) {
                        this.out.writeChars("/>");
                    } else {
                        this.out.writeChars("</");
                        if (string2 == null) {
                            this.out.writeChars(string);
                        } else {
                            if (!string2.equals("")) {
                                this.out.writeChars(string2);
                                this.out.write(58);
                            }
                            this.out.writeChars(string3);
                        }
                        this.out.writeChars(">");
                    }
                    this.out.writeNewLine();
                    this.out.setOutputStyle(n2);
                    this.prefixCount = n4;
                    this.nsVector.setSize(n3);
                    this.prefixVector.setSize(n3);
                    return;
                }
                case 5: {
                    this.printComment(infosetReader);
                    break;
                }
                case 6: {
                    this.printSpace(infosetReader);
                    break;
                }
                case 12: {
                    this.printCDATA(infosetReader);
                    break;
                }
                case 4: {
                    this.printText(infosetReader);
                    break;
                }
                case 9: {
                    this.printEntityReference(infosetReader);
                    break;
                }
                case 3: {
                    this.printPI(infosetReader);
                }
            }
            infosetReader.hasNext();
            infosetReader.next();
            n5 = infosetReader.getEventType();
        }
    }

    private void scanNSDecls(SAXAttrList sAXAttrList) throws IOException {
        String string;
        String string2;
        int n2 = sAXAttrList.count;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = sAXAttrList.name[i2];
            string2 = sAXAttrList.prefix[i2];
            string = sAXAttrList.values[i2];
            if ("xmlns".equals(string2)) {
                this.addNsDeclPrinted(string3, string);
                continue;
            }
            if (!"xmlns".equals(string3)) continue;
            this.addNsDeclPrinted("", string);
        }
        if (this.inheritedNS != null && !this.inheritedNS.isEmpty()) {
            Enumeration enumeration = this.inheritedNS.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)this.inheritedNS.get(string2);
                if (this.nsDeclToPrint.get(string2) != null) continue;
                this.addNsDeclPrinted(string2, string);
            }
            this.inheritedNS.clear();
        }
    }

    private void printAttributes(SAXAttrList sAXAttrList) throws IOException {
        int n2 = sAXAttrList.count;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = sAXAttrList.namespace[i2];
            String string2 = sAXAttrList.name[i2];
            String string3 = sAXAttrList.prefix[i2];
            String string4 = sAXAttrList.qname[i2];
            if ("xmlns".equals(string3)) {
                this.nsDeclToPrint.remove(string2);
            } else if ("xmlns".equals(string2)) {
                this.nsDeclToPrint.remove("");
            } else {
                string3 = string == null || string.equals("") ? null : this.checkConflicts(string3, string, false);
            }
            if (!sAXAttrList.specified[i2] && !this.printAllAttrs) continue;
            this.out.write(32);
            if (string3 == null) {
                this.out.writeChars(string4);
            } else {
                if (!string3.equals("")) {
                    this.out.writeChars(string3);
                    this.out.write(58);
                }
                this.out.writeChars(string2);
            }
            XMLAttr.print1(this.out, sAXAttrList.values[i2]);
        }
    }

    private void printNsDecls() throws IOException {
        Enumeration enumeration = this.nsDeclToPrint.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (this.lookupNsDecl(string2, string = (String)this.nsDeclToPrint.get(string2), this.prevSize) == 1) continue;
            this.out.write(32);
            this.out.writeChars("xmlns");
            if (string2 != null && !string2.equals("")) {
                this.out.write(58);
            }
            this.out.writeChars(string2);
            this.out.write(61);
            this.out.write(34);
            if (string != null) {
                this.out.writeChars(string);
            }
            this.out.write(34);
        }
    }

    private void printText(InfosetReader infosetReader) throws IOException {
        char[] cArray = this.txtSize < Integer.MAX_VALUE && infosetReader instanceof BinXMLInfosetReader ? ((BinXMLInfosetReader)infosetReader).getData(this.txtSize) : infosetReader.getData();
        int n2 = infosetReader.getDataLength();
        for (int i2 = infosetReader.getDataStart(); i2 < n2; ++i2) {
            if (cArray[i2] == '&') {
                this.out.writeChars("&amp;");
                continue;
            }
            if (cArray[i2] == '<') {
                this.out.writeChars("&lt;");
                continue;
            }
            if (i2 > 1 && cArray[i2] == '>') {
                if (cArray[i2 - 1] == ']' && cArray[i2 - 2] == ']') {
                    this.out.writeChars("&gt;");
                    continue;
                }
                this.out.write(62);
                continue;
            }
            this.out.write(cArray[i2]);
        }
    }

    private void printSpace(InfosetReader infosetReader) throws IOException {
        this.printText(infosetReader);
    }

    private void printComment(InfosetReader infosetReader) throws IOException {
        this.out.writeIndent();
        this.out.writeChars("<!--");
        char[] cArray = infosetReader.getData();
        int n2 = infosetReader.getDataLength();
        this.printText(infosetReader);
        this.out.writeChars("-->");
        this.out.writeNewLine();
    }

    private void printCDATA(InfosetReader infosetReader) throws IOException {
        this.out.writeIndent();
        this.out.writeChars("<![CDATA[");
        char[] cArray = infosetReader.getData();
        int n2 = infosetReader.getDataLength();
        for (int i2 = infosetReader.getDataStart(); i2 < n2; ++i2) {
            this.out.write(cArray[i2]);
        }
        this.out.writeChars("]]>");
        this.out.writeNewLine();
    }

    private void printPI(InfosetReader infosetReader) {
    }

    private void printEntityReference(InfosetReader infosetReader) {
    }
}

