/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.File;
import java.io.OutputStream;
import java.sql.Blob;
import oracle.xml.comp.CXMLHandlerBase;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.PageManager;

public class BinaryParser
extends XMLParser {
    BinaryStream stream = BinaryStream.newInstance("XDK_CXML_BINARY");
    public static final int BINARY_RESULT_ID = 31;
    public static final int PAGE_MANAGER_ID = 32;
    public static final int ELEMENT_INDEXING_ID = 33;

    public BinaryParser() {
        CXMLHandlerBase cXMLHandlerBase = new CXMLHandlerBase((CXMLStream)this.stream);
        cXMLHandlerBase.setProperty("oracle.xml.parser.DOMParser.Parser", this);
        this.setContentHandler(cXMLHandlerBase, cXMLHandlerBase);
        this.parser.lexHandler = cXMLHandlerBase;
        this.parser.err = new XMLError();
        try {
            this.parser.lexHandler = cXMLHandlerBase;
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    public void setBinaryStream(BinaryStream binaryStream) throws IllegalArgumentException {
        if (!(binaryStream instanceof CXMLStream)) {
            throw new IllegalArgumentException("Binary type not supported");
        }
        this.stream = binaryStream;
        CXMLHandlerBase cXMLHandlerBase = new CXMLHandlerBase((CXMLStream)binaryStream);
        cXMLHandlerBase.setProperty("oracle.xml.parser.DOMParser.Parser", this);
        this.setContentHandler(cXMLHandlerBase, cXMLHandlerBase);
        this.parser.lexHandler = cXMLHandlerBase;
    }

    public BinaryStream getBinaryStream() {
        return this.stream;
    }

    @Override
    public void setAttribute(int n2, Object object) throws IllegalArgumentException {
        switch (n2) {
            case 31: {
                try {
                    if (object instanceof Blob) {
                        this.stream.setBlob((Blob)object);
                        break;
                    }
                    if (object instanceof File) {
                        this.stream.setFile((File)object);
                        break;
                    }
                    if (!(object instanceof OutputStream)) break;
                    this.stream.setOutputStream((OutputStream)object);
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            case 32: {
                if (object instanceof PageManager) {
                    PageManager pageManager = (PageManager)object;
                    this.stream.setPageManager(pageManager);
                    break;
                }
                throw new IllegalArgumentException();
            }
            case 33: {
                if (!(object instanceof Boolean)) break;
                CXMLWriter cXMLWriter = (CXMLWriter)((CXMLHandlerBase)this.parser.lexHandler).getInfosetWriter();
                if (object == Boolean.TRUE) {
                    cXMLWriter.setIndexing(2);
                    break;
                }
                cXMLWriter.setIndexing(1);
                break;
            }
            default: {
                super.setAttribute(n2, object);
                return;
            }
        }
    }
}

