/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

class XSDIdConstraintTable {
    XSDIdentity definition;
    Hashtable idInstances;
    XSDSimpleType[] keyTypes;
    int nkeys;

    XSDIdConstraintTable(XSDIdentity xSDIdentity) {
        this.definition = xSDIdentity;
        this.idInstances = new Hashtable();
        this.nkeys = xSDIdentity.nfields;
    }

    void addElement(XMLElement xMLElement) {
        NodeTable nodeTable = new NodeTable();
        this.idInstances.put(xMLElement, nodeTable);
    }

    void validateIdConstraints() throws XSDException {
        Enumeration enumeration = this.idInstances.keys();
        while (enumeration.hasMoreElements()) {
            this.addConstraint((XMLElement)enumeration.nextElement());
        }
    }

    void validateKeyref(XSDIdConstraintTable xSDIdConstraintTable) throws XSDException {
        Enumeration enumeration = this.idInstances.elements();
        while (enumeration.hasMoreElements()) {
            NodeTable nodeTable = (NodeTable)enumeration.nextElement();
            for (int i2 = 0; i2 < nodeTable.len; ++i2) {
                boolean bl = false;
                Enumeration enumeration2 = xSDIdConstraintTable.idInstances.elements();
                while (enumeration2.hasMoreElements()) {
                    NodeTable nodeTable2 = (NodeTable)enumeration2.nextElement();
                    if (!nodeTable2.findKeySeq(nodeTable.keySequences[i2])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new XSDException("Key sequence not found in key reference");
            }
        }
    }

    void addConstraint(XMLElement xMLElement) throws XSDException {
        NodeList nodeList;
        try {
            nodeList = xMLElement.selectNodes(this.definition.getSelectorExpr());
        }
        catch (XSLException xSLException) {
            throw new XSDException("XPath error");
        }
        NodeTable nodeTable = (NodeTable)this.idInstances.get(xMLElement);
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            XMLElement xMLElement2 = (XMLElement)nodeList.item(i2);
            nodeTable.addKeySequence(xMLElement2);
        }
        this.idInstances.put(xMLElement, nodeTable);
    }

    class NodeTable {
        XMLElement[] targetNodes;
        String[][] keySequences;
        int size = 16;
        int len = 0;

        NodeTable() {
            this.keySequences = new String[this.size][XSDIdConstraintTable.this.nkeys];
            this.targetNodes = new XMLElement[this.size];
        }

        void addKeySequence(XMLElement xMLElement) throws XSDException {
            int n2;
            this.ensureCapacity();
            this.targetNodes[this.len] = xMLElement;
            int n3 = XSDIdConstraintTable.this.definition.nodeType;
            block6: for (n2 = 0; n2 < XSDIdConstraintTable.this.nkeys; ++n2) {
                NodeList nodeList;
                try {
                    nodeList = xMLElement.selectNodes(XSDIdConstraintTable.this.definition.getFieldExpr(n2));
                }
                catch (XSLException xSLException) {
                    throw new XSDException("XPathe error");
                }
                switch (nodeList.getLength()) {
                    case 0: {
                        XSDIdentity cfr_ignored_0 = XSDIdConstraintTable.this.definition;
                        if (n3 == 23) {
                            throw new XSDException("empty key");
                        }
                        return;
                    }
                    case 1: {
                        this.keySequences[this.len][n2] = ((XMLNode)nodeList.item(0)).getText().intern();
                        continue block6;
                    }
                    default: {
                        throw new XSDException("constraint is not unique");
                    }
                }
            }
            XSDIdentity cfr_ignored_1 = XSDIdConstraintTable.this.definition;
            if (n3 != 24) {
                for (n2 = 0; n2 < this.len; ++n2) {
                    if (!this.equalKeySeq(n2, this.len)) continue;
                    throw new XSDException("duplicate keys");
                }
            }
            ++this.len;
        }

        boolean equalKeySeq(int n2, int n3) {
            for (int i2 = 0; i2 < XSDIdConstraintTable.this.nkeys; ++i2) {
                if (this.keySequences[n2][i2] == this.keySequences[n3][i2]) continue;
                return false;
            }
            return true;
        }

        boolean findKeySeq(String[] stringArray) {
            for (int i2 = 0; i2 < this.len; ++i2) {
                boolean bl = true;
                for (int i3 = 0; i3 < XSDIdConstraintTable.this.nkeys; ++i3) {
                    if (stringArray[i3].intern() == this.keySequences[i2][i3].intern()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }

        void ensureCapacity() {
            if (this.len >= this.size) {
                XMLElement[] xMLElementArray = this.targetNodes;
                String[][] stringArray = this.keySequences;
                this.targetNodes = new XMLElement[this.size * 2];
                this.keySequences = new String[this.size * 2][XSDIdConstraintTable.this.nkeys];
                System.arraycopy(xMLElementArray, 0, this.targetNodes, 0, this.size);
                System.arraycopy(stringArray, 0, this.keySequences, 0, this.size);
                this.size *= 2;
            }
        }
    }
}

