/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class XSDGroup
extends XSDNode
implements XSDParticleNode {
    String refNamespace;
    String refLocalname;
    int refState;
    int order = 0;
    int minOccurs = 1;
    int maxOccurs = 1;
    ArrayList nodeVector;
    int[] offsets;
    int vectorSize = 0;
    int width;
    HashMap pathTable;
    FastVector elemList;
    byte[] viLevel;
    boolean optional = false;
    boolean topGroup = false;
    boolean allElement;

    XSDGroup() {
        this(5);
    }

    XSDGroup(int n2, int n3, short s2) {
        this(5);
        this.minOccurs = n2;
        this.maxOccurs = n3;
        this.order = s2;
    }

    XSDGroup(int n2) {
        this.nodeType = n2;
        if (this.nodeType == 6) {
            this.order = 2;
        }
        this.nodeVector = new ArrayList(10);
        this.refState = 0;
    }

    void setParticleNode(XSDParticleNode xSDParticleNode, int n2) {
        this.nodeVector.set(n2, xSDParticleNode);
    }

    void addParticleNode(XSDParticleNode xSDParticleNode) {
        this.nodeVector.add(xSDParticleNode);
        this.vectorSize = this.nodeVector.size();
        if (((XSDNode)((Object)xSDParticleNode)).parent == null) {
            ((XSDNode)((Object)xSDParticleNode)).parent = this;
        }
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }

    public String getRefNamespace() {
        return this.refNamespace;
    }

    @Override
    public String getRefLocalname() {
        return this.refLocalname;
    }

    int minOccurs(int n2) {
        if (n2 >= 0 && n2 < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.get(n2)).getMinOccurs();
        }
        return -1;
    }

    int maxOccurs(int n2) {
        if (n2 >= 0 && n2 < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.get(n2)).getMaxOccurs();
        }
        return -1;
    }

    boolean isOptional(int n2) {
        XSDParticleNode xSDParticleNode = (XSDParticleNode)this.nodeVector.get(n2);
        if (xSDParticleNode instanceof XSDGroup) {
            return ((XSDGroup)xSDParticleNode).optional;
        }
        return xSDParticleNode.getMinOccurs() == 0;
    }

    public Vector getNodeVector() {
        return new Vector(this.nodeVector);
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public void setMinOccurs(int n2) {
        this.minOccurs = n2;
    }

    @Override
    public void setMaxOccurs(int n2) {
        this.maxOccurs = n2;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isTopGroup() {
        return this.topGroup;
    }

    @Override
    public boolean isEmptiable() {
        if (this.minOccurs == 0) {
            return true;
        }
        if (this.order == 2 || this.order == 0) {
            for (int i2 = 0; i2 < this.vectorSize; ++i2) {
                if (((XSDParticleNode)this.nodeVector.get(i2)).isEmptiable()) continue;
                return false;
            }
            return true;
        }
        for (int i3 = 0; i3 < this.vectorSize; ++i3) {
            if (!((XSDParticleNode)this.nodeVector.get(i3)).isEmptiable()) continue;
            return true;
        }
        return false;
    }

    XSDElement[] getVisible() {
        if (!this.topGroup) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        XSDGroup xSDGroup = (XSDGroup)this.nodeVector.get(0);
        xSDGroup.getVisible(false, arrayList, -1);
        if (arrayList.size() > 0) {
            int n2 = arrayList.size();
            XSDElement[] xSDElementArray = new XSDElement[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                xSDElementArray[i2] = (XSDElement)arrayList.get(i2);
            }
            return xSDElementArray;
        }
        return null;
    }

    XSDElement[] getVisible(boolean bl, String string, String string2) {
        if (!this.topGroup || this.pathTable == null) {
            return null;
        }
        QxName qxName = QxNameHash.create(string, string2, "", string2);
        int[] nArray = (int[])this.pathTable.get(qxName);
        if (nArray == null) {
            return null;
        }
        int n2 = nArray[0];
        ArrayList arrayList = new ArrayList();
        XSDGroup xSDGroup = (XSDGroup)this.nodeVector.get(0);
        xSDGroup.getVisible(bl, arrayList, n2);
        if (arrayList.size() > 0) {
            int n3 = arrayList.size();
            XSDElement[] xSDElementArray = new XSDElement[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                xSDElementArray[i2] = (XSDElement)arrayList.get(i2);
            }
            return xSDElementArray;
        }
        return null;
    }

    void addElement(ArrayList arrayList, XSDNode xSDNode) {
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (!xSDNode.equals((XSDNode)arrayList.get(i2))) continue;
            return;
        }
        arrayList.add(xSDNode);
    }

    boolean getVisible(boolean bl, ArrayList arrayList, int n2) {
        int n3;
        int n4;
        XSDNode xSDNode;
        int n5 = this.getBranch(n2);
        if (this.order == 2) {
            for (int i2 = 0; i2 < this.vectorSize; ++i2) {
                XSDNode xSDNode2 = (XSDNode)this.nodeVector.get(i2);
                if (!(xSDNode2 instanceof XSDElement)) continue;
                this.addElement(arrayList, xSDNode2);
            }
            return false;
        }
        if (this.order == 1) {
            boolean bl2 = false;
            if (n5 >= 0) {
                int n6;
                XSDNode xSDNode3 = (XSDNode)this.nodeVector.get(n5);
                return !(xSDNode3 instanceof XSDGroup) || (bl2 = ((XSDGroup)xSDNode3).getVisible(bl, arrayList, n2 - (n6 = this.getOffset(n5))));
            }
            for (int i3 = 0; i3 < this.vectorSize; ++i3) {
                int n7 = this.getOffset(i3);
                XSDNode xSDNode4 = (XSDNode)this.nodeVector.get(i3);
                if (((XSDParticleNode)((Object)xSDNode4)).getMinOccurs() == 0) {
                    bl2 = true;
                }
                if (xSDNode4 instanceof XSDElement) {
                    this.addElement(arrayList, xSDNode4);
                    continue;
                }
                if (!(xSDNode4 instanceof XSDGroup) || !((XSDGroup)xSDNode4).getVisible(bl, arrayList, n2 - n7)) continue;
                bl2 = true;
            }
            return bl2;
        }
        boolean bl3 = true;
        if (n5 >= 0) {
            xSDNode = (XSDNode)this.nodeVector.get(n5);
            n4 = this.getOffset(n5);
            if (xSDNode instanceof XSDGroup && !(bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n2 - n4))) {
                return false;
            }
        }
        if (bl) {
            int n8;
            int n9 = n8 = n5 >= 0 ? n5 - 1 : this.vectorSize - 1;
            while (n8 >= 0) {
                xSDNode = (XSDNode)this.nodeVector.get(n8);
                n4 = this.getOffset(n8);
                if (xSDNode instanceof XSDElement) {
                    bl3 = false;
                    this.addElement(arrayList, xSDNode);
                } else if (xSDNode instanceof XSDGroup) {
                    bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n2 - n4);
                }
                if (((XSDParticleNode)((Object)xSDNode)).getMinOccurs() > 0 && !bl3) {
                    return false;
                }
                --n8;
            }
            return true;
        }
        int n10 = n3 = n5 >= 0 ? n5 + 1 : 0;
        while (n3 < this.vectorSize) {
            xSDNode = (XSDNode)this.nodeVector.get(n3);
            n4 = this.getOffset(n3);
            if (xSDNode instanceof XSDElement) {
                bl3 = false;
                this.addElement(arrayList, xSDNode);
            } else if (xSDNode instanceof XSDGroup) {
                bl3 = ((XSDGroup)xSDNode).getVisible(bl, arrayList, n2 - n4);
            }
            if (((XSDParticleNode)((Object)xSDNode)).getMinOccurs() > 0 && !bl3) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDGroup xSDGroup = (XSDGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDGroup != null && xSDGroup.vectorSize > 0) {
            this.refState = 0;
            xSDGroup = (XSDGroup)xSDGroup.item(0);
            this.nodeVector = xSDGroup.nodeVector;
            this.vectorSize = xSDGroup.vectorSize;
            this.order = xSDGroup.order;
            this.annotation = xSDGroup.annotation;
        }
    }

    XSDParticleNode item(int n2) {
        if (n2 >= 0 && n2 < this.vectorSize) {
            return (XSDParticleNode)this.nodeVector.get(n2);
        }
        return null;
    }

    @Override
    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n2) throws Exception {
        int n3;
        if (this.topGroup) {
            if (this.isClean || this.width == 0) {
                return false;
            }
            if (this.elemList == null) {
                this.elemList = new FastVector(this.width);
            } else {
                this.elemList.setSize(0);
            }
            this.viLevel = new byte[this.width];
            fastVector = this.elemList;
            byArray = this.viLevel;
            n2 = 0;
        } else {
            ++n2;
        }
        if (this.maxOccurs == 0) {
            this.optional = true;
            return false;
        }
        int n4 = fastVector.size();
        this.isClean = true;
        int n5 = this.length();
        this.allElement = true;
        boolean bl = true;
        boolean bl2 = false;
        int n6 = -1;
        for (n3 = 0; n3 < n5; ++n3) {
            XSDNode xSDNode = (XSDNode)this.nodeVector.get(n3);
            if (!xSDNode.buildPathTable(fastVector, byArray, n2)) {
                this.allElement = false;
            }
            if (this.isOptional(n3)) {
                bl2 = true;
            } else {
                bl = false;
            }
            if (this.order != 0 || this.isOptional(n3) || n6 >= 0) continue;
            n6 = fastVector.size();
        }
        if (n6 < 0) {
            n6 = fastVector.size();
        }
        for (n3 = n4; n3 < n6; ++n3) {
            if (byArray[n3] != n2 + 1) continue;
            byArray[n3] = (byte)n2;
        }
        if (this.topGroup) {
            if (this.pathTable != null) {
                this.pathTable.clear();
            } else {
                this.pathTable = new HashMap((int)((double)this.width * 1.5));
            }
            n5 = fastVector.size();
            for (n3 = 0; n3 < n5; ++n3) {
                ((XSDNode)fastVector.elementAt(n3)).buildPaths(this.pathTable, n3);
            }
        }
        if (!this.allElement) {
            if (this.offsets == null || this.offsets.length <= n5) {
                this.offsets = new int[n5];
            }
            n3 = 0;
            n5 = this.length();
            for (int i2 = 0; i2 < n5; ++i2) {
                this.offsets[i2] = n3 += ((XSDNode)this.nodeVector.get(i2)).getWidth();
            }
        }
        this.optional = false;
        this.optional = this.minOccurs == 0 || n5 == 0 ? true : (this.order == 1 ? bl2 : bl);
        return false;
    }

    @Override
    int postProcess(FastVector fastVector, Hashtable hashtable, XMLSchema xMLSchema) throws Exception {
        if (this.topGroup) {
            if (!this.isClean) {
                return this.width;
            }
            hashtable.clear();
        } else if (hashtable.get(this) != null) {
            throw new XSDException(2210, this.getContainerName(), this.domNode);
        }
        hashtable.put(this, this);
        this.isClean = false;
        int n2 = this.length();
        this.width = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = ((XSDNode)this.nodeVector.get(i2)).postProcess(fastVector, hashtable, xMLSchema);
            this.width += n3;
        }
        hashtable.remove(this);
        if (this.maxOccurs == 0) {
            this.width = 0;
        }
        if (this.width == 0) {
            this.minOccurs = 0;
            this.maxOccurs = 0;
        }
        return this.width;
    }

    @Override
    int getWidth() {
        return this.width;
    }

    int getBranch(int n2) {
        if (n2 < 0 || n2 >= this.width) {
            return -1;
        }
        if (this.allElement) {
            return n2;
        }
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            if (n2 >= this.offsets[i2]) continue;
            return i2;
        }
        return -1;
    }

    int getOffset(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (this.allElement) {
            return n2 - 1;
        }
        return this.offsets[n2 - 1];
    }

    int length() {
        return this.nodeVector.size();
    }

    @Override
    void print(int n2) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n2);
        if (this.refLocalname != null) {
            System.out.print(XSDGroup.indent(n2) + "ref = " + this.refNamespace);
            System.out.println(":" + this.refLocalname);
        }
        switch (this.order) {
            case 2: {
                System.out.println(XSDGroup.indent(n2) + "order = " + "all");
                break;
            }
            case 0: {
                System.out.println(XSDGroup.indent(n2) + "order = " + "sequence");
                break;
            }
            case 1: {
                System.out.println(XSDGroup.indent(n2) + "order = " + "choice");
                break;
            }
        }
        System.out.println(XSDGroup.indent(n2) + "minOccurs = " + this.minOccurs);
        System.out.println(XSDGroup.indent(n2) + "maxOccurs = " + this.maxOccurs);
        this.printSTagEnd(n2);
        if (!bl) {
            for (int i2 = 0; i2 < this.vectorSize; ++i2) {
                ((XSDNode)this.nodeVector.get(i2)).print(n2 + 3);
            }
        }
        this.printETag(n2);
    }

    public boolean isSequential() {
        if (this.maxOccurs > 1 || this.order == 2) {
            return false;
        }
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            XSDParticleNode xSDParticleNode = (XSDParticleNode)this.nodeVector.get(i2);
            if (!(xSDParticleNode instanceof XSDGroup ? !((XSDGroup)xSDParticleNode).isSequential() : xSDParticleNode instanceof XSDAny)) continue;
            return false;
        }
        return true;
    }
}

