/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;

public class XSDException
extends Exception {
    private int errId = 0;
    private String[] errParams;
    private int nparam;
    private XMLElement node;
    private XMLError defaultErr = new XMLError();

    XSDException() {
        super("XMLSchema Error");
    }

    XSDException(String string) {
        super(string);
    }

    XSDException(int n2, String string) {
        super("");
        this.errId = n2;
        this.errParams = new String[1];
        this.errParams[0] = string;
        this.nparam = 1;
    }

    XSDException(int n2, String string, XMLElement xMLElement) {
        super("");
        this.errId = n2;
        this.errParams = new String[1];
        this.errParams[0] = string;
        this.nparam = 1;
        this.node = xMLElement;
    }

    XSDException(int n2, String string, String string2) {
        super("");
        this.errId = n2;
        this.errParams = new String[2];
        this.errParams[0] = string;
        this.errParams[1] = string2;
        this.nparam = 2;
    }

    XSDException(int n2, String string, String string2, String string3) {
        super("");
        this.errId = n2;
        this.errParams = new String[3];
        this.errParams[0] = string;
        this.errParams[1] = string2;
        this.errParams[2] = string3;
        this.nparam = 3;
    }

    int getErrorId() {
        return this.errId;
    }

    String getErrorPara1() {
        if (this.nparam < 1) {
            return "";
        }
        return this.errParams[0];
    }

    String getErrorPara2() {
        if (this.nparam < 2) {
            return "";
        }
        return this.errParams[1];
    }

    XMLElement getErrorNode() {
        return this.node;
    }

    @Override
    public String getMessage() {
        if (this.errId == 0) {
            return super.getMessage();
        }
        return this.getMessage(this.defaultErr);
    }

    public String getMessage(XMLError xMLError) {
        if (this.errId == 0) {
            return super.getMessage();
        }
        switch (this.nparam) {
            case 0: {
                return xMLError.getMessage0(this.errId);
            }
            case 1: {
                return xMLError.getMessage1(this.errId, this.errParams[0]);
            }
            case 2: {
                return xMLError.getMessage2(this.errId, this.errParams[0], this.errParams[1]);
            }
            case 3: {
                return xMLError.getMessage3(this.errId, this.errParams[0], this.errParams[1], this.errParams[2]);
            }
            case 4: {
                return xMLError.getMessage4(this.errId, this.errParams[0], this.errParams[1], this.errParams[2], this.errParams[3]);
            }
            case 5: {
                return xMLError.getMessage5(this.errId, this.errParams[0], this.errParams[1], this.errParams[2], this.errParams[3], this.errParams[4]);
            }
        }
        return super.getMessage();
    }
}

