/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Vector;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDPatternImpl;
import oracle.xml.parser.schema.XSDTypeConstants;

public class XSDConstrainingFacet
implements XSDConstantValues,
XSDTypeConstants {
    private final int iFacet;
    private final String name;
    private int intValue;
    private String strValue;
    String lexical;
    private boolean isFixed;
    private XSDDataValue atomValue;
    private Vector<XSDPatternImpl> patterns;
    private Vector<XSDDataValue> enumeration;

    XSDConstrainingFacet(int n2) {
        this.iFacet = n2;
        this.name = XSDTypeConstants.sFacets[n2];
    }

    public void setFixed(boolean bl) {
        this.isFixed = bl;
    }

    boolean isFixed() {
        return this.isFixed;
    }

    public boolean isFixed(boolean bl) {
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public String getLexicalValue() {
        return this.lexical;
    }

    public int getFacetId() {
        return this.iFacet;
    }

    public Vector getLexicalEnumeration() {
        if (this.iFacet != 10 || this.enumeration == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = this.enumeration.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            vector.addElement(this.enumeration.elementAt(i2).getLexicalValue());
        }
        return vector;
    }

    void setValue(String string, int n2) throws Exception {
        this.lexical = string;
        switch (this.iFacet) {
            case 11: {
                if (this.patterns == null) {
                    this.patterns = new Vector();
                }
                this.patterns.addElement(new XSDPatternImpl(string));
                return;
            }
            case 10: {
                if (this.enumeration == null) {
                    this.enumeration = new Vector();
                }
                this.enumeration.addElement(new XSDDataValue(n2, string));
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.atomValue = new XSDDataValue(n2, string);
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.intValue = Integer.parseInt(string);
                if (this.intValue < 0 || this.iFacet == 5 && this.intValue <= 0) {
                    throw new XSDException(24505, string, this.name);
                }
                return;
            }
            case 12: {
                String string2 = string.intern();
                if (string2 != "preserve" && string2 != "replace" && string2 != "collapse") {
                    throw new XSDException(24505, string2, this.name);
                }
                return;
            }
        }
        throw new XSDException(24505, string, this.name);
    }

    void mergePattern(XSDConstrainingFacet xSDConstrainingFacet) throws Exception {
        if (xSDConstrainingFacet.iFacet != 11 || this.iFacet != 11) {
            throw new XSDException(24000, "");
        }
        if (this.patterns == null) {
            this.patterns = new Vector();
        }
        if (xSDConstrainingFacet.patterns == null) {
            return;
        }
        Vector<XSDPatternImpl> vector = xSDConstrainingFacet.patterns;
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.patterns.addElement(vector.elementAt(i2));
        }
    }

    void addEnumeration(XSDDataValue xSDDataValue) throws XSDException {
        if (this.iFacet != 10) {
            throw new XSDException(24000, "");
        }
        if (this.enumeration == null) {
            this.enumeration = new Vector();
        }
        this.enumeration.addElement(xSDDataValue);
    }

    boolean includeEnum(XSDDataValue xSDDataValue) throws XSDException {
        if (this.iFacet != 10 || this.enumeration == null) {
            throw new XSDException(24000, "");
        }
        int n2 = this.enumeration.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (xSDDataValue.compareTo(this.enumeration.elementAt(i2)) != 0) continue;
            return true;
        }
        return false;
    }

    int compareTo(XSDConstrainingFacet xSDConstrainingFacet) throws XSDException {
        switch (this.iFacet) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (xSDConstrainingFacet.atomValue == null || this.atomValue == null) {
                    throw new XSDException(24507, "");
                }
                return this.atomValue.compareTo(xSDConstrainingFacet.atomValue);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.intValue - xSDConstrainingFacet.intValue;
            }
            case 12: {
                if (this.lexical.equals(xSDConstrainingFacet.lexical)) {
                    return 0;
                }
                return 1;
            }
        }
        return 0;
    }

    public void validateFacet(XSDDataValue xSDDataValue) throws XSDException {
        String string = xSDDataValue.getLexicalValue();
        int n2 = xSDDataValue.getBasicType();
        switch (this.iFacet) {
            case 11: {
                if (this.patterns == null) {
                    return;
                }
                int n3 = this.patterns.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    XSDPatternImpl xSDPatternImpl = this.patterns.elementAt(i2);
                    if (xSDPatternImpl.matchPattern(string)) continue;
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 10: {
                if (this.enumeration != null) {
                    int n4 = this.enumeration.size();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        XSDDataValue xSDDataValue2 = this.enumeration.elementAt(i3);
                        if (xSDDataValue2.compareTo(xSDDataValue) != 0) continue;
                        return;
                    }
                }
                throw new XSDException(24502, string, "", this.name);
            }
            case 1: {
                int n5 = xSDDataValue.compareTo(this.atomValue);
                if (n5 < 0 || n5 > 1) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 2: {
                if (xSDDataValue.compareTo(this.atomValue) <= 0) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 3: {
                if (xSDDataValue.compareTo(this.atomValue) > 0) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 4: {
                if (xSDDataValue.compareTo(this.atomValue) >= 0) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 5: {
                if (xSDDataValue.getPrecision() > this.intValue) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 6: {
                if (xSDDataValue.getScale() > this.intValue) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 7: {
                if (n2 == 18 || n2 == 19) {
                    return;
                }
                if (xSDDataValue.getLength() != this.intValue) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 8: {
                if (n2 == 18 || n2 == 19) {
                    return;
                }
                if (xSDDataValue.getLength() > this.intValue) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 9: {
                if (n2 == 18 || n2 == 19) {
                    return;
                }
                if (xSDDataValue.getLength() < this.intValue) {
                    throw new XSDException(24502, string, "", this.name);
                }
                return;
            }
            case 12: {
                return;
            }
        }
    }

    void validateLength(int n2) throws XSDException {
        switch (this.iFacet) {
            case 9: {
                if (n2 < this.intValue) {
                    throw new XSDException(24082, "");
                }
                return;
            }
            case 8: {
                if (n2 > this.intValue) {
                    throw new XSDException(24079, "");
                }
                return;
            }
            case 7: {
                if (n2 != this.intValue) {
                    throw new XSDException(24076, "");
                }
                return;
            }
        }
        throw new XSDException(24507, "");
    }

    void validateLexical(String string) throws XSDException {
        if (this.iFacet == 11) {
            if (this.patterns == null) {
                return;
            }
            int n2 = this.patterns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XSDPatternImpl xSDPatternImpl = this.patterns.elementAt(i2);
                if (xSDPatternImpl.matchPattern(string)) continue;
                throw new XSDException(24502, string, "", this.name);
            }
            return;
        }
        if (this.iFacet == 10) {
            if (this.enumeration != null) {
                int n3 = this.enumeration.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    XSDDataValue xSDDataValue = this.enumeration.elementAt(i3);
                    XSDDataValue xSDDataValue2 = null;
                    try {
                        xSDDataValue2 = new XSDDataValue(xSDDataValue.getBasicType(), string);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (xSDDataValue.compareTo(xSDDataValue2) != 0) continue;
                    return;
                }
            }
        } else if (this.iFacet == 12) {
            int n4 = string.length();
            if (n4 == 0) {
                return;
            }
            if (this.lexical == "replace") {
                for (int i4 = 0; i4 < n4; ++i4) {
                    char c2 = string.charAt(i4);
                    if (c2 != '\n' && c2 != '\t' && c2 != '\r') continue;
                    throw new XSDException(24502, string, "", this.name);
                }
            } else if (this.lexical == "collapse") {
                int n5 = 1;
                for (int i5 = 0; i5 < n4; ++i5) {
                    char c3 = string.charAt(i5);
                    if (c3 == '\n' || c3 == '\t' || c3 == '\r') {
                        throw new XSDException(24502, string, "", this.name);
                    }
                    n5 = c3 == ' ' ? ++n5 : 0;
                    if (n5 <= 1) continue;
                    throw new XSDException(24502, string, "", this.name);
                }
                if (n5 > 0) {
                    throw new XSDException(24502, string, "", this.name);
                }
            }
            return;
        }
        throw new XSDException(24507, "");
    }

    String print() {
        if (this.lexical != null) {
            return this.lexical;
        }
        return "";
    }
}

