/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

public class XSDAttrGroup
extends XSDNode {
    String refNamespace;
    String refLocalname;
    int refState;
    XSDNode[] nodeVector;
    int vectorSize = 0;
    XSDAny wildcard;
    XSDAttrGroup base;
    boolean restriction;
    boolean resolved;

    XSDAttrGroup(int n2) {
        this.nodeType = 6;
        this.nodeVector = new XSDNode[10];
        this.refState = 0;
    }

    @Override
    public String getTargetNS() {
        if (this.refState == 0 && this.refNamespace != null) {
            return this.refNamespace;
        }
        if (this.parent != null) {
            return this.parent.getTargetNS();
        }
        return this.targetNS;
    }

    @Override
    public String getName() {
        if (this.refState == 0 && this.refLocalname != null) {
            return this.refLocalname;
        }
        return this.name;
    }

    void setAttribute(XSDNode xSDNode, int n2) {
        this.nodeVector[n2] = xSDNode;
    }

    void setWildcard(XSDAny xSDAny) {
        this.wildcard = xSDAny;
        if (xSDAny.parent == null) {
            xSDAny.parent = this;
        }
    }

    public XSDAny getWildcard() {
        return this.wildcard;
    }

    XSDAttribute[] copyAttrDefs(XSDAttribute[] xSDAttributeArray) {
        if (xSDAttributeArray.length < this.vectorSize) {
            xSDAttributeArray = new XSDAttribute[this.vectorSize];
        }
        System.arraycopy(this.nodeVector, 0, xSDAttributeArray, 0, this.vectorSize);
        return xSDAttributeArray;
    }

    void addNode(XSDNode xSDNode) {
        this.ensureCapacity(this.vectorSize + 1);
        this.nodeVector[this.vectorSize++] = xSDNode;
        if (xSDNode.parent == null) {
            xSDNode.parent = this;
        }
    }

    XSDNode getNode(String string, String string2) {
        XSDNode xSDNode = null;
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            xSDNode = this.nodeVector[i2];
            if (!xSDNode.getName().equals(string2) || !xSDNode.getTargetNS().equals(string)) continue;
            return xSDNode;
        }
        return null;
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }

    int getVectorSize() {
        return this.vectorSize;
    }

    public Vector getNodeVector() {
        Vector<XSDNode> vector = new Vector<XSDNode>(this.vectorSize);
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            vector.addElement(this.nodeVector[i2]);
        }
        return vector;
    }

    boolean isValidRestriction(XSDAttrGroup xSDAttrGroup) {
        XSDAttribute xSDAttribute;
        int n2;
        int n3 = xSDAttrGroup.length();
        for (n2 = 0; n2 < this.length(); ++n2) {
            XSDAttribute xSDAttribute2 = (XSDAttribute)this.item(n2);
            xSDAttribute = (XSDAttribute)xSDAttrGroup.item(xSDAttribute2);
            if (xSDAttribute != null) {
                if (xSDAttribute.minOccurs > xSDAttribute2.minOccurs) {
                    return false;
                }
                if (!xSDAttribute2.simpleType.isDerivedFrom(xSDAttribute.simpleType, XSDComplexType.BFNONE)) {
                    return false;
                }
                if (xSDAttribute.fixedVal == null || xSDAttribute.fixedVal.equals(xSDAttribute2.fixedVal)) continue;
                return false;
            }
            if (xSDAttrGroup.wildcard != null && xSDAttrGroup.wildcard.isMatched(xSDAttribute2.getTargetNS())) continue;
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            xSDAttribute = (XSDAttribute)xSDAttrGroup.item(n2);
            if (xSDAttribute.minOccurs <= 0 || this.item(xSDAttribute) != null) continue;
            return false;
        }
        return this.wildcard == null || xSDAttrGroup.wildcard != null && xSDAttrGroup.wildcard.isSubSet(this.wildcard);
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDAttrGroup != null && xSDAttrGroup.refState == 0) {
            this.name = xSDAttrGroup.name;
            this.refState = 0;
            this.ensureCapacity(xSDAttrGroup.vectorSize);
            this.vectorSize = xSDAttrGroup.vectorSize;
            System.arraycopy(xSDAttrGroup.nodeVector, 0, this.nodeVector, 0, this.vectorSize);
            this.wildcard = xSDAttrGroup.wildcard;
        }
    }

    void resolveGroup(XMLSchema xMLSchema) throws XSDException {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        XSDNode xSDNode = null;
        Object var3_3 = null;
        if (this.wildcard != null) {
            this.wildcard.resolveTargetNS();
        }
        int n2 = this.vectorSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            xSDNode = this.nodeVector[i2];
            if (xSDNode instanceof XSDAttrGroup) {
                XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xSDNode;
                xSDAttrGroup.resolveGroup(xMLSchema);
                this.nodeVector[i2] = null;
                this.mergeGroup(xSDAttrGroup, true, xMLSchema);
                if (this.wildcard == null && xSDAttrGroup.wildcard != null) {
                    this.wildcard = xSDAttrGroup.wildcard;
                    continue;
                }
                if (xSDAttrGroup.wildcard == null) continue;
                this.wildcard = this.wildcard.intersectWith(xSDAttrGroup.wildcard);
                continue;
            }
            if (!(xSDNode instanceof XSDAttribute)) continue;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                XSDNode xSDNode2 = this.nodeVector[i3];
                if (xSDNode2 == null || xSDNode2.name != xSDNode.name || xSDNode2.getTargetNS() != xSDNode.getTargetNS()) continue;
                xMLSchema.getBuilder().error(xSDNode.domNode, 24509, xSDNode.getName(), false);
            }
        }
        if (this.base != null) {
            this.resolveDerivation(xMLSchema);
        }
        this.compactNodes();
        for (int i4 = 0; i4 < this.vectorSize; ++i4) {
            XSDAttribute xSDAttribute = (XSDAttribute)this.nodeVector[i4];
            XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
            if (xSDSimpleType != null) {
                xSDSimpleType.parseDerivation(xMLSchema);
            }
            xSDAttribute.checkConstraints();
        }
    }

    private void resolveDerivation(XMLSchema xMLSchema) throws XSDException {
        this.base.resolveGroup(xMLSchema);
        this.mergeGroup(this.base, !this.restriction, xMLSchema);
        if (this.base.wildcard != null && !this.restriction) {
            this.wildcard = this.wildcard == null ? this.base.wildcard : this.wildcard.unionWith(this.base.wildcard);
        }
    }

    private void compactNodes() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            if (this.nodeVector[i2] == null || ((XSDAttribute)this.nodeVector[i2]).maxOccurs == 0) continue;
            this.nodeVector[n2++] = this.nodeVector[i2];
        }
        this.vectorSize = n2;
    }

    private XSDNode item(XSDNode xSDNode) {
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            XSDNode xSDNode2 = this.nodeVector[i2];
            if (xSDNode2 == null || xSDNode == null || xSDNode.name != xSDNode2.name || xSDNode.getTargetNS() != xSDNode2.getTargetNS()) continue;
            return xSDNode2;
        }
        return null;
    }

    XSDAttribute getAttributeDeclaration(String string, String string2) {
        XSDAttribute xSDAttribute = null;
        for (int i2 = 0; i2 < this.vectorSize; ++i2) {
            xSDAttribute = (XSDAttribute)this.nodeVector[i2];
            if (!string2.equals(xSDAttribute.name) || !string.equals(xSDAttribute.getTargetNS())) continue;
            return xSDAttribute;
        }
        return null;
    }

    void mergeGroup(XSDAttrGroup xSDAttrGroup, boolean bl, XMLSchema xMLSchema) throws XSDException {
        int n2 = xSDAttrGroup.length();
        this.ensureCapacity(n2 + this.vectorSize);
        for (int i2 = 0; i2 < n2; ++i2) {
            XSDNode xSDNode = xSDAttrGroup.item(i2);
            XSDNode xSDNode2 = this.item(xSDNode);
            if (xSDNode2 == null) {
                this.nodeVector[this.vectorSize++] = xSDNode;
                continue;
            }
            if (!bl || ((XSDAttribute)xSDNode).maxOccurs <= 0 || ((XSDAttribute)xSDNode2).maxOccurs <= 0) continue;
            xMLSchema.getBuilder().error(xSDNode.domNode, 24509, xSDNode.getName(), false);
        }
    }

    XSDNode item(int n2) {
        if (n2 >= 0 && n2 < this.vectorSize) {
            return this.nodeVector[n2];
        }
        return null;
    }

    int length() {
        return this.vectorSize;
    }

    private void ensureCapacity(int n2) {
        int n3;
        for (n3 = this.nodeVector.length; n3 < n2; n3 *= 2) {
        }
        XSDNode[] xSDNodeArray = this.nodeVector;
        this.nodeVector = new XSDNode[n3];
        System.arraycopy(xSDNodeArray, 0, this.nodeVector, 0, this.vectorSize);
    }

    @Override
    void print(int n2) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n2);
        this.printSTagEnd(n2);
        if (!bl) {
            for (int i2 = 0; i2 < this.vectorSize; ++i2) {
                this.nodeVector[i2].print(n2 + 3);
            }
        }
        if (this.wildcard != null) {
            this.wildcard.print(n2 + 3);
        }
        this.printETag(n2);
    }
}

