/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLVariable;

public class VariableTable {
    private static final int SIZE = 10;
    private int classID = -1;
    private int methodID = -1;
    private XSLStylesheet xss;
    private int offset;
    private int argCnt = this.offset = 3;
    private int slots = 0;
    private long[] codeIndex;
    private String[] name;
    private String[] signature;
    private int[] length;
    private int[] slot;
    private int size;

    public VariableTable(int n2, int n3, XSLStylesheet xSLStylesheet) {
        this.init(n2, n3, xSLStylesheet);
    }

    public VariableTable(int n2, int n3, XSLStylesheet xSLStylesheet, int n4) {
        this.init(n2, n3, xSLStylesheet);
        int n5 = this.offset - 3;
        this.codeIndex[n5] = n4;
        this.name[n5] = "$contextPosition";
        this.signature[n5] = "I";
        ++this.slots;
        this.codeIndex[++n5] = n4;
        this.name[n5] = "$contextSize";
        this.signature[n5] = "I";
        ++this.slots;
        this.codeIndex[++n5] = n4;
        this.name[n5] = "$contextNode";
        this.signature[n5] = "L$oracle/xml/xslt/XMLNode;";
        ++this.slots;
        this.codeIndex[3] = n4;
        this.name[3] = "$matchPattern";
        this.signature[3] = "L$oracle/xml/xslt/XMLString;";
        ++this.slots;
    }

    private void init(int n2, int n3, XSLStylesheet xSLStylesheet) {
        this.classID = n2;
        this.methodID = n3;
        this.xss = xSLStylesheet;
        this.codeIndex = new long[10];
        this.name = new String[10];
        this.signature = new String[10];
        this.length = new int[10];
        this.slot = new int[10];
        this.size = 10;
    }

    int getClassID() {
        return this.classID;
    }

    int getMethodID() {
        return this.methodID;
    }

    void setMethodID(int n2) {
        this.methodID = n2;
    }

    public int getArgCnt() {
        return this.argCnt;
    }

    public int getSlots() {
        return this.slots;
    }

    public long[] getCodeIndex() {
        return this.codeIndex;
    }

    public String[] getName() {
        return this.name;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public int[] getLength() {
        return this.length;
    }

    public int[] getSlot() {
        return this.slot;
    }

    void setSignaturesAndArgCnt() {
        LinkedList linkedList = null;
        if (this.xss.getFrameValues() == null || this.xss.getFrameValues().size() <= 0) {
            return;
        }
        linkedList = (LinkedList)this.xss.getFrameValues().getLast();
        if (linkedList != null) {
            int n2 = linkedList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                OXMLSequence oXMLSequence = (OXMLSequence)linkedList.get(i2);
                this.signature[i2 + this.offset] = XSLJDWPUtil.getJNISignature(oXMLSequence);
            }
            if (n2 > 0) {
                Integer n3 = (Integer)this.xss.getFrameParams().getLast();
                int n4 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (this.signature[i3].equals("D")) {
                        n4 += 2;
                        continue;
                    }
                    ++n4;
                }
                this.argCnt += n4;
            }
        }
    }

    public void set(long l2, XSLVariable xSLVariable) {
        if (this.slots == this.size) {
            this.size *= 2;
            long[] lArray = this.codeIndex;
            String[] stringArray = this.name;
            String[] stringArray2 = this.signature;
            int[] nArray = this.length;
            int[] nArray2 = this.slot;
            this.codeIndex = new long[this.size];
            this.name = new String[this.size];
            this.signature = new String[this.size];
            this.length = new int[this.size];
            this.slot = new int[this.size];
            System.arraycopy(lArray, 0, this.codeIndex, 0, this.size / 2);
            System.arraycopy(stringArray, 0, this.name, 0, this.size / 2);
            System.arraycopy(stringArray2, 0, this.signature, 0, this.size / 2);
            System.arraycopy(nArray, 0, this.length, 0, this.size / 2);
            System.arraycopy(nArray2, 0, this.slot, 0, this.size / 2);
        }
        this.codeIndex[this.slots] = l2 + 1L;
        this.name[this.slots] = xSLVariable.getName().getExpandedName();
        this.signature[this.slots] = this.findSigFromXSLExprBase(xSLVariable.getExp());
        this.slot[this.slots] = this.slots;
        ++this.slots;
    }

    private String findSigFromXSLExprBase(XSLExprBase xSLExprBase) {
        String string;
        if (xSLExprBase == null) {
            return "L$oracle/xml/xslt/XMLNode;";
        }
        int n2 = xSLExprBase.getExprType();
        switch (n2) {
            case 4: {
                string = "Z";
                break;
            }
            case 8: 
            case 16: 
            case 32: {
                string = "D";
                break;
            }
            case 2: {
                string = "L$oracle/xml/xslt/XMLString;";
                break;
            }
            case 0x200000: 
            case 0x400000: {
                string = "L$oracle/xml/xslt/XMLNode;";
                break;
            }
            default: {
                string = "L$oracle/xml/xslt/XMLString;";
            }
        }
        return string;
    }

    public void setEndCodeIndex(long l2) {
        int n2 = 0;
        while (n2 < this.slots) {
            this.length[n2] = (int)(l2 - this.codeIndex[n2]);
            int n3 = n2++;
            this.length[n3] = this.length[n3] + 1;
        }
    }

    public void notifyEnd() {
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "VariableTable: " + this.classID + ":" + this.methodID + ":" + this.argCnt + ":" + this.slots);
        for (int i2 = 0; i2 < this.slots; ++i2) {
            XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), this.codeIndex[i2] + ":" + this.name[i2] + ":" + this.signature[i2] + ":" + this.length[i2] + ":" + this.slot[i2]);
        }
        this.xss.getJDWPMethod().makeVariableTable(this);
    }
}

