/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xslt.XSLStylesheet;

public class LineTable {
    private static final int SIZE = 100;
    private int classID = -1;
    private int methodID = -1;
    private XSLStylesheet xss;
    private long start = -1L;
    private long end = -1L;
    private int startLine = -1;
    private int endLine = -1;
    private int lines = 0;
    private int lastVisitedLine = -1;
    private long[] lineCodeIndex;
    private int[] lineNumber;
    private int pos;
    private int size;

    public LineTable(int n2, int n3, XSLStylesheet xSLStylesheet) {
        this.classID = n2;
        this.methodID = n3;
        this.xss = xSLStylesheet;
        this.lineCodeIndex = new long[100];
        this.lineNumber = new int[100];
        this.pos = 0;
        this.size = 100;
    }

    public LineTable(int n2, int n3, int n4, int n5) {
        this.classID = n2;
        this.methodID = n3;
        this.start = n4;
        this.startLine = n4;
        this.end = n5;
        this.endLine = n5;
        this.lines = n5 - n4 + 1;
        this.lineCodeIndex = new long[this.lines];
        this.lineNumber = new int[this.lines];
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n6 = i2 - n4;
            this.lineNumber[n6] = i2;
            this.lineCodeIndex[n6] = i2;
        }
    }

    int getClassID() {
        return this.classID;
    }

    int getMethodID() {
        return this.methodID;
    }

    void setMethodID(int n2) {
        this.methodID = n2;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int getLines() {
        return this.lines;
    }

    public long[] getLineCodeIndex() {
        return this.lineCodeIndex;
    }

    public int[] getLineNumber() {
        return this.lineNumber;
    }

    public void setStart(long l2) {
        this.start = l2;
    }

    public void setEnd(long l2) {
        this.end = l2;
    }

    public void setStartLine(int n2) {
        this.startLine = n2;
    }

    public void setEndLine(int n2) {
        this.endLine = n2;
    }

    public void setCodeIndexLineNumber(long l2, int n2) {
        if (this.pos + 1 == this.size) {
            this.size *= 2;
            long[] lArray = this.lineCodeIndex;
            int[] nArray = this.lineNumber;
            this.lineCodeIndex = new long[this.size];
            this.lineNumber = new int[this.size];
            System.arraycopy(lArray, 0, this.lineCodeIndex, 0, this.size / 2);
            System.arraycopy(nArray, 0, this.lineNumber, 0, this.size / 2);
        }
        this.lineCodeIndex[this.pos] = l2;
        this.lineNumber[this.pos++] = n2;
        this.lastVisitedLine = n2;
    }

    public int getLastVisitedLine() {
        return this.lastVisitedLine;
    }

    public void notifyEnd() {
        this.lines = this.calculateLines();
        this.deleteEmptySpots(this.lineCodeIndex, this.lineNumber);
        XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), "LineTable: " + this.classID + ":" + this.methodID + ":" + this.start + ":" + this.end + ":" + this.lines);
        for (int i2 = 0; i2 < this.lines; ++i2) {
            XSLJDWPUtil.printTrace(this.xss.getXSLDebugProp(), this.lineNumber[i2] + ":" + this.lineCodeIndex[i2]);
        }
        this.xss.getJDWPMethod().makeLineTable(this);
    }

    private int calculateLines() {
        return this.endLine - this.startLine + 1;
    }

    private void deleteEmptySpots(long[] lArray, int[] nArray) {
        if (this.lines == this.pos) {
            return;
        }
        long[] lArray2 = new long[this.pos];
        int[] nArray2 = new int[this.pos];
        System.arraycopy(this.lineCodeIndex, 0, lArray2, 0, this.pos);
        System.arraycopy(this.lineNumber, 0, nArray2, 0, this.pos);
        this.lineCodeIndex = lArray2;
        this.lineNumber = nArray2;
        this.lines = this.pos;
    }
}

