/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import oracle.xml.parser.schema.JXSchema;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JXDocumentBuilder
extends DocumentBuilder {
    private DOMParser domParser = new DOMParser();
    private Connection domConn;
    private String domKind;
    private Schema jxschema;

    JXDocumentBuilder() {
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }

    void setSchema(Schema schema) {
        this.jxschema = schema;
        if (this.jxschema instanceof JXSchema) {
            this.domParser.setXMLSchema(((JXSchema)this.jxschema).getXMLSchema());
        }
    }

    @Override
    public Schema getSchema() {
        return this.jxschema;
    }

    @Override
    public Document parse(InputStream inputStream) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n2 = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        int n2 = inputStream.available();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource is null");
        }
        this.domParser.parse(inputSource);
        XMLDocument xMLDocument = this.domParser.getDocument();
        if (this.jxschema != null && !(this.jxschema instanceof JXSchema)) {
            Validator validator = this.jxschema.newValidator();
            validator.setErrorHandler(this.domParser.getErrorHandler());
            validator.validate(new DOMSource(xMLDocument), null);
        }
        return xMLDocument;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return this.domParser.getValidationMode();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.domParser.setEntityResolver(entityResolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.domParser.setErrorHandler(errorHandler);
    }

    @Override
    public Document newDocument() {
        if ("oracle.xml.parser.XMLDocument.THICK".equals(this.domKind)) {
            return new XMLDocument(this.domConn, null);
        }
        return new XMLDocument();
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        XMLDOMImplementation xMLDOMImplementation = new XMLDOMImplementation();
        if ("oracle.xml.parser.XMLDocument.THICK".equals(this.domKind)) {
            xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.Connection", this.domConn);
            xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.Kind", "oracle.xml.parser.XMLDocument.THICK");
        }
        return xMLDOMImplementation;
    }

    void setConnection(Connection connection) {
        this.domConn = connection;
    }

    void setDOMKind(String string) {
        this.domKind = string;
        if (string == null) {
            this.domKind = "oracle.xml.parser.XMLDocument.THIN";
        }
    }
}

