/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLSAXSerializer;
import oracle.xml.util.XMLUtil;

public class BinXMLUtil {
    private static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final String hexChars = "0123456789ABCDEF";

    public static byte[] convBase64StringToBytes(String string) {
        int n2 = 32;
        int n3 = 32;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 = n2;
            n2 = stringBuffer.charAt(i2);
            if (n3 == 13 && n2 == 10) {
                stringBuffer.deleteCharAt(i2);
                stringBuffer.deleteCharAt(i2 - 1);
                i2 -= 2;
                continue;
            }
            if (n2 == 9) {
                stringBuffer.deleteCharAt(i2);
                --i2;
                continue;
            }
            if (n2 != 32) continue;
            --i2;
        }
        if (string.length() % 4 != 0) {
            return null;
        }
        int n4 = string.length() / 4 * 3;
        if (string.endsWith("==")) {
            n4 -= 2;
        } else if (string.endsWith("=")) {
            --n4;
        }
        byte[] byArray = new byte[n4];
        for (int i3 = string.length() / 4 - 1; i3 >= 0; --i3) {
            int n5 = (base64Chars.indexOf(string.charAt(i3 * 4)) & 0x3F) << 18 | (base64Chars.indexOf(string.charAt(i3 * 4 + 1)) & 0x3F) << 12 | (base64Chars.indexOf(string.charAt(i3 * 4 + 2)) & 0x3F) << 6 | base64Chars.indexOf(string.charAt(i3 * 4 + 3)) & 0x3F;
            byArray[i3 * 3] = (byte)(n5 >> 16 & 0xFF);
            if (string.charAt(i3 * 4 + 2) == '=') continue;
            byArray[i3 * 3 + 1] = (byte)(n5 >> 8 & 0xFF);
            if (string.charAt(i3 * 4 + 3) == '=') continue;
            byArray[i3 * 3 + 2] = (byte)(n5 & 0xFF);
        }
        return byArray;
    }

    public static String convBytesToBase64String(byte[] byArray) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (n2 = 0; n2 < byArray.length - byArray.length % 3; n2 += 3) {
            by = (byte)(byArray[n2] >> 2 & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n2] & 3) << 4) + (byArray[n2 + 1] >> 4 & 0xF));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n2 + 1] & 0xF) << 2) + (byArray[n2 + 2] >> 6 & 3));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(byArray[n2 + 2] & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
        }
        if (byArray.length % 3 != 0) {
            if (byArray.length % 3 == 2) {
                by = (byte)(byArray[n2] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)(((byArray[n2] & 3) << 4) + (byArray[n2 + 1] >> 4 & 0xF));
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n2 + 1] & 0xF) << 2);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("=");
            } else if (byArray.length % 3 == 1) {
                by = (byte)(byArray[n2] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n2] & 3) << 4);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("==");
            }
        }
        return stringBuffer.toString();
    }

    static byte[] convHexStringToBytes(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return byArray;
    }

    static String convBytesToHexString(byte[] byArray) {
        byte by = 0;
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            by = (byte)(byArray[i2] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(hexChars.charAt(by));
            by = (byte)(byArray[i2] & 0xF);
            stringBuffer.append(hexChars.charAt(by));
        }
        return stringBuffer.toString();
    }

    InputStream convertBinXMLStream2InputStream(BinXMLStream binXMLStream) throws BinXMLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSAXSerializer xMLSAXSerializer = new XMLSAXSerializer(byteArrayOutputStream);
        BinXMLDecoder binXMLDecoder = binXMLStream.getDecoder();
        binXMLDecoder.decode(xMLSAXSerializer, xMLSAXSerializer);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public static XMLDocument switchRoot(XSDNode xSDNode, XMLDocument xMLDocument) {
        XMLElement xMLElement = xSDNode.getDomNode();
        XMLDocument xMLDocument2 = xMLElement.getDocument();
        if (xMLDocument2 != null && xMLDocument2 != xMLDocument) {
            return xMLDocument2;
        }
        return xMLDocument;
    }

    public static String[] getTokens(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 3) {
            String[] stringArray = new String[]{string.trim()};
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    public static long hex2dec(String string) {
        return Long.parseLong(string, 16);
    }

    public static boolean isPureWhiteSpace(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (cArray[i2] == ' ' || cArray[i2] == '\n' || cArray[i2] == '\r' || cArray[i2] == '\t') continue;
            return false;
        }
        return true;
    }

    public static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = XMLUtil.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c2 = string3.charAt(0);
                    if (c2 != '/') {
                        string2 = string2.replace(c2, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    protected static boolean canBeInSeqMode(XSDComplexType xSDComplexType) {
        XSDGroup xSDGroup = xSDComplexType.getTypeGroup();
        if (xSDGroup == null) {
            return false;
        }
        return xSDGroup.isSequential();
    }

    static boolean validateCSXEncodingType(int n2, int n3) {
        boolean bl = false;
        switch (n2) {
            case 1: 
            case 6: 
            case 17: 
            case 19: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (n3 != 1) break;
                bl = true;
                break;
            }
            case 2: {
                if (n3 != 1 && n3 != 3) break;
                bl = true;
                break;
            }
            case 18: {
                if (n3 != 1 && n3 != 13) break;
                bl = true;
                break;
            }
            case 3: 
            case 4: {
                if (n3 != 1 && n3 != 6) break;
                bl = true;
                break;
            }
            case 5: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 31: {
                if (n3 != 1 && n3 != 7) break;
                bl = true;
                break;
            }
            case 24: 
            case 27: 
            case 28: 
            case 29: {
                if (n3 != 1 && n3 != 7 && n3 != 4) break;
                bl = true;
                break;
            }
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                if (n3 != 1 && n3 != 7 && n3 != 20) break;
                bl = true;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (n3 != 1 && n3 != 9 && n3 != 8 && n3 != 10 && n3 != 11) break;
                bl = true;
                break;
            }
            case 15: 
            case 16: {
                if (n3 != 1 && n3 != 2) break;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    static int bindXMLTypeToEncodingType(int n2) {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 18: {
                return 13;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 7;
            }
            case 22: {
                return 7;
            }
            case 23: {
                return 7;
            }
            case 25: {
                return 7;
            }
            case 26: {
                return 7;
            }
            case 31: {
                return 7;
            }
            case 6: {
                return 1;
            }
            case 17: {
                return 1;
            }
            case 19: {
                return 1;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 1;
            }
            case 37: {
                return 1;
            }
            case 40: {
                return 1;
            }
            case 46: {
                return 1;
            }
            case 42: {
                return 1;
            }
            case 43: {
                return 1;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 1;
            }
            case 44: {
                return 1;
            }
            case 41: {
                return 1;
            }
            case 45: {
                return 1;
            }
            case 24: {
                return 4;
            }
            case 27: {
                return 4;
            }
            case 28: {
                return 4;
            }
            case 29: {
                return 4;
            }
            case 30: {
                return 5;
            }
            case 32: {
                return 5;
            }
            case 33: {
                return 5;
            }
            case 34: {
                return 5;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 9;
            }
            case 14: {
                return 9;
            }
            case 20: {
                return 9;
            }
            case 21: {
                return 9;
            }
            case 15: {
                return 2;
            }
            case 16: {
                return 2;
            }
        }
        return 1;
    }
}

