/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLToken;
import oracle.xml.binxml.BinXMLTokenList;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.util.XMLError;

class BinXMLTokenManager
implements BinXMLConstants {
    long seqBasedEncTokenId = 1000L;
    boolean schemaAware;
    boolean q4level = false;
    boolean q8level = false;
    HashMap elementIdTokens;
    HashMap attrIdTokens;
    Hashtable namespaceIdTokens;
    HashMap elementNameTokens;
    HashMap elementNSTokens;
    HashMap attrNameTokens;
    HashMap attrNSTokens;
    HashMap namespaceURITokens;
    BinXMLProcessor binXMLProc;
    BinXMLMetadataProvider metaProvider;
    XMLError err;
    static BinXMLNamespaceToken nstoken1 = BinXMLToken.createNamespaceToken(1L, "http://www.w3.org/XML/1998/namespace");
    static BinXMLNamespaceToken nstoken2 = BinXMLToken.createNamespaceToken(2L, "http://www.w3.org/XML/2000/xmlns/");
    static BinXMLNamespaceToken nstoken3 = BinXMLToken.createNamespaceToken(3L, "http://www.w3.org/2001/XMLSchema-instance");
    static BinXMLNamespaceToken nstoken4 = BinXMLToken.createNamespaceToken(4L, "http://www.w3.org/2001/XMLSchema");
    static BinXMLNamespaceToken nstoken5 = BinXMLToken.createNamespaceToken(5L, "http://xmlns.oracle.com/2004/csx");
    static BinXMLNamespaceToken nstoken6 = BinXMLToken.createNamespaceToken(6L, "http://xmlns.oracle.com/xdb");
    static BinXMLNamespaceToken nstoken7 = BinXMLToken.createNamespaceToken(7L, "");
    static BinXMLNamespaceToken nstoken8 = BinXMLToken.createNamespaceToken(8L, "http://www.w3.org/2001/XInclude");
    static BinXMLQNameToken attrtoken0 = BinXMLToken.createQNameToken(16L, 1L, "space", true);
    static BinXMLQNameToken attrtoken1 = BinXMLToken.createQNameToken(17L, 1L, "lang", true);
    static BinXMLQNameToken attrtoken2 = BinXMLToken.createQNameToken(18L, 3L, "type", true);
    static BinXMLQNameToken attrtoken3 = BinXMLToken.createQNameToken(19L, 3L, "nil", true);
    static BinXMLQNameToken attrtoken4 = BinXMLToken.createQNameToken(20L, 3L, "schemaLocation", true);
    static BinXMLQNameToken attrtoken5 = BinXMLToken.createQNameToken(21L, 3L, "noNamespaceSchemaLocation", true);
    static BinXMLQNameToken attrtoken6 = BinXMLToken.createQNameToken(22L, 2L, "xmlns", true);

    BinXMLTokenManager(BinXMLProcessor binXMLProcessor) {
        this.binXMLProc = binXMLProcessor;
        this.initTables();
    }

    void setShemaAware(boolean bl) {
        this.schemaAware = bl;
    }

    private void initTables() {
        this.elementIdTokens = new HashMap(100);
        this.attrIdTokens = new HashMap(100);
        this.namespaceIdTokens = new Hashtable(100);
        this.elementNameTokens = new HashMap(100);
        this.elementNSTokens = new HashMap(100);
        this.attrNameTokens = new HashMap(100);
        this.attrNSTokens = new HashMap(100);
        this.namespaceURITokens = new HashMap(100);
        this.attrIdTokens.put(new Long(16L), attrtoken0);
        this.attrIdTokens.put(new Long(17L), attrtoken1);
        this.attrIdTokens.put(new Long(18L), attrtoken2);
        this.attrIdTokens.put(new Long(19L), attrtoken3);
        this.attrIdTokens.put(new Long(20L), attrtoken4);
        this.attrIdTokens.put(new Long(21L), attrtoken5);
        this.attrIdTokens.put(new Long(22L), attrtoken6);
        this.namespaceIdTokens.put(new Long(1L), nstoken1);
        this.namespaceIdTokens.put(new Long(2L), nstoken2);
        this.namespaceIdTokens.put(new Long(3L), nstoken3);
        this.namespaceIdTokens.put(new Long(4L), nstoken4);
        this.namespaceIdTokens.put(new Long(5L), nstoken5);
        this.namespaceIdTokens.put(new Long(6L), nstoken6);
        this.namespaceIdTokens.put(new Long(7L), nstoken7);
        this.namespaceIdTokens.put(new Long(8L), nstoken8);
        this.attrNameTokens.put(attrtoken0.getLocalName(), new BinXMLTokenList(attrtoken0));
        this.attrNameTokens.put(attrtoken1.getLocalName(), new BinXMLTokenList(attrtoken1));
        this.attrNameTokens.put(attrtoken2.getLocalName(), new BinXMLTokenList(attrtoken2));
        this.attrNameTokens.put(attrtoken3.getLocalName(), new BinXMLTokenList(attrtoken3));
        this.attrNameTokens.put(attrtoken4.getLocalName(), new BinXMLTokenList(attrtoken4));
        this.attrNameTokens.put(attrtoken5.getLocalName(), new BinXMLTokenList(attrtoken5));
        this.attrNameTokens.put(attrtoken6.getLocalName(), new BinXMLTokenList(attrtoken6));
        BinXMLTokenList binXMLTokenList = new BinXMLTokenList();
        binXMLTokenList.add(attrtoken0);
        binXMLTokenList.add(attrtoken1);
        this.attrNSTokens.put(new Long(1L), binXMLTokenList);
        binXMLTokenList = new BinXMLTokenList();
        binXMLTokenList.add(attrtoken2);
        binXMLTokenList.add(attrtoken3);
        binXMLTokenList.add(attrtoken4);
        binXMLTokenList.add(attrtoken5);
        this.attrNSTokens.put(new Long(3L), binXMLTokenList);
        this.attrNSTokens.put(new Long(2L), new BinXMLTokenList(attrtoken6));
        this.namespaceURITokens.put(nstoken1.getLocalName(), nstoken1);
        this.namespaceURITokens.put(nstoken2.getLocalName(), nstoken2);
        this.namespaceURITokens.put(nstoken3.getLocalName(), nstoken3);
        this.namespaceURITokens.put(nstoken4.getLocalName(), nstoken4);
        this.namespaceURITokens.put(nstoken5.getLocalName(), nstoken5);
        this.namespaceURITokens.put(nstoken6.getLocalName(), nstoken6);
        this.namespaceURITokens.put(nstoken7.getLocalName(), nstoken7);
        this.namespaceURITokens.put(nstoken8.getLocalName(), nstoken8);
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
    }

    BinXMLQNameToken putElement(String string, long l2) throws BinXMLException {
        return this.putQName(string, l2, false);
    }

    BinXMLQNameToken putAttr(String string, long l2) throws BinXMLException {
        return this.putQName(string, l2, true);
    }

    private BinXMLQNameToken putQName(String string, long l2, boolean bl) throws BinXMLException {
        Object object;
        long l3 = -1L;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.metaProvider == null || !(this.metaProvider instanceof DBBinXMLMetadataProviderImpl)) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BinXMLException(unsupportedEncodingException);
            }
            byArray2 = new byte[9 + byArray.length];
            BinXMLStreamImpl.writeNum8(l2, byArray2, 0);
            byArray2[8] = bl ? (byte)1 : 0;
            BinXMLStreamImpl.copyByteArray(byArray, 0, byArray.length, byArray2, 9);
            l3 = this.generateTokenId(byArray2);
        } else {
            BinXMLNamespaceToken binXMLNamespaceToken = this.getNamespaceToken(l2);
            object = binXMLNamespaceToken.getLocalName();
            if (object == null) {
                object = "";
            }
            l3 = this.getTokenId((String)object, string, bl);
        }
        int n2 = 0;
        while (true) {
            if ((object = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l3))) == null) {
                object = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l3));
            }
            if (object == null) break;
            if (((BinXMLQNameToken)object).isAttr() == bl && ((BinXMLToken)object).getLocalName().equals(string) && ((BinXMLQNameToken)object).getNamespaceId() == l2) {
                return object;
            }
            if (n2++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l3 = this.regenerateTokenId(l3, byArray2);
                n2 = 0;
                continue;
            }
            l3 = this.regenerateTokenId(l3, null);
        }
        object = this.registerTokenId(l3, string, l2, bl);
        return object;
    }

    private void setQ2Q4Q8Level() {
        if (!this.q4level && !this.q8level) {
            this.q4level = true;
        } else if (this.q4level && !this.q8level) {
            this.q4level = false;
            this.q8level = true;
        }
    }

    private String getNamespaceIDfromXDB(String string) throws BinXMLException {
        BinXMLStream binXMLStream = ((DBBinXMLMetadataProviderImpl)this.metaProvider).getNamespaceIDfromXDBByPLSQL(string);
        if (binXMLStream != null) {
            BinXMLDecoder binXMLDecoder = binXMLStream.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
            if (binXMLNamespaceToken == null) {
                return null;
            }
            long l2 = binXMLNamespaceToken.getTokenId();
            String string2 = Long.toHexString(l2);
            return string2;
        }
        return null;
    }

    BinXMLNamespaceToken putNamespaceSchema(String string) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken;
        byte[] byArray = null;
        long l2 = 0L;
        boolean bl = false;
        if (string == null) {
            return nstoken7;
        }
        if (this.metaProvider == null || !(this.metaProvider instanceof DBBinXMLMetadataProviderImpl)) {
            byArray = string.getBytes();
            l2 = this.generateTokenId(byArray);
        } else {
            String string2 = this.getNamespaceIDfromXDB(string);
            if (string2 == null) {
                throw new BinXMLException(this.err.getMessage1(35012, string));
            }
            l2 = BinXMLUtil.hex2dec(string2);
            bl = true;
        }
        int n2 = 0;
        while ((binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l2))) != null) {
            if (binXMLNamespaceToken.getNamespaceURI().equals(string)) {
                return binXMLNamespaceToken;
            }
            if (n2++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l2 = this.regenerateTokenId(l2, byArray);
                n2 = 0;
            } else {
                l2 = this.regenerateTokenId(l2, null);
            }
            bl = false;
        }
        binXMLNamespaceToken = null;
        binXMLNamespaceToken = !bl ? this.registerNamespace(l2, string) : (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
        return binXMLNamespaceToken;
    }

    BinXMLNamespaceToken putNamespaceNonSchema(String string) throws BinXMLException {
        byte[] byArray = null;
        long l2 = 0L;
        BinXMLNamespaceToken binXMLNamespaceToken = null;
        if (string == null) {
            return nstoken7;
        }
        binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
        if (binXMLNamespaceToken != null) {
            return binXMLNamespaceToken;
        }
        byArray = string.getBytes();
        l2 = this.generateTokenId(byArray);
        binXMLNamespaceToken = this.registerNamespace(l2, string);
        return binXMLNamespaceToken;
    }

    long getTokenId(String string, String string2, boolean bl) throws BinXMLException {
        long l2;
        if (string == null) {
            string = "";
        }
        if ((l2 = this.getTokenFromLocalCache(string, string2, bl)) == 0L) {
            if (this.schemaAware) {
                this.registerTokenSetFromMetadataReposSchema(string, bl);
                l2 = this.getTokenFromLocalCache(string, string2, bl);
                if (l2 == 0L) {
                    l2 = this.generateTokenIdSchema(string, string2, bl);
                }
            } else {
                l2 = this.generateTokenIdNonSchema(string, string2, bl);
            }
        }
        return l2;
    }

    long generateTokenIdNonSchema(String string, String string2, boolean bl) throws BinXMLException {
        return ++this.seqBasedEncTokenId;
    }

    long generateTokenIdSchema(String string, String string2, boolean bl) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken;
        long l2 = this.getNamespaceTokenId(string);
        byte[] byArray = string2.getBytes();
        long l3 = this.generateTokenId(byArray);
        int n2 = 0;
        while (true) {
            if ((binXMLQNameToken = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l3))) == null) {
                binXMLQNameToken = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l3));
            }
            if (binXMLQNameToken == null) break;
            if (binXMLQNameToken.isAttr() == bl && binXMLQNameToken.getLocalName().equals(string2) && binXMLQNameToken.getNamespaceId() == l2) {
                return l3;
            }
            if (n2++ >= 1000) {
                if (this.q8level) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.setQ2Q4Q8Level();
                l3 = this.regenerateTokenId(l3, byArray);
                n2 = 0;
                continue;
            }
            l3 = this.regenerateTokenId(l3, null);
        }
        binXMLQNameToken = this.registerTokenId(l3, string2, l2, bl);
        return binXMLQNameToken.getTokenId();
    }

    private long getTokenFromLocalCache(String string, String string2, boolean bl) throws BinXMLException {
        long l2 = 0L;
        BinXMLTokenList binXMLTokenList = null;
        binXMLTokenList = !bl ? (BinXMLTokenList)this.elementNameTokens.get(string2) : (BinXMLTokenList)this.attrNameTokens.get(string2);
        if (binXMLTokenList != null) {
            BinXMLQNameToken binXMLQNameToken;
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
            long l3 = 0L;
            if (binXMLNamespaceToken != null) {
                l3 = binXMLNamespaceToken.getTokenId();
            }
            if ((binXMLQNameToken = binXMLTokenList.getQNameToken(l3)) != null) {
                l2 = binXMLQNameToken.getTokenId();
            }
        } else {
            long l4 = this.getNamespaceTokenId(string);
            l2 = this.generateTokenId();
            this.registerTokenId(l2, string2, l4, bl);
        }
        return l2;
    }

    private boolean registerTokenSetFromMetadataReposSchema(String string, boolean bl) throws BinXMLException {
        if (this.metaProvider == null) {
            return false;
        }
        BinXMLStreamImpl binXMLStreamImpl = null;
        binXMLStreamImpl = (BinXMLStreamImpl)this.metaProvider.getTokenSet(string, bl);
        if (binXMLStreamImpl != null) {
            BinXMLDecoder binXMLDecoder = binXMLStreamImpl.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            return true;
        }
        return false;
    }

    QName getTokenName(long l2) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken = this.getToken(l2);
        return this.getTokenName(binXMLQNameToken);
    }

    QName getTokenName(BinXMLQNameToken binXMLQNameToken) throws BinXMLException {
        QName qName = null;
        if (binXMLQNameToken != null) {
            BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(binXMLQNameToken.getNamespaceId()));
            qName = new QName(binXMLNamespaceToken.getLocalName(), binXMLQNameToken.getLocalName());
        }
        return qName;
    }

    BinXMLQNameToken getToken(long l2) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken = this.getTokenFromLocalCache(l2);
        if (binXMLQNameToken == null) {
            boolean bl = this.registerTokenSetFromMetadataRepos(l2, false);
            if (!bl) {
                throw new BinXMLException(this.err.getMessage0(35013));
            }
            binXMLQNameToken = this.getTokenFromLocalCache(l2);
            if (binXMLQNameToken == null) {
                throw new BinXMLException(this.err.getMessage0(35013));
            }
        }
        return binXMLQNameToken;
    }

    private BinXMLQNameToken getTokenFromLocalCache(long l2) {
        BinXMLQNameToken binXMLQNameToken = (BinXMLQNameToken)this.elementIdTokens.get(new Long(l2));
        if (binXMLQNameToken == null) {
            binXMLQNameToken = (BinXMLQNameToken)this.attrIdTokens.get(new Long(l2));
        }
        return binXMLQNameToken;
    }

    private boolean registerTokenSetFromMetadataRepos(long l2, boolean bl) throws BinXMLException {
        if (this.metaProvider == null) {
            return false;
        }
        try {
            BinXMLStreamImpl binXMLStreamImpl = (BinXMLStreamImpl)this.metaProvider.getTokenSet(l2, bl);
            BinXMLDecoder binXMLDecoder = binXMLStreamImpl.getDecoder();
            ((BinXMLDecoderImpl)binXMLDecoder).decodeVocabDoc(this);
            return true;
        }
        catch (Exception exception) {
            throw new BinXMLException(exception.getMessage());
        }
    }

    BinXMLNamespaceToken registerNamespace(long l2, String string) {
        BinXMLNamespaceToken binXMLNamespaceToken = BinXMLNamespaceToken.createNamespaceToken(l2, string);
        this.namespaceIdTokens.put(new Long(l2), binXMLNamespaceToken);
        this.namespaceURITokens.put(string, binXMLNamespaceToken);
        return binXMLNamespaceToken;
    }

    BinXMLQNameToken registerTokenId(long l2, String string, long l3, boolean bl) {
        BinXMLQNameToken binXMLQNameToken = BinXMLQNameToken.createQNameToken(l2, l3, string, bl);
        if (bl) {
            this.attrIdTokens.put(new Long(l2), binXMLQNameToken);
            BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
            if (binXMLTokenList == null) {
                this.attrNameTokens.put(string, new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
            binXMLTokenList = (BinXMLTokenList)this.attrNSTokens.get(new Long(l3));
            if (binXMLTokenList == null) {
                this.attrNSTokens.put(new Long(l3), new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
        } else {
            this.elementIdTokens.put(new Long(l2), binXMLQNameToken);
            BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
            if (binXMLTokenList == null) {
                this.elementNameTokens.put(string, new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
            binXMLTokenList = (BinXMLTokenList)this.elementNSTokens.get(new Long(l3));
            if (binXMLTokenList == null) {
                this.elementNSTokens.put(new Long(l3), new BinXMLTokenList(binXMLQNameToken));
            } else {
                binXMLTokenList.add(binXMLQNameToken);
            }
        }
        return binXMLQNameToken;
    }

    BinXMLNamespaceToken getNamespaceToken(long l2) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l2));
        if (binXMLNamespaceToken != null) {
            return binXMLNamespaceToken;
        }
        boolean bl = this.registerTokenSetFromMetadataRepos(l2, true);
        if (!bl) {
            return null;
        }
        binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceIdTokens.get(new Long(l2));
        return binXMLNamespaceToken;
    }

    BinXMLQNameToken getElementToken(String string, long l2, String string2) throws BinXMLException {
        BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
        if (binXMLTokenList == null) {
            return null;
        }
        BinXMLQNameToken binXMLQNameToken = binXMLTokenList.getQNameToken(l2);
        if (binXMLQNameToken == null) {
            boolean bl = false;
            if (this.schemaAware) {
                bl = this.registerTokenSetFromMetadataReposSchema(string2, false);
            }
            if (!bl) {
                return null;
            }
            binXMLTokenList = (BinXMLTokenList)this.elementNameTokens.get(string);
            if (binXMLTokenList == null) {
                return null;
            }
            binXMLQNameToken = binXMLTokenList.getQNameToken(l2);
            if (binXMLQNameToken == null) {
                return null;
            }
        }
        return binXMLQNameToken;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    BinXMLQNameToken getAttrToken(String string, long l2, String string2) throws BinXMLException {
        BinXMLTokenList binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
        if (binXMLTokenList == null) {
            return null;
        }
        BinXMLQNameToken binXMLQNameToken = binXMLTokenList.getQNameToken(l2);
        if (binXMLQNameToken == null) {
            boolean bl = false;
            if (this.schemaAware) {
                bl = this.registerTokenSetFromMetadataReposSchema(string2, true);
            }
            if (!bl) {
                return null;
            }
            binXMLTokenList = (BinXMLTokenList)this.attrNameTokens.get(string);
            if (binXMLTokenList == null) {
                return null;
            }
            binXMLQNameToken = binXMLTokenList.getQNameToken(l2);
            if (binXMLQNameToken == null) {
                return null;
            }
        }
        return binXMLQNameToken;
    }

    long getNamespaceTokenId(String string) throws BinXMLException {
        BinXMLNamespaceToken binXMLNamespaceToken = (BinXMLNamespaceToken)this.namespaceURITokens.get(string);
        if (binXMLNamespaceToken == null) {
            binXMLNamespaceToken = this.schemaAware ? this.putNamespaceSchema(string) : this.putNamespaceNonSchema(string);
        }
        return binXMLNamespaceToken.getTokenId();
    }

    private long generateTokenId() {
        return ++this.seqBasedEncTokenId;
    }

    private long generateTokenId(byte[] byArray) {
        return ++this.seqBasedEncTokenId;
    }

    private long getTokenMask() {
        if (!this.q4level && !this.q8level) {
            return 32767L;
        }
        if (this.q4level) {
            return 0x7FFF7FFFL;
        }
        return -2147516417L;
    }

    private long regenerateTokenId(long l2, byte[] byArray) {
        long l3;
        if (byArray != null) {
            l2 = this.generateTokenId(byArray);
        }
        if ((l2 = l2 + 13L & (l3 = this.getTokenMask())) >= 0L && l2 <= 22L) {
            return this.regenerateTokenId(l2, byArray);
        }
        return l2;
    }
}

