/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.async;

public class ResourceManager {
    private volatile int size;
    private final int initsize;

    public ResourceManager(int n2) {
        this.size = n2;
        this.initsize = n2;
    }

    public synchronized void getResource() {
        if (this.size < 0) {
            throw new RuntimeException();
        }
        while (this.size <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        --this.size;
    }

    public synchronized void releaseResource() {
        if (this.size >= this.initsize) {
            throw new RuntimeException();
        }
        ++this.size;
        this.notifyAll();
    }

    public synchronized boolean activeFound() {
        return this.size < this.initsize;
    }

    public void sleep(int n2) {
        try {
            Thread.sleep(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

