/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.XDBError;
import oracle.xdb.XMLType;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBResource;
import oracle.xdb.spi.XDBResourceContext;

public class XDBNamingEnumeration
implements NamingEnumeration {
    public static final int NAMING_TYPE_NAMECLASS = 1;
    public static final int NAMING_TYPE_NAMEBINDING = 2;
    private long m_enum;
    private Hashtable m_env;
    private int m_type;
    private boolean m_closed;
    private Connection m_conn;
    private int m_conntype;
    private String m_path;

    private native boolean hasMoreKprbNative(long var1);

    private native String nextKprbNative(long var1, long[] var3, String[] var4);

    private native void closeKprbNative(long var1);

    private native boolean hasMoreThickNative(long var1, long var3, long var5);

    private native String nextThickNative(long var1, long var3, long var5, long[] var7, String[] var8);

    private native void closeThickNative(long var1, long var3, long var5);

    XDBNamingEnumeration(Hashtable env, Connection conn, long ienum, String abspath, int type) throws SQLException, OperationNotSupportedException {
        this.m_enum = ienum;
        this.m_closed = false;
        this.m_type = type;
        this.m_conn = conn;
        this.m_conntype = XMLType.getConnType(conn);
        this.m_path = abspath;
        if (this.m_conntype == 0) {
            throw new OperationNotSupportedException(XDBError.getMsg("THIN_NOT_SUPPORTED"));
        }
        this.m_env = env != null ? (Hashtable)env.clone() : null;
    }

    @Override
    public boolean hasMore() throws NamingException {
        boolean isMoreAvailable = false;
        if (!this.m_closed) {
            switch (this.m_conntype) {
                case 2: {
                    isMoreAvailable = this.hasMoreKprbNative(this.m_enum);
                    break;
                }
                case 1: {
                    try {
                        isMoreAvailable = this.hasMoreThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum);
                        break;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            if (!isMoreAvailable) {
                this.close();
            }
        } else {
            isMoreAvailable = false;
        }
        return isMoreAvailable;
    }

    @Override
    public boolean hasMoreElements() {
        boolean retVal = false;
        try {
            retVal = this.hasMore();
        }
        catch (NamingException e2) {
            retVal = false;
        }
        return retVal;
    }

    public Object next() throws NamingException {
        NameClassPair retobj;
        String objname = null;
        boolean isReturnRes = false;
        try {
            if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                isReturnRes = true;
            }
            if (!this.hasMore()) {
                throw new NoSuchElementException();
            }
            long[] cstate = new long[2];
            String[] classname = new String[1];
            cstate[0] = isReturnRes ? 1L : 0L;
            cstate[1] = this.m_type == 1 ? 1L : 0L;
            switch (this.m_conntype) {
                case 2: {
                    objname = this.nextKprbNative(this.m_enum, cstate, classname);
                    break;
                }
                case 1: {
                    objname = this.nextThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum, cstate, classname);
                }
            }
            if (this.m_type == 1) {
                NameClassPair p2;
                retobj = p2 = new NameClassPair(objname, classname[0]);
            } else {
                XDBNode obj = null;
                if (isReturnRes) {
                    obj = new XDBResource(this.m_conn, this.m_path + "/" + objname, cstate[1]);
                } else if (cstate[0] == 1L) {
                    obj = new XDBDocument(this.m_conn, cstate[1]);
                    if (this.m_conntype == 2) {
                        String[] usrName = new String[1];
                        classname[0] = XDBResourceContext.getSchemaNameNative(obj.toCState(), usrName);
                        if (classname[0] != null) {
                            try {
                                XMLTypeBean newobj = (XMLTypeBean)DbmsJava.classForNameAndSchema((String)classname[0], (String)usrName[0].toUpperCase()).newInstance();
                                newobj.setOwner((XDBDocument)obj);
                                newobj.setKidNum(0L);
                                newobj.setXobCstate(((XDBNode)((Object)obj.getDocumentElement())).toCState());
                                obj = newobj;
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    obj = new XDBResourceContext(this.m_env, objname, cstate[1]);
                }
                retobj = new Binding(objname, obj);
            }
        }
        catch (SQLException e2) {
            retobj = null;
        }
        return retobj;
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        try {
            return this.next();
        }
        catch (NamingException e2) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void close() {
        if (!this.m_closed) {
            switch (this.m_conntype) {
                case 2: {
                    this.closeKprbNative(this.m_enum);
                    break;
                }
                case 1: {
                    try {
                        this.closeThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_enum);
                        break;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            this.m_closed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

