/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;

class JStylerObj {
    public static final MPSimple MP_SIMPLE = new MPSimple();
    public static final MPTrue MP_TRUE = new MPTrue();
    public static final MPAgressive MP_AGGRESIVE = new MPAgressive();
    public static final EscapeLT ESCAPE_LT = new EscapeLT();
    public static final Escape4Web ESCAPE4Web = new Escape4Web();

    JStylerObj() {
    }

    public static boolean isSpace(char c2) {
        return c2 == '\r' || c2 == '\n' || c2 == '\t' || c2 == ' ';
    }

    public static boolean isSpecialChar(char c2) {
        return c2 == '\b' || c2 == '\f' || c2 == '\n';
    }

    public static boolean isSpecialOpen(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecialClose(char c2) {
        return c2 == '}' || c2 == ']' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecial(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == '}' || c2 == ']' || c2 == ':' || c2 == '\'' || c2 == '\"';
    }

    public static boolean isUnicode(char c2) {
        return c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff';
    }

    public static boolean isKeyword(String s2) {
        if (s2.length() < 3) {
            return false;
        }
        char c2 = s2.charAt(0);
        if (c2 == 'n') {
            return s2.equals("null");
        }
        if (c2 == 't') {
            return s2.equals("true");
        }
        if (c2 == 'f') {
            return s2.equals("false");
        }
        if (c2 == 'N') {
            return s2.equals("NaN");
        }
        return false;
    }

    private static class MPSimple
    implements MustProtect {
        private MPSimple() {
        }

        @Override
        public boolean mustBeProtect(String s2) {
            if (s2 == null) {
                return false;
            }
            int len = s2.length();
            if (len == 0) {
                return true;
            }
            if (s2.trim() != s2) {
                return true;
            }
            char ch = s2.charAt(0);
            if (ch >= '0' && ch <= '9' || ch == '-') {
                return true;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                ch = s2.charAt(i2);
                if (JStylerObj.isSpace(ch)) {
                    return true;
                }
                if (JStylerObj.isSpecial(ch)) {
                    return true;
                }
                if (JStylerObj.isSpecialChar(ch)) {
                    return true;
                }
                if (!JStylerObj.isUnicode(ch)) continue;
                return true;
            }
            return JStylerObj.isKeyword(s2);
        }
    }

    private static class MPTrue
    implements MustProtect {
        private MPTrue() {
        }

        @Override
        public boolean mustBeProtect(String s2) {
            return true;
        }
    }

    private static class MPAgressive
    implements MustProtect {
        private MPAgressive() {
        }

        @Override
        public boolean mustBeProtect(String s2) {
            if (s2 == null) {
                return false;
            }
            int len = s2.length();
            if (len == 0) {
                return true;
            }
            if (s2.trim() != s2) {
                return true;
            }
            char ch = s2.charAt(0);
            if (JStylerObj.isSpecial(ch) || JStylerObj.isUnicode(ch)) {
                return true;
            }
            for (int i2 = 1; i2 < len; ++i2) {
                ch = s2.charAt(i2);
                if (!JStylerObj.isSpecialClose(ch) && !JStylerObj.isUnicode(ch)) continue;
                return true;
            }
            if (JStylerObj.isKeyword(s2)) {
                return true;
            }
            ch = s2.charAt(0);
            if (ch >= '0' && ch <= '9' || ch == '-') {
                int p2;
                for (p2 = 1; p2 < len && (ch = s2.charAt(p2)) >= '0' && ch <= '9'; ++p2) {
                }
                if (p2 == len) {
                    return true;
                }
                if (ch == '.') {
                    ++p2;
                }
                while (p2 < len && (ch = s2.charAt(p2)) >= '0' && ch <= '9') {
                    ++p2;
                }
                if (p2 == len) {
                    return true;
                }
                if (ch == 'E' || ch == 'e') {
                    if (++p2 == len) {
                        return false;
                    }
                    ch = s2.charAt(p2);
                    if (ch == '+' || ch == '-') {
                        ch = s2.charAt(++p2);
                    }
                }
                if (p2 == len) {
                    return false;
                }
                while (p2 < len && (ch = s2.charAt(p2)) >= '0' && ch <= '9') {
                    ++p2;
                }
                return p2 == len;
            }
            return false;
        }
    }

    private static class EscapeLT
    implements StringProtector {
        private EscapeLT() {
        }

        @Override
        public void escape(String s2, Appendable out) {
            try {
                int len = s2.length();
                block11: for (int i2 = 0; i2 < len; ++i2) {
                    char ch = s2.charAt(i2);
                    switch (ch) {
                        case '\"': {
                            out.append("\\\"");
                            continue block11;
                        }
                        case '\\': {
                            out.append("\\\\");
                            continue block11;
                        }
                        case '\b': {
                            out.append("\\b");
                            continue block11;
                        }
                        case '\f': {
                            out.append("\\f");
                            continue block11;
                        }
                        case '\n': {
                            out.append("\\n");
                            continue block11;
                        }
                        case '\r': {
                            out.append("\\r");
                            continue block11;
                        }
                        case '\t': {
                            out.append("\\t");
                            continue block11;
                        }
                        default: {
                            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                                out.append("\\u");
                                String hex = "0123456789ABCDEF";
                                out.append(hex.charAt(ch >> 12 & 0xF));
                                out.append(hex.charAt(ch >> 8 & 0xF));
                                out.append(hex.charAt(ch >> 4 & 0xF));
                                out.append(hex.charAt(ch >> 0 & 0xF));
                                continue block11;
                            }
                            out.append(ch);
                        }
                    }
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Impossible Exception");
            }
        }
    }

    private static class Escape4Web
    implements StringProtector {
        private Escape4Web() {
        }

        @Override
        public void escape(String s2, Appendable sb) {
            try {
                int len = s2.length();
                block12: for (int i2 = 0; i2 < len; ++i2) {
                    char ch = s2.charAt(i2);
                    switch (ch) {
                        case '\"': {
                            sb.append("\\\"");
                            continue block12;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block12;
                        }
                        case '\b': {
                            sb.append("\\b");
                            continue block12;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block12;
                        }
                        case '\n': {
                            sb.append("\\n");
                            continue block12;
                        }
                        case '\r': {
                            sb.append("\\r");
                            continue block12;
                        }
                        case '\t': {
                            sb.append("\\t");
                            continue block12;
                        }
                        case '/': {
                            sb.append("\\/");
                            continue block12;
                        }
                        default: {
                            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                                sb.append("\\u");
                                String hex = "0123456789ABCDEF";
                                sb.append(hex.charAt(ch >> 12 & 0xF));
                                sb.append(hex.charAt(ch >> 8 & 0xF));
                                sb.append(hex.charAt(ch >> 4 & 0xF));
                                sb.append(hex.charAt(ch >> 0 & 0xF));
                                continue block12;
                            }
                            sb.append(ch);
                        }
                    }
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Impossible Error");
            }
        }
    }

    public static interface StringProtector {
        public void escape(String var1, Appendable var2);
    }

    public static interface MustProtect {
        public boolean mustBeProtect(String var1);
    }
}

