/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.api;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.openid.connect.sdk.federation.entities.CommonFederationClaimsSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONObject;

public class ResolveClaimsSet
extends CommonFederationClaimsSet {
    public static final String TRUST_CHAIN_CLAIM_NAME = "trust_chain";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public ResolveClaimsSet(Issuer iss, Subject sub, Date iat, Date exp, JSONObject metadata) {
        this(new EntityID(iss.getValue()), new EntityID(sub.getValue()), iat, exp, metadata);
    }

    public ResolveClaimsSet(EntityID iss, EntityID sub, Date iat, Date exp, JSONObject metadata) {
        this.setClaim("iss", iss.getValue());
        this.setClaim("sub", sub.getValue());
        if (iat == null) {
            throw new IllegalArgumentException("The iat (issued-at) claim must not be null");
        }
        this.setDateClaim("iat", iat);
        if (exp == null) {
            throw new IllegalArgumentException("The exp (expiration) claim must not be null");
        }
        this.setDateClaim("exp", exp);
        if (metadata == null || metadata.isEmpty()) {
            throw new IllegalArgumentException("The metadata claim must not be null");
        }
        this.setClaim("metadata", metadata);
    }

    public ResolveClaimsSet(JWTClaimsSet jwtClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jwtClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    @Override
    public void validateRequiredClaimsPresence() throws ParseException {
        super.validateRequiredClaimsPresence();
        if (MapUtils.isEmpty(this.getJSONObjectClaim("metadata"))) {
            throw new ParseException("Missing metadata claim");
        }
    }

    public TrustChain getTrustChain() {
        List<String> chainJWTs = this.getStringListClaim(TRUST_CHAIN_CLAIM_NAME);
        if (CollectionUtils.isEmpty(chainJWTs)) {
            return null;
        }
        try {
            return TrustChain.parseSerialized(chainJWTs);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setTrustChain(TrustChain trustChain) {
        if (trustChain != null) {
            this.setClaim(TRUST_CHAIN_CLAIM_NAME, trustChain.toSerializedJWTs());
        } else {
            this.setClaim(TRUST_CHAIN_CLAIM_NAME, null);
        }
    }

    static {
        HashSet<String> claimNames = new HashSet<String>();
        claimNames.add("iss");
        claimNames.add("sub");
        claimNames.add("iat");
        claimNames.add("exp");
        claimNames.add("metadata");
        claimNames.add("trust_marks");
        claimNames.add(TRUST_CHAIN_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(claimNames);
    }
}

