/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.util;

import com.nimbusds.oauth2.sdk.ParseException;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.writer.JsonReader;

public final class JSONUtils {
    public static Object parseJSON(String s2) throws ParseException {
        try {
            return new JSONParser(4736).parse(s2);
        }
        catch (net.minidev.json.parser.ParseException e2) {
            throw new ParseException("Invalid JSON", e2);
        }
        catch (NullPointerException e3) {
            throw new ParseException("The JSON string must not be null", e3);
        }
        catch (Exception e4) {
            throw new ParseException("Unexpected exception: " + e4.getMessage(), e4);
        }
        catch (Error e5) {
            throw new ParseException("Unexpected error: " + e5.getMessage(), e5);
        }
    }

    public static Object parseJSONKeepingOrder(String s2) throws ParseException {
        try {
            return new JSONParser(4736).parse(s2, new JsonReader().DEFAULT_ORDERED);
        }
        catch (net.minidev.json.parser.ParseException e2) {
            throw new ParseException("Invalid JSON", e2);
        }
        catch (NullPointerException e3) {
            throw new ParseException("The JSON string must not be null", e3);
        }
        catch (Exception e4) {
            throw new ParseException("Unexpected exception: " + e4.getMessage(), e4);
        }
        catch (Error e5) {
            throw new ParseException("Unexpected error: " + e5.getMessage(), e5);
        }
    }

    public static <T> T to(Object o2, Class<T> clazz) throws ParseException {
        if (!clazz.isAssignableFrom(o2.getClass())) {
            throw new ParseException("Unexpected type: " + o2.getClass());
        }
        return (T)o2;
    }

    public static boolean toBoolean(Object o2) throws ParseException {
        return JSONUtils.to(o2, Boolean.class);
    }

    public static Number toNumber(Object o2) throws ParseException {
        return JSONUtils.to(o2, Number.class);
    }

    public static String toString(Object o2) throws ParseException {
        return JSONUtils.to(o2, String.class);
    }

    public static List<?> toList(Object o2) throws ParseException {
        return JSONUtils.to(o2, List.class);
    }

    public static List<String> toStringList(Object o2) throws ParseException {
        LinkedList<String> stringList = new LinkedList<String>();
        try {
            for (Object item : JSONUtils.toList(o2)) {
                stringList.add((String)item);
            }
        }
        catch (ClassCastException e2) {
            throw new ParseException("Item not a string");
        }
        return stringList;
    }

    private JSONUtils() {
    }
}

