/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.util;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public final class JSONObjectUtils {
    public static boolean containsKey(JSONObject jsonObject, String key) {
        return jsonObject != null && jsonObject.containsKey(key);
    }

    public static JSONObject parse(String s2) throws ParseException {
        Object o2 = JSONUtils.parseJSON(s2);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new ParseException("The JSON entity is not an object");
    }

    public static LinkedHashMap<String, Object> parseKeepingOrder(String s2) throws ParseException {
        Object o2 = JSONUtils.parseJSONKeepingOrder(s2);
        if (o2 instanceof LinkedHashMap) {
            return (LinkedHashMap)o2;
        }
        throw new ParseException("The JSON entity is not an object");
    }

    @Deprecated
    public static JSONObject parseJSONObject(String s2) throws ParseException {
        return JSONObjectUtils.parse(s2);
    }

    public static <T> T getGeneric(JSONObject o2, String key, Class<T> clazz) throws ParseException {
        if (!o2.containsKey(key)) {
            throw new ParseException("Missing JSON object member with key " + key);
        }
        Object value = o2.get(key);
        if (value == null) {
            throw new ParseException("JSON object member with key " + key + " has null value");
        }
        try {
            return JSONUtils.to(value, clazz);
        }
        catch (ParseException e2) {
            throw new ParseException("Unexpected type of JSON object member with key " + key, e2);
        }
    }

    public static boolean getBoolean(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Boolean.class);
    }

    public static boolean getBoolean(JSONObject o2, String key, boolean def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getBoolean(o2, key);
        }
        return def;
    }

    public static int getInt(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).intValue();
    }

    public static int getInt(JSONObject o2, String key, int def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getInt(o2, key);
        }
        return def;
    }

    public static long getLong(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).longValue();
    }

    public static long getLong(JSONObject o2, String key, long def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getLong(o2, key);
        }
        return def;
    }

    public static float getFloat(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).floatValue();
    }

    public static float getFloat(JSONObject o2, String key, float def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getFloat(o2, key);
        }
        return def;
    }

    public static double getDouble(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).doubleValue();
    }

    public static double getDouble(JSONObject o2, String key, double def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getDouble(o2, key);
        }
        return def;
    }

    public static Number getNumber(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class);
    }

    public static Number getNumber(JSONObject o2, String key, Number def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getNumber(o2, key);
        }
        return def;
    }

    public static String getString(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, String.class);
    }

    public static String getString(JSONObject o2, String key, String def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getString(o2, key);
        }
        return def;
    }

    public static String getNonBlankString(JSONObject o2, String key) throws ParseException {
        String value = JSONObjectUtils.getString(o2, key);
        if (StringUtils.isBlank(value)) {
            throw new ParseException("Empty or blank JSON object member with key " + key);
        }
        return value;
    }

    public static <T extends Enum<T>> T getEnum(JSONObject o2, String key, Class<T> enumClass) throws ParseException {
        String value = JSONObjectUtils.getString(o2, key);
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            if (!en.toString().equalsIgnoreCase(value)) continue;
            return (T)en;
        }
        throw new ParseException("Unexpected value of JSON object member with key " + key + "");
    }

    public static <T extends Enum<T>> T getEnum(JSONObject o2, String key, Class<T> enumClass, T def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getEnum(o2, key, enumClass);
        }
        return def;
    }

    public static URI getURI(JSONObject o2, String key) throws ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(o2, key, String.class));
        }
        catch (URISyntaxException e2) {
            throw new ParseException(e2.getMessage(), e2);
        }
    }

    public static URI getURI(JSONObject o2, String key, URI def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getURI(o2, key);
        }
        return def;
    }

    public static URL getURL(JSONObject o2, String key) throws ParseException {
        try {
            return new URL(JSONObjectUtils.getGeneric(o2, key, String.class));
        }
        catch (MalformedURLException e2) {
            throw new ParseException(e2.getMessage(), e2);
        }
    }

    public static URL getURL(JSONObject o2, String key, URL def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getURL(o2, key);
        }
        return def;
    }

    public static JSONArray getJSONArray(JSONObject o2, String key) throws ParseException {
        List list = JSONObjectUtils.getGeneric(o2, key, List.class);
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(list);
        return jsonArray;
    }

    public static JSONArray getJSONArray(JSONObject o2, String key, JSONArray def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getJSONArray(o2, key);
        }
        return def;
    }

    public static List<Object> getList(JSONObject o2, String key) throws ParseException {
        return JSONObjectUtils.getGeneric(o2, key, List.class);
    }

    public static List<Object> getList(JSONObject o2, String key, List<Object> def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getList(o2, key);
        }
        return def;
    }

    public static String[] getStringArray(JSONObject o2, String key) throws ParseException {
        List<Object> list = JSONObjectUtils.getList(o2, key);
        try {
            return list.toArray(new String[0]);
        }
        catch (ArrayStoreException e2) {
            throw new ParseException("JSON object member with key " + key + " is not an array of strings");
        }
    }

    public static String[] getStringArray(JSONObject o2, String key, String[] def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getStringArray(o2, key);
        }
        return def;
    }

    public static List<String> getStringList(JSONObject o2, String key) throws ParseException {
        return Arrays.asList(JSONObjectUtils.getStringArray(o2, key));
    }

    public static List<String> getStringList(JSONObject o2, String key, List<String> def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getStringList(o2, key);
        }
        return def;
    }

    public static Set<String> getStringSet(JSONObject o2, String key) throws ParseException {
        List<Object> list = JSONObjectUtils.getList(o2, key);
        HashSet<String> set = new HashSet<String>();
        for (Object item : list) {
            try {
                set.add((String)item);
            }
            catch (Exception e2) {
                throw new ParseException("JSON object member with key " + key + " is not an array of strings");
            }
        }
        return set;
    }

    public static Set<String> getStringSet(JSONObject o2, String key, Set<String> def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getStringSet(o2, key);
        }
        return def;
    }

    public static JSONObject getJSONObject(JSONObject o2, String key) throws ParseException {
        Map mapObject = JSONObjectUtils.getGeneric(o2, key, Map.class);
        return new JSONObject(mapObject);
    }

    public static JSONObject getJSONObject(JSONObject o2, String key, JSONObject def) throws ParseException {
        if (o2.get(key) != null) {
            return JSONObjectUtils.getJSONObject(o2, key);
        }
        return def;
    }

    public static JSONObject toJSONObject(JWTClaimsSet jwtClaimsSet) {
        if (jwtClaimsSet == null) {
            return null;
        }
        if (jwtClaimsSet.getClaims().isEmpty()) {
            return new JSONObject();
        }
        String json = jwtClaimsSet.toString();
        try {
            return JSONObjectUtils.parse(json);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public static JSONObject toJSONObject(JWKSet jwkSet) {
        if (jwkSet == null) {
            return null;
        }
        String json = jwkSet.toString(false);
        try {
            return JSONObjectUtils.parse(json);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    private JSONObjectUtils() {
    }
}

