/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.device;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class DeviceAuthorizationRequest
extends AbstractOptionallyIdentifiedRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Scope scope;
    private final Map<String, List<String>> customParams;

    public DeviceAuthorizationRequest(URI endpoint, ClientID clientID) {
        this(endpoint, clientID, null, null);
    }

    public DeviceAuthorizationRequest(URI endpoint, ClientID clientID, Scope scope) {
        this(endpoint, clientID, scope, null);
    }

    public DeviceAuthorizationRequest(URI endpoint, ClientID clientID, Scope scope, Map<String, List<String>> customParams) {
        super(endpoint, Objects.requireNonNull(clientID));
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(customParams) ? Collections.unmodifiableMap(customParams) : Collections.emptyMap();
    }

    public DeviceAuthorizationRequest(URI uri, ClientAuthentication clientAuth, Scope scope, Map<String, List<String>> customParams) {
        super(uri, Objects.requireNonNull(clientAuth));
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(customParams) ? Collections.unmodifiableMap(customParams) : Collections.emptyMap();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    public List<String> getCustomParameter(String name) {
        return this.customParams.get(name);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> params;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        httpRequest.setAccept(ContentType.APPLICATION_JSON.getType());
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        try {
            params = new LinkedHashMap<String, List<String>>(httpRequest.getBodyAsFormParameters());
        }
        catch (ParseException e2) {
            throw new SerializeException(e2.getMessage(), e2);
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            params.put("scope", Collections.singletonList(this.scope.toString()));
        }
        if (this.getClientID() != null) {
            params.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (!this.getCustomParameters().isEmpty()) {
            params.putAll(this.getCustomParameters());
        }
        httpRequest.setBody(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static DeviceAuthorizationRequest parse(HTTPRequest httpRequest) throws ParseException {
        ClientID clientID;
        String v2;
        ClientAuthentication clientAuth;
        URI uri = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuth = ClientAuthentication.parse(httpRequest);
        }
        catch (ParseException e2) {
            throw new ParseException(e2.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + e2.getMessage()));
        }
        Map params = httpRequest.getBodyAsFormParameters();
        if (clientAuth == null) {
            v2 = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
            if (StringUtils.isBlank(v2)) {
                String msg = "Missing client_id parameter";
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
            clientID = new ClientID(v2);
        } else {
            clientID = null;
        }
        v2 = (String)MultivaluedMapUtils.getFirstValue(params, "scope");
        Scope scope = null;
        if (StringUtils.isNotBlank(v2)) {
            scope = Scope.parse(v2);
        }
        HashMap customParams = null;
        for (Map.Entry p2 : params.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(p2.getKey())) continue;
            if (customParams == null) {
                customParams = new HashMap();
            }
            customParams.put(p2.getKey(), p2.getValue());
        }
        if (clientAuth == null) {
            return new DeviceAuthorizationRequest(uri, clientID, scope, customParams);
        }
        return new DeviceAuthorizationRequest(uri, clientAuth, scope, customParams);
    }

    static {
        HashSet<String> p2 = new HashSet<String>();
        p2.add("client_id");
        p2.add("scope");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p2);
    }

    public static class Builder {
        private URI endpoint;
        private final ClientAuthentication clientAuth;
        private final ClientID clientID;
        private Scope scope;
        private final Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        public Builder(ClientID clientID) {
            this.clientID = Objects.requireNonNull(clientID);
            this.clientAuth = null;
        }

        public Builder(ClientAuthentication clientAuth) {
            this.clientID = null;
            this.clientAuth = Objects.requireNonNull(clientAuth);
        }

        public Builder(DeviceAuthorizationRequest request) {
            this.endpoint = request.getEndpointURI();
            this.clientAuth = request.getClientAuthentication();
            this.scope = request.scope;
            this.clientID = request.getClientID();
            this.customParams.putAll(request.getCustomParameters());
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder customParameter(String name, String ... values) {
            if (values == null || values.length == 0) {
                this.customParams.remove(name);
            } else {
                this.customParams.put(name, Arrays.asList(values));
            }
            return this;
        }

        public Builder endpointURI(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public DeviceAuthorizationRequest build() {
            try {
                if (this.clientAuth == null) {
                    return new DeviceAuthorizationRequest(this.endpoint, this.clientID, this.scope, this.customParams);
                }
                return new DeviceAuthorizationRequest(this.endpoint, this.clientAuth, this.scope, this.customParams);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
        }
    }
}

