/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.PushedAuthorizationResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class PushedAuthorizationSuccessResponse
extends PushedAuthorizationResponse {
    private final URI requestURI;
    private final long lifetime;

    public PushedAuthorizationSuccessResponse(URI requestURI, long lifetime) {
        this.requestURI = Objects.requireNonNull(requestURI);
        if (lifetime <= 0L) {
            throw new IllegalArgumentException("The request lifetime must be a positive integer");
        }
        this.lifetime = lifetime;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public JSONObject toJSONObject() {
        JSONObject o2 = new JSONObject();
        o2.put("request_uri", this.getRequestURI().toString());
        o2.put("expires_in", this.getLifetime());
        return o2;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(201);
        httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        httpResponse.setBody(this.toJSONObject().toString());
        return httpResponse;
    }

    public static PushedAuthorizationSuccessResponse parse(JSONObject jsonObject) throws ParseException {
        URI requestURI = JSONObjectUtils.getURI(jsonObject, "request_uri");
        long lifetime = JSONObjectUtils.getLong(jsonObject, "expires_in");
        return new PushedAuthorizationSuccessResponse(requestURI, lifetime);
    }

    public static PushedAuthorizationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(201, 200);
        JSONObject jsonObject = httpResponse.getBodyAsJSONObject();
        return PushedAuthorizationSuccessResponse.parse(jsonObject);
    }
}

