/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.impl.CipherHelper;
import com.nimbusds.jose.shaded.jcip.ThreadSafe;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

@ThreadSafe
public class RSA_OAEP {
    private static final String RSA_OEAP_JCA_ALG = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";

    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance(RSA_OEAP_JCA_ALG, provider);
            cipher.init(3, (Key)pub, new SecureRandom());
            return cipher.wrap(cek);
        }
        catch (InvalidKeyException e2) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", e2);
        }
        catch (Exception e3) {
            throw new JOSEException(e3.getMessage(), e3);
        }
    }

    public static SecretKey decryptCEK(PrivateKey priv, byte[] encryptedCEK, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance(RSA_OEAP_JCA_ALG, provider);
            cipher.init(4, priv);
            return (SecretKey)cipher.unwrap(encryptedCEK, "AES", 3);
        }
        catch (Exception e2) {
            throw new JOSEException(e2.getMessage(), e2);
        }
    }

    private RSA_OAEP() {
    }
}

