/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.HttpHelper;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;

class HttpHelperManagedIdentity
extends HttpHelper {
    static final int RETRY_NUM = 3;
    static final int RETRY_DELAY_MS = 1000;

    HttpHelperManagedIdentity(IHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    boolean isRetryable(IHttpResponse httpResponse) {
        switch (httpResponse.statusCode()) {
            case 404: 
            case 408: 
            case 429: 
            case 500: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    @Override
    IHttpResponse executeHttpRequestWithRetries(HttpRequest httpRequest, IHttpClient httpClient) throws Exception {
        IHttpResponse httpResponse = null;
        for (int i2 = 0; i2 <= 3 && this.isRetryable(httpResponse = httpClient.send(httpRequest)); ++i2) {
            Thread.sleep(1000L);
        }
        return httpResponse;
    }
}

