/*
 * Decompiled with CFR 0.152.
 */
package com.dbclient.jdbc.server.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class JSON {
    private static final ObjectMapper mapper;
    private static final ObjectMapper withEmptyMapper;
    private static final SimpleModule dateModule;

    private JSON() {
    }

    private static void buldCommonMapper(ObjectMapper mapper) {
        mapper.registerModule(dateModule);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static String toJSON(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        if (originalObject instanceof String) {
            return String.valueOf(originalObject);
        }
        String json = null;
        try {
            json = mapper.writeValueAsString(originalObject);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return json;
    }

    public static byte[] toJsonByte(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        byte[] json = null;
        try {
            json = mapper.writeValueAsBytes(originalObject);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return json;
    }

    public static String toJsonWithEmpty(Object originalObject) {
        if (originalObject == null) {
            return null;
        }
        String json = null;
        try {
            json = withEmptyMapper.writeValueAsString(originalObject);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return json;
    }

    public static <T> T convert(Object origin, Class<T> targetClass) {
        return mapper.convertValue(origin, targetClass);
    }

    public static <O extends Collection<?>, T> List<T> convertList(O originList, Class<T> targetClass) {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(originList.getClass(), targetClass);
        return (List)mapper.convertValue(originList, javaType);
    }

    public static String get(String json, String key) {
        String value;
        if (json == null || "".equals(json)) {
            return null;
        }
        try {
            value = mapper.readValue(json, JsonNode.class).get(key).textValue();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            value = null;
        }
        return value;
    }

    public static <T> List<T> parseList(String json, Class<T> valueType) {
        return (List)JSON.parseCollection(json, List.class, valueType);
    }

    public static <T, E extends Collection> Collection<T> parseCollection(String json, Class<E> collectionClass, Class<T> valueType) {
        Collection objectList;
        if (json == null || "".equals(json) || valueType == null) {
            return null;
        }
        JavaType javaType = mapper.getTypeFactory().constructParametricType(collectionClass, valueType);
        try {
            objectList = (Collection)mapper.readValue(json, javaType);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            objectList = null;
        }
        return objectList;
    }

    public static <T> T parse(Object obj, Class<T> type) {
        T result;
        if (obj == null || "".equals(obj) || type == null) {
            return null;
        }
        if (type == String.class) {
            return (T)obj;
        }
        try {
            result = mapper.readValue(JSON.toJSON(obj), type);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            result = null;
        }
        return result;
    }

    public static SimpleModule getDateModule() {
        return dateModule;
    }

    static {
        dateModule = new SimpleModule();
        mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JSON.buldCommonMapper(mapper);
        withEmptyMapper = new ObjectMapper();
        withEmptyMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        JSON.buldCommonMapper(withEmptyMapper);
    }
}

