/*
 * Decompiled with CFR 0.152.
 */
package com.dbclient.jdbc.server.driver;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryUtils {
    private static final Logger log = LoggerFactory.getLogger(LibraryUtils.class);

    public static Path getLibraryPath(String libraryName) {
        String javaLibraryPath = LibraryUtils.getJavaLibraryPath();
        File libraryDir = new File(javaLibraryPath);
        if (!libraryDir.exists()) {
            libraryDir.mkdirs();
        }
        return Paths.get(javaLibraryPath, libraryName);
    }

    public static String getJavaLibraryPath() {
        String libraryPath = System.getProperty("java.library.path");
        return libraryPath.split(LibraryUtils.isWindows() ? ";" : ":")[0];
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isLibraryFile(String fileName) {
        return fileName.endsWith(".dll") && LibraryUtils.isWindows();
    }
}

