/*
 * Decompiled with CFR 0.152.
 */
package com.dbclient.jdbc.server.driver;

import com.dbclient.jdbc.server.driver.DriverShim;
import com.dbclient.jdbc.server.driver.LibraryUtils;
import com.dbclient.jdbc.server.dto.ConnectDTO;
import com.dbclient.jdbc.server.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverLoader {
    private static final Logger log = LoggerFactory.getLogger(DriverLoader.class);
    private static final Map<String, Boolean> loaderMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> driverMap = new HashMap<String, Boolean>();

    public static void loadDriverByDTO(ConnectDTO connectDTO) {
        String path = connectDTO.getDriverPath();
        String driver = connectDTO.getDriver();
        if (StringUtils.isNotEmpty(path)) {
            loaderMap.computeIfAbsent(path, k2 -> {
                DriverLoader.loadDriver(connectDTO.getDriverPath(), driver);
                return true;
            });
        }
        try {
            if (StringUtils.isNotEmpty(driver)) {
                Class.forName(driver);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
        }
    }

    private static void loadDriver(String driverPath, String driverClassName) {
        File driverFile = new File(driverPath);
        if (!driverFile.exists()) {
            throw new RuntimeException("Driver path " + driverPath + " not exists!");
        }
        URLClassLoader driverLoader = DriverLoader.getUrlClassLoader(driverFile, driverPath);
        ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class, driverLoader);
        for (Driver driver : serviceLoader) {
            String name = driver.getClass().getName();
            if (driverMap.containsKey(name)) continue;
            DriverManager.registerDriver(new DriverShim(driver));
            driverMap.put(name, Boolean.TRUE);
        }
        if (StringUtils.isNotEmpty(driverClassName) && !driverMap.containsKey(driverClassName)) {
            Driver customDriver = (Driver)Class.forName(driverClassName, true, driverLoader).newInstance();
            DriverManager.registerDriver(new DriverShim(customDriver));
            driverMap.put(driverClassName, Boolean.TRUE);
        }
    }

    private static URLClassLoader getUrlClassLoader(File driverFile, String driverPath) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (driverPath.endsWith(".jar")) {
            urls.add(driverFile.toURI().toURL());
        } else if (driverFile.isDirectory()) {
            DriverLoader.addJarFilesRecursively(driverFile, urls);
        } else {
            try {
                String fileName = FilenameUtils.getBaseName(driverFile.getName());
                File tempDir = new File(System.getProperty("user.home"), ".dbclient/drivers/decompress/" + fileName);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                DriverLoader.decompressArchive(driverFile, tempDir);
                DriverLoader.addJarFilesRecursively(tempDir, urls);
            }
            catch (IOException e2) {
                log.error(e2.getMessage(), e2);
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), e3);
                throw e3;
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    private static void decompressArchive(File archiveFile, File destDir) {
        Object entry;
        InputStream fi = Files.newInputStream(archiveFile.toPath(), new OpenOption[0]);
        BufferedInputStream bi = new BufferedInputStream(fi);
        Object i2 = new ArchiveStreamFactory().createArchiveInputStream(bi);
        while ((entry = ((ArchiveInputStream)i2).getNextEntry()) != null) {
            File f2 = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                if (f2.exists()) continue;
                f2.mkdirs();
                continue;
            }
            if (DriverLoader.isValidJar(f2.getName()) || LibraryUtils.isLibraryFile(f2.getName())) {
                IOUtils.copy(i2, Files.newOutputStream(Paths.get(destDir.getAbsolutePath(), f2.getName()), new OpenOption[0]));
                continue;
            }
            IOUtils.copy(i2, Files.newOutputStream(f2.toPath(), new OpenOption[0]));
        }
    }

    private static void addJarFilesRecursively(File directory, List<URL> urls) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DriverLoader.addJarFilesRecursively(file, urls);
                    continue;
                }
                if (DriverLoader.isValidJar(file.getName())) {
                    urls.add(file.toURI().toURL());
                    continue;
                }
                if (!LibraryUtils.isLibraryFile(file.getName())) continue;
                Path targetPath = LibraryUtils.getLibraryPath(file.getName());
                try {
                    Files.copy(file.toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e2) {
                    log.error(e2.getMessage(), e2);
                }
            }
        }
    }

    private static boolean isValidJar(String fileName) {
        return fileName.endsWith(".jar") && !fileName.matches(".*(sources|javadoc).*");
    }
}

