/*
 * Decompiled with CFR 0.152.
 */
package com.dbclient.jdbc.server;

import com.dbclient.jdbc.server.JdbcExecutor;
import com.dbclient.jdbc.server.driver.LibraryUtils;
import com.dbclient.jdbc.server.dto.ConnectDTO;
import com.dbclient.jdbc.server.dto.execute.ExecuteDTO;
import com.dbclient.jdbc.server.response.AliveCheckResponse;
import com.dbclient.jdbc.server.response.ConnectResponse;
import com.dbclient.jdbc.server.response.ExecuteResponse;
import com.dbclient.jdbc.server.translator.DB2ErrorTranslator;
import com.dbclient.jdbc.server.util.JSON;
import com.dbclient.jdbc.server.util.ServerUtil;
import com.dbclient.jdbc.server.util.StringUtils;
import com.sun.net.httpserver.HttpServer;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcExecutorServer {
    private static final Logger log = LoggerFactory.getLogger(JdbcExecutorServer.class);
    public static final Map<String, JdbcExecutor> executorMap = new HashMap<String, JdbcExecutor>();
    private static final DB2ErrorTranslator translator = new DB2ErrorTranslator();

    public static void main(String[] args) {
        long start = new Date().getTime();
        HttpServer server = HttpServer.create(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 7823), 0);
        server.createContext("/test", exchange -> ServerUtil.writeJSONResponse(exchange, "hello"));
        server.createContext("/connect", exchange -> {
            String fullErrorMessage;
            String errorMessage;
            block6: {
                ConnectDTO connectDTO = ServerUtil.read(exchange, ConnectDTO.class);
                log.info("connect, params: {}", (Object)JSON.toJSON(connectDTO));
                errorMessage = null;
                fullErrorMessage = null;
                try {
                    String id = connectDTO.getId();
                    log.info("Create connection for " + id);
                    JdbcExecutor jdbcExecutor = executorMap.get(id);
                    if (jdbcExecutor != null) break block6;
                    jdbcExecutor = new JdbcExecutor(connectDTO);
                    jdbcExecutor.testAlive();
                    executorMap.put(id, jdbcExecutor);
                }
                catch (Exception e2) {
                    try {
                        log.error(e2.getMessage(), e2);
                        String errMsg = e2.getMessage();
                        if (StringUtils.isNotEmpty(errMsg)) {
                            fullErrorMessage = e2.getClass().getName() + ": " + e2.getMessage();
                            errorMessage = e2.getClass().getSimpleName() + ": " + e2.getMessage();
                        } else {
                            fullErrorMessage = errorMessage = e2.getClass().getName();
                        }
                        e2.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        ServerUtil.writeJSONResponse(exchange, ConnectResponse.builder().success(errorMessage == null).err(errorMessage).fullErr(fullErrorMessage).build());
                        throw throwable;
                    }
                    ServerUtil.writeJSONResponse(exchange, ConnectResponse.builder().success(errorMessage == null).err(errorMessage).fullErr(fullErrorMessage).build());
                }
            }
            ServerUtil.writeJSONResponse(exchange, ConnectResponse.builder().success(errorMessage == null).err(errorMessage).fullErr(fullErrorMessage).build());
        });
        server.createContext("/execute", exchange -> {
            ExecuteResponse executeResponse;
            block7: {
                ExecuteDTO executeDTO = ServerUtil.read(exchange, ExecuteDTO.class);
                String id = executeDTO.getId();
                log.info("Execute SQL for {}, SQL: {}", (Object)id, (Object)executeDTO.getSql());
                JdbcExecutor jdbcExecutor = executorMap.get(id);
                executeResponse = null;
                if (jdbcExecutor == null) {
                    ServerUtil.writeJSONResponse(exchange, ExecuteResponse.builder().err("Connection " + id + " not found!").build());
                    return;
                }
                try {
                    String[] sqlList = executeDTO.getSqlList();
                    if (sqlList != null) {
                        ServerUtil.writeJSONResponse(exchange, jdbcExecutor.executeBatch(sqlList, executeDTO));
                        break block7;
                    }
                    executeResponse = jdbcExecutor.execute(executeDTO.getSql(), executeDTO);
                }
                catch (Error | Exception e2) {
                    try {
                        String errorMessage = e2 instanceof Error ? e2.toString() : e2.getMessage();
                        errorMessage = translator.doTranslate(errorMessage);
                        if (StringUtils.isEmpty(errorMessage)) {
                            errorMessage = e2.getClass().getName();
                        }
                        executeResponse = ExecuteResponse.builder().err(errorMessage).build();
                        log.error(e2.getMessage(), e2);
                    }
                    catch (Throwable throwable) {
                        ServerUtil.writeJSONResponse(exchange, executeResponse);
                        throw throwable;
                    }
                    ServerUtil.writeJSONResponse(exchange, executeResponse);
                }
            }
            ServerUtil.writeJSONResponse(exchange, executeResponse);
        });
        server.createContext("/close", exchange -> {
            ConnectDTO connectDTO = ServerUtil.read(exchange, ConnectDTO.class);
            String id = connectDTO.getId();
            log.info("Close connection for " + id);
            JdbcExecutor jdbcExecutor = executorMap.get(id);
            try {
                if (jdbcExecutor != null) {
                    jdbcExecutor.close();
                }
            }
            catch (Exception ignored) {
                log.error("Close connection fail", ignored);
            }
            finally {
                executorMap.remove(connectDTO.getJdbcUrl());
                ServerUtil.writeJSONResponse(exchange, "");
            }
        });
        server.createContext("/cancel", exchange -> {
            ConnectDTO connectDTO = ServerUtil.read(exchange, ConnectDTO.class);
            String id = connectDTO.getId();
            log.info("Cancel execute for " + id);
            JdbcExecutor jdbcExecutor = executorMap.get(id);
            if (jdbcExecutor != null) {
                jdbcExecutor.cancel();
            }
        });
        server.createContext("/alive", exchange -> {
            AliveCheckResponse aliveCheckResponse;
            block5: {
                ConnectDTO connectDTO = ServerUtil.read(exchange, ConnectDTO.class);
                String id = connectDTO.getId();
                log.info("Check connection {} alive..", (Object)id);
                JdbcExecutor jdbcExecutor = executorMap.get(id);
                aliveCheckResponse = null;
                try {
                    boolean alive;
                    if (jdbcExecutor == null) break block5;
                    boolean bl = alive = !jdbcExecutor.getConnection().isClosed();
                    if (alive) {
                        jdbcExecutor.testAlive();
                    }
                    aliveCheckResponse = new AliveCheckResponse(alive);
                }
                catch (Exception e2) {
                    try {
                        aliveCheckResponse = new AliveCheckResponse(false);
                        e2.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        ServerUtil.writeJSONResponse(exchange, aliveCheckResponse);
                        throw throwable;
                    }
                    ServerUtil.writeJSONResponse(exchange, aliveCheckResponse);
                }
            }
            ServerUtil.writeJSONResponse(exchange, aliveCheckResponse);
        });
        server.createContext("/", exchange -> {
            String filePath = exchange.getRequestURI().getPath();
            if (filePath.equals("/")) {
                filePath = "/index.html";
            }
            String extension = filePath.substring(filePath.lastIndexOf(".") + 1).toLowerCase();
            String contentType = JdbcExecutorServer.getContentType(extension);
            InputStream inputStream = JdbcExecutorServer.class.getClassLoader().getResourceAsStream("static" + filePath);
            if (inputStream == null) {
                log.error("Resource not found: " + filePath);
                ServerUtil.notFound(exchange);
            } else {
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                inputStream.close();
                ServerUtil.writeResponse(exchange, bytes, contentType);
            }
        });
        server.setExecutor(Executors.newCachedThreadPool());
        server.start();
        log.info("HTTP server started on port {}, Cost time: {} ms", (Object)server.getAddress().getPort(), (Object)(new Date().getTime() - start));
        log.info("JAVA library path: {}", (Object)LibraryUtils.getJavaLibraryPath());
    }

    private static String getContentType(String extension) {
        switch (extension) {
            case "html": 
            case "htm": {
                return "text/html; charset=UTF-8";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
            case "ico": {
                return "image/x-icon";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
        }
        return "application/octet-stream";
    }
}

