/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator
implements Abbreviator {
    final int targetLength;

    public TargetLengthBasedClassNameAbbreviator(int targetLength) {
        this.targetLength = targetLength;
    }

    @Override
    public String abbreviate(String fqClassName) {
        StringBuilder buf = new StringBuilder(this.targetLength);
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int inLen = fqClassName.length();
        if (inLen < this.targetLength) {
            return fqClassName;
        }
        int[] dotIndexesArray = new int[16];
        int[] lengthArray = new int[17];
        int dotCount = TargetLengthBasedClassNameAbbreviator.computeDotIndexes(fqClassName, dotIndexesArray);
        if (dotCount == 0) {
            return fqClassName;
        }
        this.computeLengthArray(fqClassName, dotIndexesArray, lengthArray, dotCount);
        for (int i2 = 0; i2 <= dotCount; ++i2) {
            if (i2 == 0) {
                buf.append(fqClassName.substring(0, lengthArray[i2] - 1));
                continue;
            }
            buf.append(fqClassName.substring(dotIndexesArray[i2 - 1], dotIndexesArray[i2 - 1] + lengthArray[i2]));
        }
        return buf.toString();
    }

    static int computeDotIndexes(String className, int[] dotArray) {
        int dotCount;
        int k2 = 0;
        for (dotCount = 0; (k2 = className.indexOf(46, k2)) != -1 && dotCount < 16; ++dotCount) {
            dotArray[dotCount] = k2++;
        }
        return dotCount;
    }

    void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        int toTrim = className.length() - this.targetLength;
        for (int i2 = 0; i2 < dotCount; ++i2) {
            int available;
            int len;
            int previousDotPosition = -1;
            if (i2 > 0) {
                previousDotPosition = dotArray[i2 - 1];
            }
            int n2 = len = (available = dotArray[i2] - previousDotPosition - 1) < 1 ? available : 1;
            len = toTrim > 0 ? (available < 1 ? available : 1) : available;
            toTrim -= available - len;
            lengthArray[i2] = len + 1;
        }
        int lastDotIndex = dotCount - 1;
        lengthArray[dotCount] = className.length() - dotArray[lastDotIndex];
    }

    static void printArray(String msg, int[] ia) {
        System.out.print(msg);
        for (int i2 = 0; i2 < ia.length; ++i2) {
            if (i2 == 0) {
                System.out.print(ia[i2]);
                continue;
            }
            System.out.print(", " + ia[i2]);
        }
        System.out.println();
    }
}

