/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.TemplateRootPath;
import com.redhat.qute.jdt.internal.template.rootpath.TemplateRootPathProviderRegistry;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import com.redhat.qute.jdt.utils.TemplateNameStrategy;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import io.quarkus.runtime.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;

public class JDTQuteProjectUtils {
    private static final Logger LOGGER = Logger.getLogger(JDTQuteProjectUtils.class.getName());
    public static final String DEFAULTED = "<<defaulted>>";

    private JDTQuteProjectUtils() {
    }

    public static ProjectInfo getProjectInfo(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        String projectUri = JDTQuteProjectUtils.getProjectURI(project);
        List<String> projectDependencies = Collections.emptyList();
        try {
            String[] requiredProjectNames = javaProject.getRequiredProjectNames();
            if (requiredProjectNames != null) {
                projectDependencies = Arrays.asList(requiredProjectNames);
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting project dependencies for '" + javaProject.getElementName() + "' Java project.", e);
        }
        List<TemplateRootPath> templateRootPaths = TemplateRootPathProviderRegistry.getInstance().getTemplateRootPaths(javaProject, null);
        return new ProjectInfo(projectUri, projectDependencies, templateRootPaths);
    }

    public static String getProjectUri(IJavaProject project) {
        return JDTQuteProjectUtils.getProjectURI(project.getProject());
    }

    public static String getProjectURI(IProject project) {
        return project.getName();
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasQuteSupport(IJavaProject javaProject) {
        return JDTTypeUtils.findType(javaProject, "io.quarkus.qute.EngineBuilder") != null;
    }

    public static TemplatePathInfo getTemplatePath(String basePath, String className, String methodOrFieldName, boolean ignoreFragments, TemplateNameStrategy templateNameStrategy) {
        String fragmentId = null;
        StringBuilder templateUri = new StringBuilder("src/main/resources/templates/");
        if (basePath != null && !DEFAULTED.equals(basePath)) {
            JDTQuteProjectUtils.appendAndSlash(templateUri, basePath);
        } else if (className != null) {
            JDTQuteProjectUtils.appendAndSlash(templateUri, className);
        }
        if (!ignoreFragments) {
            int fragmentIndex;
            int n = fragmentIndex = methodOrFieldName != null ? methodOrFieldName.lastIndexOf(36) : -1;
            if (fragmentIndex != -1) {
                fragmentId = methodOrFieldName.substring(fragmentIndex + 1, methodOrFieldName.length());
                methodOrFieldName = methodOrFieldName.substring(0, fragmentIndex);
            }
        }
        templateUri.append(JDTQuteProjectUtils.defaultedName(templateNameStrategy, methodOrFieldName));
        return new TemplatePathInfo(templateUri.toString(), fragmentId);
    }

    private static String defaultedName(TemplateNameStrategy defaultNameStrategy, final String value) {
        switch (defaultNameStrategy) {
            case ELEMENT_NAME: {
                return value;
            }
            case HYPHENATED_ELEMENT_NAME: {
                return StringUtil.hyphenate(value);
            }
            case UNDERSCORED_ELEMENT_NAME: {
                return String.join((CharSequence)"_", (Iterable<? extends CharSequence>)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return StringUtil.lowerCase(StringUtil.camelHumpsIterator(value));
                    }
                });
            }
        }
        return value;
    }

    public static void appendAndSlash(StringBuilder path, String segment) {
        path.append(segment);
        if (!segment.endsWith("/")) {
            path.append('/');
        }
    }

    public static CompilationUnit getASTRoot(ITypeRoot typeRoot) {
        return ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)typeRoot), null);
    }
}

